/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;

public class SmallHtmlAttributeSet
implements AttributeSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    final Object[] keys;
    final Object[] values;
    final AttributeSet parent;

    public SmallHtmlAttributeSet(AttributeSet attributeSet) {
        int n = attributeSet.getAttributeCount();
        this.keys = new Object[n];
        this.values = new Object[n];
        this.parent = attributeSet.getResolveParent();
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object obj = enumeration.nextElement();
            this.keys[i] = obj;
            this.values[i] = object = attributeSet.getAttribute(obj);
        }
    }

    public boolean containsAttribute(Object object, Object object2) {
        Object object3 = this.getAttribute(object);
        if (object2 == null) {
            return object2 == object3;
        }
        return object2.equals(object3);
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        if (attributeSet == this) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            Object object = attributeSet.getAttribute(this.keys[i]);
            if (object == this.values[i]) continue;
            if (this.values[i] == null) {
                return false;
            }
            if (this.values[i].equals(object)) continue;
            return false;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        return this;
    }

    public Object getAttribute(Object object) {
        if (object == null || object instanceof HTML.Attribute || object instanceof HTML.Tag) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] != object) continue;
                return this.values[i];
            }
        } else if (object instanceof String) {
            String string = (String)object;
            for (int i = 0; i < this.keys.length; ++i) {
                if (!(this.keys[i] instanceof String) || !string.equalsIgnoreCase((String)this.keys[i])) continue;
                return this.values[i];
            }
        } else {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!object.equals(this.keys[i])) continue;
                return this.values[i];
            }
        }
        if (this.parent != null) {
            return this.parent.getAttribute(object);
        }
        return null;
    }

    public int getAttributeCount() {
        return this.keys.length;
    }

    public Enumeration getAttributeNames() {
        return new Enumeration(){
            int p = 0;

            public boolean hasMoreElements() {
                return this.p < SmallHtmlAttributeSet.this.keys.length;
            }

            public Object nextElement() {
                if (this.p < SmallHtmlAttributeSet.this.keys.length) {
                    return SmallHtmlAttributeSet.this.keys[this.p++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public AttributeSet getResolveParent() {
        return this.parent;
    }

    public boolean isDefined(Object object) {
        if (object instanceof String) {
            object = ((String)object).toLowerCase();
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!object.equals(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(AttributeSet attributeSet) {
        return this.keys.length == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
    }

    protected Object clone() {
        return this;
    }
}

