/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser;

import gnu.javax.swing.text.html.parser.support.Parser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.text.html.parser.TagElement;

public class GnuParserDelegator
extends ParserDelegator
implements Serializable {
    private static final long serialVersionUID = -1276686502624777206L;
    private DTD theDtd;
    HTMLEditorKit.ParserCallback callBack;
    gnuParser gnu;

    public GnuParserDelegator(DTD dTD) {
        this.theDtd = dTD;
        this.gnu = new gnuParser(dTD);
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback parserCallback, boolean bl) throws IOException {
        this.callBack = parserCallback;
        this.gnu.parse(reader);
        this.callBack.handleEndOfLineString(this.gnu.getEndOfLineSequence());
        try {
            this.callBack.flush();
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    class gnuParser
    extends Parser {
        private static final long serialVersionUID = 1L;

        gnuParser(DTD dTD) {
            super(dTD);
        }

        protected final void handleComment(char[] cArray) {
            GnuParserDelegator.this.callBack.handleComment(cArray, this.hTag.where.startPosition);
        }

        protected final void handleEmptyTag(TagElement tagElement) throws ChangedCharSetException {
            GnuParserDelegator.this.callBack.handleSimpleTag(tagElement.getHTMLTag(), this.getAttributes(), this.hTag.where.startPosition);
        }

        protected final void handleEndTag(TagElement tagElement) {
            GnuParserDelegator.this.callBack.handleEndTag(tagElement.getHTMLTag(), this.hTag.where.startPosition);
        }

        protected final void handleError(int n, String string) {
            GnuParserDelegator.this.callBack.handleError(string, this.hTag.where.startPosition);
        }

        protected final void handleStartTag(TagElement tagElement) {
            SimpleAttributeSet simpleAttributeSet = GnuParserDelegator.this.gnu.getAttributes();
            if (tagElement.fictional()) {
                simpleAttributeSet.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            }
            GnuParserDelegator.this.callBack.handleStartTag(tagElement.getHTMLTag(), simpleAttributeSet, this.hTag.where.startPosition);
        }

        protected final void handleText(char[] cArray) {
            GnuParserDelegator.this.callBack.handleText(cArray, this.hTag.where.startPosition);
        }

        DTD getDTD() {
            return this.dtd;
        }
    }
}

