/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import gnu.javax.swing.text.html.css.CSSLexicalException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

class CSSScanner {
    static final int IDENT = 1;
    static final int ATKEYWORD = 2;
    static final int STRING = 3;
    static final int INVALID = 4;
    static final int HASH = 5;
    static final int NUMBER = 6;
    static final int PERCENTAGE = 7;
    static final int DIMENSION = 8;
    static final int URI = 9;
    static final int UNICODE_RANGE = 10;
    static final int CDO = 11;
    static final int CDC = 12;
    static final int SEMICOLON = 13;
    static final int CURLY_LEFT = 14;
    static final int CURLY_RIGHT = 15;
    static final int PAREN_LEFT = 16;
    static final int PAREN_RIGHT = 17;
    static final int BRACE_LEFT = 16;
    static final int BRACE_RIGHT = 17;
    static final int S = 18;
    static final int COMMENT = 19;
    static final int FUNCTION = 20;
    static final int INCLUDES = 21;
    static final int DASHMATCH = 22;
    static final int DELIM = 23;
    static final int EOF = -1;
    private Reader in;
    char[] parseBuffer;
    int tokenEnd;
    private int[] lookahead = new int[2];

    CSSScanner(Reader reader) {
        this.lookahead[0] = -1;
        this.lookahead[1] = -1;
        this.parseBuffer = new char[2048];
        this.in = reader;
    }

    int nextToken() throws IOException {
        this.tokenEnd = 0;
        int n = -1;
        int n2 = this.read();
        if (n2 != -1) {
            switch (n2) {
                case 59: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 13;
                    break;
                }
                case 123: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 14;
                    break;
                }
                case 125: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 15;
                    break;
                }
                case 40: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 16;
                    break;
                }
                case 41: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 17;
                    break;
                }
                case 91: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 16;
                    break;
                }
                case 93: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 17;
                    break;
                }
                case 64: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    this.readIdent();
                    n = 2;
                    break;
                }
                case 35: {
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    this.readName();
                    n = 5;
                    break;
                }
                case 34: 
                case 39: {
                    this.lookahead[0] = n2;
                    this.readString();
                    n = 3;
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    this.lookahead[0] = n2;
                    this.readWhitespace();
                    n = 18;
                    break;
                }
                case 60: {
                    this.parseBuffer[0] = (char)n2;
                    this.parseBuffer[1] = (char)this.read();
                    this.parseBuffer[2] = (char)this.read();
                    this.parseBuffer[3] = (char)this.read();
                    if (this.parseBuffer[1] == '!' && this.parseBuffer[2] == '-' && this.parseBuffer[3] == '-') {
                        n = 11;
                        this.tokenEnd = 4;
                        break;
                    }
                    throw new CSSLexicalException("expected CDO token");
                }
                case 47: {
                    this.lookahead[0] = n2;
                    this.readComment();
                    n = 19;
                    break;
                }
                case 126: {
                    this.parseBuffer[0] = (char)n2;
                    this.parseBuffer[1] = (char)this.read();
                    if (this.parseBuffer[1] == '=') {
                        n = 21;
                        break;
                    }
                    throw new CSSLexicalException("expected INCLUDES token");
                }
                case 124: {
                    this.parseBuffer[0] = (char)n2;
                    this.parseBuffer[1] = (char)this.read();
                    if (this.parseBuffer[1] == '=') {
                        n = 22;
                        break;
                    }
                    throw new CSSLexicalException("expected DASHMATCH token");
                }
                case 45: {
                    int n3 = this.read();
                    if (n3 == 45) {
                        int n4 = this.read();
                        if (n4 == 62) {
                            this.parseBuffer[0] = (char)n2;
                            this.parseBuffer[1] = (char)n3;
                            this.parseBuffer[2] = (char)n4;
                            this.tokenEnd = 3;
                            n = 12;
                            break;
                        }
                        throw new CSSLexicalException("expected CDC token");
                    }
                    this.lookahead[0] = n2;
                    this.lookahead[1] = n3;
                    this.readIdent();
                    int n5 = this.read();
                    if (n5 == -1 || n5 != 40) {
                        this.lookahead[0] = n5;
                        n = 1;
                        break;
                    }
                    this.parseBuffer[this.tokenEnd] = (char)n5;
                    ++this.tokenEnd;
                    n = 20;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.lookahead[0] = n2;
                    this.readNum();
                    int n6 = this.read();
                    if (n6 == 37) {
                        this.parseBuffer[this.tokenEnd] = (char)n6;
                        ++this.tokenEnd;
                        n = 7;
                        break;
                    }
                    if (n6 == -1 || n6 != 95 && (n6 < 97 || n6 > 122) && (n6 < 65 || n6 > 90) && n6 != 92 && n6 <= 177) {
                        this.lookahead[0] = n6;
                        n = 6;
                        break;
                    }
                    this.lookahead[0] = n6;
                    this.readIdent();
                    n = 8;
                    break;
                }
                default: {
                    if (n2 == 95 || n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 92 || n2 > 177) {
                        this.lookahead[0] = n2;
                        this.readIdent();
                        int n7 = this.read();
                        if (n7 == -1 || n7 != 40) {
                            this.lookahead[0] = n7;
                            n = 1;
                            break;
                        }
                        this.parseBuffer[this.tokenEnd] = (char)n7;
                        ++this.tokenEnd;
                        n = 20;
                        break;
                    }
                    this.parseBuffer[0] = (char)n2;
                    this.tokenEnd = 1;
                    n = 23;
                }
            }
        }
        return n;
    }

    String currentTokenString() {
        return new String(this.parseBuffer, 0, this.tokenEnd);
    }

    private int read() throws IOException {
        int n;
        if (this.lookahead[0] != -1) {
            n = this.lookahead[0];
            this.lookahead[0] = -1;
        } else if (this.lookahead[1] != -1) {
            n = this.lookahead[1];
            this.lookahead[1] = -1;
        } else {
            n = this.in.read();
        }
        return n;
    }

    private void readIdent() throws IOException {
        int n = this.read();
        if (n == 45) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
            n = this.read();
        }
        if (n == 95 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n > 177) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
        } else if (n == 92) {
            this.lookahead[0] = n;
            this.readEscape();
        } else {
            throw new CSSLexicalException("First character of identifier incorrect");
        }
        int n2 = this.read();
        while (n2 != -1 && (n2 == 95 || n2 == 45 || n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)n2;
            ++this.tokenEnd;
            n2 = this.read();
        }
        this.lookahead[0] = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readEscape() throws IOException {
        int n = this.read();
        if (n == -1 || n != 92) throw new CSSLexicalException("Escape must start with '\\'");
        this.parseBuffer[this.tokenEnd] = (char)n;
        ++this.tokenEnd;
        n = this.read();
        if (n >= 48 && n <= 57 || n >= 97 && n <= 102) {
            n = this.read();
            for (int i = 0; (n >= 48 && n <= 57 || n >= 97 && n <= 102) && i < 5; ++i) {
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                n = this.read();
            }
            if (n == 13) {
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                n = this.read();
                if (n == 10) {
                    this.parseBuffer[this.tokenEnd] = (char)n;
                    ++this.tokenEnd;
                    return;
                } else {
                    this.lookahead[0] = n;
                }
                return;
            } else if (n == 32 || n == 10 || n == 12 || n == 9) {
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                return;
            } else {
                this.lookahead[0] = n;
            }
            return;
        } else {
            if (n == 10 || n == 13 || n == 12) throw new CSSLexicalException("Can't read escape");
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
        }
    }

    private void readName() throws IOException {
        int n = this.read();
        if (n != -1 && (n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
        } else {
            throw new CSSLexicalException("Invalid name");
        }
        n = this.read();
        while (n != -1 && (n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57)) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
            n = this.read();
        }
        this.lookahead[0] = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readString() throws IOException {
        int n = this.read();
        if (n == -1 || n != 39 && n != 34) throw new CSSLexicalException("Invalid string");
        this.parseBuffer[this.tokenEnd] = (char)n;
        ++this.tokenEnd;
        int n2 = this.read();
        while (n2 != -1 && n2 != n) {
            if (n2 != 10 && n2 != 13 && n2 != 12 && n2 != 92) {
                this.parseBuffer[this.tokenEnd] = (char)n2;
                ++this.tokenEnd;
            } else {
                if (n2 != 92) throw new CSSLexicalException("Invalid string");
                int n3 = this.read();
                if (n3 == 10 || n3 == 13) {
                    this.parseBuffer[this.tokenEnd] = (char)n2;
                    this.parseBuffer[this.tokenEnd + 1] = (char)n3;
                    this.tokenEnd += 2;
                } else {
                    this.lookahead[0] = n2;
                    this.lookahead[1] = n3;
                    this.readEscape();
                }
            }
            n2 = this.read();
        }
        if (n2 == -1) throw new CSSLexicalException("Unterminated string");
        this.parseBuffer[this.tokenEnd] = (char)n2;
        ++this.tokenEnd;
    }

    private void readWhitespace() throws IOException {
        int n = this.read();
        while (n != -1 && (n == 32 || n == 9 || n == 13 || n == 10 || n == 12)) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
            n = this.read();
        }
        this.lookahead[0] = n;
    }

    private void readURI() throws IOException {
    }

    private void readComment() throws IOException {
        int n = this.read();
        if (n != -1 && n == 47) {
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
            n = this.read();
            if (n != -1 && n == 42) {
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                n = this.read();
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                boolean bl = false;
                int n2 = n;
                n = this.read();
                while (!bl && n != -1) {
                    if (n2 == 42 && n == 47) {
                        bl = true;
                    }
                    this.parseBuffer[this.tokenEnd] = (char)n;
                    ++this.tokenEnd;
                    n2 = n;
                    n = this.read();
                }
            }
        }
        if (n == -1) {
            throw new CSSLexicalException("Unterminated comment");
        }
        this.lookahead[0] = n;
    }

    private void readNum() throws IOException {
        boolean bl = false;
        int n = this.read();
        if (n != -1 && (n >= 48 && n <= 57 || n == 46)) {
            if (n == 46) {
                bl = true;
            }
            this.parseBuffer[this.tokenEnd] = (char)n;
            ++this.tokenEnd;
            n = this.read();
            while (n != -1 && (n >= 48 && n <= 57 || n == 46 && !bl)) {
                if (n == 46) {
                    bl = true;
                }
                this.parseBuffer[this.tokenEnd] = (char)n;
                ++this.tokenEnd;
                n = this.read();
            }
        } else {
            throw new CSSLexicalException("Invalid number");
        }
        if (this.parseBuffer[this.tokenEnd - 1] == '.') {
            throw new CSSLexicalException("Invalid number");
        }
        this.lookahead[0] = n;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            String string = "/javax/swing/text/html/default.css";
            InputStream inputStream = CSSScanner.class.getResourceAsStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            CSSScanner cSSScanner = new CSSScanner(inputStreamReader);
            do {
                n = cSSScanner.nextToken();
                System.out.println("token: " + n + ": " + cSSScanner.currentTokenString());
            } while (n != -1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

