/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html;

import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

public class CombinedAttributes
implements AttributeSet,
Serializable {
    final AttributeSet a;
    final AttributeSet b;

    public static AttributeSet combine(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet == null) {
            return attributeSet2;
        }
        if (attributeSet2 == null) {
            return attributeSet;
        }
        return new CombinedAttributes(attributeSet, attributeSet2);
    }

    private CombinedAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        this.a = attributeSet;
        this.b = attributeSet2;
    }

    public boolean containsAttribute(Object object, Object object2) {
        return this.a.containsAttribute(object, object2) || this.b.containsAttribute(object, object2);
    }

    public boolean containsAttributes(AttributeSet attributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (this.containsAttribute(obj, attributeSet.getAttribute(obj))) continue;
            return false;
        }
        return true;
    }

    public AttributeSet copyAttributes() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttributes(this.a);
        simpleAttributeSet.addAttributes(this.b);
        return simpleAttributeSet;
    }

    public Object getAttribute(Object object) {
        Object object2 = this.a.getAttribute(object);
        if (object2 == null) {
            object2 = this.b.getAttribute(object);
        }
        return object2;
    }

    public int getAttributeCount() {
        return this.a.getAttributeCount() + this.b.getAttributeCount();
    }

    public Enumeration getAttributeNames() {
        return new CombinedEnumeration(this.a.getAttributeNames(), this.b.getAttributeNames());
    }

    public AttributeSet getResolveParent() {
        return null;
    }

    public boolean isDefined(Object object) {
        return this.a.isDefined(object) || this.b.isDefined(object);
    }

    public boolean isEqual(AttributeSet attributeSet) {
        if (attributeSet.getAttributeCount() == this.getAttributeCount()) {
            return this.containsAttributes(attributeSet);
        }
        return false;
    }

    class CombinedEnumeration
    implements Enumeration {
        final Enumeration a;
        final Enumeration b;

        CombinedEnumeration(Enumeration enumeration, Enumeration enumeration2) {
            this.a = enumeration;
            this.b = enumeration2;
        }

        public boolean hasMoreElements() {
            return this.a.hasMoreElements() || this.b.hasMoreElements();
        }

        public Object nextElement() {
            return this.a.hasMoreElements() ? this.a.nextElement() : this.b.nextElement();
        }
    }
}

