/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.lines;

import gnu.javax.sound.AudioSecurityManager;
import gnu.javax.sound.sampled.gstreamer.lines.GstDataLine;
import gnu.javax.sound.sampled.gstreamer.lines.GstNativeDataLine;
import gnu.javax.sound.sampled.gstreamer.lines.GstPipeline;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class GstSourceDataLine
extends GstDataLine
implements SourceDataLine {
    private GstPipeline pipeline = null;
    private boolean open = false;

    public GstSourceDataLine(AudioFormat audioFormat) {
        super(audioFormat);
    }

    public void open() throws LineUnavailableException {
        AudioSecurityManager.checkPermissions(AudioSecurityManager.Permission.PLAY);
        if (this.open) {
            throw new IllegalStateException("Line already opened");
        }
        this.pipeline = GstNativeDataLine.createSourcePipeline(this.getBufferSize());
        this.open = true;
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        AudioSecurityManager.checkPermissions(AudioSecurityManager.Permission.PLAY);
        this.setFormat(audioFormat);
        this.open();
    }

    public void open(AudioFormat audioFormat, int n) throws LineUnavailableException {
        AudioSecurityManager.checkPermissions(AudioSecurityManager.Permission.PLAY);
        this.setBufferSize(n);
        this.open(audioFormat);
    }

    public int write(byte[] byArray, int n, int n2) {
        return this.pipeline.write(byArray, n, n2);
    }

    public int available() {
        return this.pipeline.available();
    }

    public void drain() {
        this.pipeline.drain();
    }

    public void flush() {
        this.pipeline.flush();
    }

    public int getFramePosition() {
        System.out.println("getFramePosition -: IMPLEMENT ME!!");
        return 0;
    }

    public long getLongFramePosition() {
        System.out.println("getLongFramePosition -: IMPLEMENT ME!!");
        return 0L;
    }

    public long getMicrosecondPosition() {
        System.out.println("getMicrosecondPosition -: IMPLEMENT ME!!");
        return 0L;
    }

    public boolean isActive() {
        GstPipeline.State state = this.pipeline.getState();
        return state == GstPipeline.State.PLAY || state == GstPipeline.State.PAUSE;
    }

    public void start() {
        this.pipeline.setState(GstPipeline.State.PLAY);
    }

    public void stop() {
        this.pipeline.setState(GstPipeline.State.PAUSE);
    }

    public void close() {
        this.pipeline.close();
        this.open = false;
    }

    public boolean isRunning() {
        return this.pipeline.getState() == GstPipeline.State.PLAY;
    }
}

