/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.lines;

import gnu.classpath.Pointer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.sound.sampled.LineUnavailableException;

public class GstPipeline {
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int QUEUED = 1;
    private static final String CAPACITY_KEY = "Capacity";
    private static final Object[] lock = new Object[0];
    protected Preferences prefs = Preferences.userNodeForPackage(GstPipeline.class).node("GStreamer");
    private long capacity = -1L;
    private State state = State.STOP;
    private String name = null;
    private FileOutputStream output = null;
    private boolean source = true;
    private boolean ready = false;
    private Pointer pipeline = null;

    public GstPipeline() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public GstPipeline(int n) {
        this.capacity = this.prefs.getLong(CAPACITY_KEY, -1L);
        if (this.capacity == -1L) {
            Object[] objectArray = lock;
            // MONITORENTER : lock
            this.capacity = this.detect_pipe_size();
            // MONITOREXIT : objectArray
            this.prefs.putLong(CAPACITY_KEY, this.capacity);
        }
        this.init_instance();
        Runtime.getRuntime().addShutdownHook(new CleanPipeline());
    }

    public void createForWrite() throws LineUnavailableException {
        if (!this.create_named_pipe(this.pipeline)) {
            throw new LineUnavailableException("Unable to create filesystem pipe");
        }
        GstPipeline.open_native_pipe(this.pipeline, 0);
        this.prepareWrite();
        this.source = true;
    }

    public State getState() {
        return this.state;
    }

    public void close() {
        this.setState(State.STOP);
    }

    public void setState(State state) {
        int n = -1;
        switch (state) {
            case PLAY: {
                n = 0;
                break;
            }
            case PAUSE: {
                n = 1;
                break;
            }
            case STOP: 
            case CLOSE: {
                n = 2;
                this.closePipe();
            }
        }
        if (GstPipeline.set_state(this.pipeline, n)) {
            this.state = state;
        }
    }

    public Pointer getNativeClass() {
        return this.pipeline;
    }

    public int write(byte[] byArray, int n, int n2) {
        if (this.state == State.STOP) {
            return -1;
        }
        if (this.state == State.PAUSE) {
            return 0;
        }
        if (!this.ready) {
            return -1;
        }
        try {
            if (this.output != null) {
                this.output.write(byArray, n, n2);
                return n2;
            }
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int read(byte[] byArray, int n, int n2) {
        return 0;
    }

    public int available() {
        if (this.source) {
            return GstPipeline.available(this.pipeline, 0);
        }
        return GstPipeline.available(this.pipeline, 1);
    }

    public void drain() {
        if (this.state == State.STOP) {
            return;
        }
        try {
            while (GstPipeline.available(this.pipeline, 1) > 0) {
                Thread.sleep(3000L);
            }
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            if (this.source) {
                this.output.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closePipe() {
        try {
            this.flush();
            if (this.source) {
                this.output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void prepareWrite() {
        try {
            this.ready = true;
            this.output = new FileOutputStream(this.name);
        }
        catch (Exception exception) {
            this.ready = false;
        }
    }

    private static final native void init_id_cache();

    private static final native boolean set_state(Pointer var0, int var1);

    private static final native int available(Pointer var0, int var1);

    private static final native void open_native_pipe(Pointer var0, int var1);

    private static final native void close_native_pipe(Pointer var0);

    private final native void init_instance();

    private final native boolean create_named_pipe(Pointer var1);

    private final native long detect_pipe_size();

    static {
        System.loadLibrary("gstreamerpeer");
        GstPipeline.init_id_cache();
    }

    private class CleanPipeline
    extends Thread {
        private CleanPipeline() {
        }

        public void run() {
            GstPipeline.close_native_pipe(GstPipeline.this.pipeline);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        PLAY,
        PAUSE,
        STOP,
        CLOSE;

    }
}

