/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.io;

import gnu.classpath.Pointer;
import gnu.javax.sound.sampled.gstreamer.io.GstInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.sound.sampled.AudioFormat;

final class GstAudioFileReaderNativePeer {
    private static final String GST_ENCODING = "GStreamer Generic Audio Reader";

    GstAudioFileReaderNativePeer() {
    }

    public static AudioFormat getAudioFormat(File file) throws Exception {
        GstHeader gstHeader = new GstHeader();
        gstHeader.file = file.getAbsolutePath();
        if (!GstAudioFileReaderNativePeer.gstreamer_get_audio_format_file(gstHeader)) {
            return null;
        }
        return GstAudioFileReaderNativePeer.getAudioFormat(gstHeader);
    }

    public static AudioFormat getAudioFormat(InputStream inputStream) throws Exception {
        return GstAudioFileReaderNativePeer.getAudioFormat(inputStream, new GstHeader());
    }

    public static AudioFormat getAudioFormat(URL uRL) throws Exception {
        GstHeader gstHeader = new GstHeader();
        gstHeader.file = uRL.toExternalForm();
        return GstAudioFileReaderNativePeer.getAudioFormat(uRL.openStream(), gstHeader);
    }

    private static AudioFormat getAudioFormat(InputStream inputStream, GstHeader gstHeader) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        if (!bufferedInputStream.markSupported()) {
            throw new IOException("Stream must support marking.");
        }
        bufferedInputStream.mark(0);
        if (!GstAudioFileReaderNativePeer.gstreamer_get_audio_format_stream(gstHeader, new GstInputStream(bufferedInputStream).getNativeClass())) {
            return null;
        }
        return GstAudioFileReaderNativePeer.getAudioFormat(gstHeader);
    }

    private static AudioFormat.Encoding getEncoding(GstHeader gstHeader) {
        StringBuilder stringBuilder = new StringBuilder();
        if (gstHeader.name == null) {
            stringBuilder.append(GST_ENCODING);
            if (gstHeader.mimetype != null) {
                stringBuilder.append(" ");
                stringBuilder.append(gstHeader.mimetype);
            }
            gstHeader.name = stringBuilder.toString();
        } else {
            String string = gstHeader.name.toLowerCase();
            int n = string.indexOf("decoder");
            if (n == -1) {
                n = string.indexOf("demuxer");
            }
            if (n == -1) {
                n = string.length();
            }
            stringBuilder.append(gstHeader.name.substring(0, n));
        }
        return new AudioFormat.Encoding(stringBuilder.toString().trim());
    }

    private static AudioFormat getAudioFormat(GstHeader gstHeader) throws Exception {
        int n = -1;
        AudioFormat.Encoding encoding = GstAudioFileReaderNativePeer.getEncoding(gstHeader);
        float f = gstHeader.rate != null ? new Float(gstHeader.rate).floatValue() : (float)n;
        int n2 = gstHeader.depth != null ? new Integer(gstHeader.depth) : n;
        int n3 = gstHeader.channels != null ? new Integer(gstHeader.channels) : n;
        boolean bl = false;
        if (gstHeader.endianness != null && gstHeader.endianness.compareTo("4321") == 0) {
            bl = true;
        }
        String string = null;
        int n4 = n;
        float f2 = n;
        String string2 = gstHeader.name.toLowerCase();
        if (string2.contains("law") || string2.contains("au")) {
            n4 = (n2 >> 3) * n3;
            f2 = f;
            string = "au";
        } else if (string2.contains("wav")) {
            n4 = (n2 + 7) / 8 * n3;
            f2 = f;
            string = "wav";
        } else if (string2.contains("iff")) {
            n4 = n2 * n3 / 8;
            f2 = f;
            string = "aiff";
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Classpath GStreamer Sound Audio Engine", true);
        hashMap.put("decoder", gstHeader.name);
        hashMap.put("type", encoding.toString());
        if (string != null) {
            hashMap.put("ext", string);
        }
        if (gstHeader.type != null) {
            hashMap.put("type", gstHeader.type);
        }
        if (gstHeader.framed != null) {
            hashMap.put("framed", gstHeader.framed);
        }
        if (gstHeader.bitrate != null) {
            hashMap.put("bitrate", gstHeader.bitrate);
        }
        if (gstHeader.isSigned != null) {
            hashMap.put("isSigned", gstHeader.isSigned);
        }
        if (gstHeader.depth != null) {
            hashMap.put("depth", gstHeader.depth);
        }
        if (gstHeader.mimetype != null) {
            hashMap.put("mimetype", gstHeader.mimetype);
        }
        AudioFormat audioFormat = new AudioFormat(encoding, f, n2, n3, n4, f2, bl, hashMap);
        return audioFormat;
    }

    protected static final native boolean gstreamer_get_audio_format_stream(GstHeader var0, Pointer var1);

    protected static final native boolean gstreamer_get_audio_format_file(GstHeader var0);

    private static final native void init_id_cache();

    static {
        System.loadLibrary("gstreamerpeer");
        GstAudioFileReaderNativePeer.init_id_cache();
    }

    private static class GstHeader {
        public String file = null;
        public String suffix = null;
        public String name = null;
        public String mimetype = null;
        public String endianness = null;
        public String channels = null;
        public String rate = null;
        public String width = null;
        public String depth = null;
        public String isSigned = null;
        public String layer = null;
        public String bitrate = null;
        public String framed = null;
        public String type = null;

        private GstHeader() {
        }
    }
}

