/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.gstreamer.io;

import gnu.java.lang.CPStringBuilder;
import gnu.javax.sound.sampled.gstreamer.io.GstAudioFileReaderNativePeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class GstAudioFileReader
extends AudioFileReader {
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        CPStringBuilder cPStringBuilder = new CPStringBuilder(file.getName());
        String string = cPStringBuilder.substring(cPStringBuilder.lastIndexOf(".") + 1);
        return this.getAudioFileFormat(new BufferedInputStream(new FileInputStream(file)), string);
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(inputStream, null);
    }

    private AudioFileFormat getAudioFileFormat(InputStream inputStream, String string) throws UnsupportedAudioFileException {
        AudioFormat audioFormat = null;
        try {
            audioFormat = GstAudioFileReaderNativePeer.getAudioFormat(inputStream);
        }
        catch (Exception exception) {
            UnsupportedAudioFileException unsupportedAudioFileException = new UnsupportedAudioFileException("Unsupported encoding.");
            unsupportedAudioFileException.initCause(unsupportedAudioFileException.getCause());
            throw unsupportedAudioFileException;
        }
        if (audioFormat == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        String string2 = audioFormat.getProperty("decoder").toString();
        if (string == null) {
            string = audioFormat.getProperty("ext").toString();
        }
        AudioFileFormat.Type type = new AudioFileFormat.Type(string2, string);
        return new AudioFileFormat(type, audioFormat, -1);
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(new BufferedInputStream(uRL.openStream()));
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        AudioFormat audioFormat = null;
        try {
            audioFormat = GstAudioFileReaderNativePeer.getAudioFormat(file);
        }
        catch (Exception exception) {
            UnsupportedAudioFileException unsupportedAudioFileException = new UnsupportedAudioFileException("Unsupported encoding.");
            unsupportedAudioFileException.initCause(unsupportedAudioFileException.getCause());
            throw unsupportedAudioFileException;
        }
        if (audioFormat == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        return new AudioInputStream(fileInputStream, audioFormat, l);
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        try {
            audioFormat = GstAudioFileReaderNativePeer.getAudioFormat(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (audioFormat == null) {
            throw new UnsupportedAudioFileException("Unsupported encoding.");
        }
        return new AudioInputStream(inputStream, audioFormat, -1L);
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new BufferedInputStream(uRL.openStream()));
    }
}

