/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class GnuConfiguration
extends Configuration {
    private static final Logger log = null;
    private Map loginModulesMap = new HashMap();
    private ConfigFileParser cp = new ConfigFileParser();

    public GnuConfiguration() {
        this.init();
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        List list2 = (List)this.loginModulesMap.get(string);
        if (list2 == null || list2.size() == 0) {
            return null;
        }
        return list2.toArray(new AppConfigurationEntry[0]);
    }

    public void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        this.loginModulesMap.clear();
        this.init();
    }

    private void init() {
        if (this.processSecurityProperties() || this.processSystemProperty() || this.processUserHome()) {
            // empty if block
        }
    }

    private boolean processSecurityProperties() {
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                String string;
                while ((string = Security.getProperty("java.security.auth.login.config.url." + ++n)) != null) {
                    if ((string = string.trim()).length() == 0) continue;
                    this.parseConfig(this.getInputStreamFromURL(string));
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
        return bl;
    }

    private InputStream getInputStreamFromURL(String string) throws IOException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    private boolean processSystemProperty() {
        boolean bl = false;
        try {
            String string = System.getProperty("java.security.auth.login.config");
            if (string != null && (string = string.trim()).length() != 0) {
                this.parseConfig(this.getInputStreamFromURL(string));
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private boolean processUserHome() {
        boolean bl = false;
        try {
            File file = this.getUserHome();
            if (file == null) {
                return bl;
            }
            File file2 = this.getConfigFromUserHome(file, ".java.login.config");
            if (file2 == null) {
                file2 = this.getConfigFromUserHome(file, "java.login.config");
            }
            if (file2 == null) {
                return bl;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            this.parseConfig(fileInputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private void parseConfig(InputStream inputStream) throws IOException {
        this.cp.parse(new InputStreamReader(inputStream, "UTF-8"));
        Map map = this.cp.getLoginModulesMap();
        this.mergeLoginModules(map);
    }

    private void mergeLoginModules(Map map) {
        if (map == null || map.size() < 1) {
            return;
        }
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            if (list2 == null || list2.size() < 1) continue;
            List list3 = (List)this.loginModulesMap.get(string);
            if (list3 == null) {
                this.loginModulesMap.put(string, list2);
                continue;
            }
            list3.addAll(list2);
        }
    }

    private File getUserHome() {
        String string = System.getProperty("user.home");
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        File file = new File(string = string.trim());
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        return file;
    }

    private File getConfigFromUserHome(File file, String string) {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            return null;
        }
        if (!file2.isFile()) {
            return null;
        }
        if (!file2.canRead()) {
            return null;
        }
        return file2;
    }
}

