/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;

public final class ConfigFileParser {
    private static final Logger log = null;
    private ConfigFileTokenizer cft;
    private final Map map = new HashMap();

    public Map getLoginModulesMap() {
        return this.map;
    }

    public void parse(Reader reader) throws IOException {
        this.initParser(reader);
        while (this.parseAppOrOtherEntry()) {
        }
    }

    private void initParser(Reader reader) throws IOException {
        this.map.clear();
        this.cft = new ConfigFileTokenizer(reader);
    }

    private boolean parseAppOrOtherEntry() throws IOException {
        ArrayList arrayList;
        int n = this.cft.nextToken();
        if (n == -1) {
            return false;
        }
        if (n != -3) {
            this.cft.pushBack();
            return false;
        }
        String string = this.cft.sval;
        if (this.cft.nextToken() != 123) {
            this.abort("Missing '{' after APP_NAME_OR_OTHER");
        }
        ArrayList arrayList2 = new ArrayList();
        while (this.parseACE(arrayList2)) {
        }
        n = this.cft.nextToken();
        if (n != 125) {
            this.abort("Was expecting '}' but found " + (char)n);
        }
        if ((n = this.cft.nextToken()) != 59) {
            this.abort("Was expecting ';' but found " + (char)n);
        }
        if ((arrayList = (ArrayList)this.map.get(string)) == null) {
            arrayList = new ArrayList();
            this.map.put(string, arrayList);
        }
        arrayList.addAll(arrayList2);
        return !string.equalsIgnoreCase("other");
    }

    private boolean parseACE(List list2) throws IOException {
        int n = this.cft.nextToken();
        if (n != -3) {
            this.cft.pushBack();
            return false;
        }
        String string = this.validateClassName(this.cft.sval);
        if (this.cft.nextToken() != -3) {
            this.abort("Was expecting FLAG but found none");
        }
        String string2 = this.cft.sval;
        AppConfigurationEntry.LoginModuleControlFlag loginModuleControlFlag = null;
        if (string2.equalsIgnoreCase("required")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (string2.equalsIgnoreCase("requisite")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (string2.equalsIgnoreCase("sufficient")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (string2.equalsIgnoreCase("optional")) {
            loginModuleControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            this.abort("Unknown Flag: " + string2);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        n = this.cft.nextToken();
        while (n != 59) {
            if (n != -3) {
                this.abort("Was expecting PARAM_NAME but got '" + (char)n + "'");
            }
            String string3 = this.cft.sval;
            if (this.cft.nextToken() != 61) {
                this.abort("Missing '=' after PARAM_NAME");
            }
            if ((n = this.cft.nextToken()) == 34 || n != 39) {
                // empty if block
            }
            String string4 = this.expandParamValue(this.cft.sval);
            hashMap.put(string3, string4);
            n = this.cft.nextToken();
        }
        AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(string, loginModuleControlFlag, hashMap);
        list2.add(appConfigurationEntry);
        return true;
    }

    private void abort(String string) throws IOException {
        throw new IOException(string);
    }

    private String validateClassName(String string) throws IOException {
        if (string.startsWith(".") || string.endsWith(".")) {
            this.abort("MODULE_CLASS MUST NOT start or end with a '.'");
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (Character.isJavaIdentifierStart(string2.charAt(0))) continue;
            this.abort("Class name [" + string + "] contains an invalid sub-package identifier: " + string2);
        }
        return string;
    }

    private String expandParamValue(String string) {
        String string2 = string;
        try {
            int n;
            int n2;
            int n3 = 0;
            while (n3 < string2.length() && (n2 = string.indexOf("${", n3)) != -1 && (n = string.indexOf("}", n2 + 2)) != -1) {
                String string3 = string.substring(n2 + 2, n);
                String string4 = System.getProperty(string3);
                if (string4 != null) {
                    string2 = string.substring(0, n2) + string4 + string.substring(n + 1);
                    n3 = n2 + string4.length();
                    continue;
                }
                n3 = n + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

