/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.callback;

import gnu.javax.security.auth.callback.AbstractCallbackHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;

public class ConsoleCallbackHandler
extends AbstractCallbackHandler {
    private final PrintStream out;

    public ConsoleCallbackHandler() {
        this(System.out);
    }

    public ConsoleCallbackHandler(PrintStream printStream) {
        super("CONSOLE");
        this.out = printStream;
    }

    protected void handleChoice(ChoiceCallback choiceCallback) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        this.out.println(choiceCallback.getPrompt());
        this.out.print('(');
        String[] stringArray = choiceCallback.getChoices();
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.print(stringArray[i]);
            if (i == stringArray.length - 1) continue;
            this.out.print(", ");
        }
        this.out.print(") ");
        if (choiceCallback.getDefaultChoice() >= 0 && choiceCallback.getDefaultChoice() < stringArray.length) {
            this.out.print('[');
            this.out.print(stringArray[choiceCallback.getDefaultChoice()]);
            this.out.print("] ");
        }
        if ((string = bufferedReader.readLine()) == null || string.length() == 0) {
            choiceCallback.setSelectedIndex(choiceCallback.getDefaultChoice());
            return;
        }
        if (!choiceCallback.allowMultipleSelections()) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.trim().equals(stringArray[i])) continue;
                choiceCallback.setSelectedIndex(i);
                return;
            }
            choiceCallback.setSelectedIndex(choiceCallback.getDefaultChoice());
        } else {
            int n;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray2 = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n2++] = stringTokenizer.nextToken().trim();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                n = 0;
                while (n < stringArray2.length) {
                    if (stringArray[i].equals(stringArray2[n])) {
                        treeSet.add(i);
                    }
                    ++i;
                }
            }
            if (treeSet.size() == 0) {
                choiceCallback.setSelectedIndex(choiceCallback.getDefaultChoice());
            } else {
                int[] nArray = new int[treeSet.size()];
                n = 0;
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    nArray[n++] = (Integer)iterator.next();
                }
                choiceCallback.setSelectedIndexes(nArray);
            }
        }
    }

    protected void handleConfirmation(ConfirmationCallback confirmationCallback) throws IOException {
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        if (confirmationCallback.getPrompt() != null) {
            this.out.print(confirmationCallback.getPrompt());
        }
        String[] stringArray = null;
        int[] nArray = null;
        switch (confirmationCallback.getOptionType()) {
            case 2: {
                this.out.print(this.messages.getString("callback.okCancel"));
                stringArray = new String[]{this.messages.getString("callback.ok"), this.messages.getString("callback.cancel"), this.messages.getString("callback.shortOk"), this.messages.getString("callback.shortCancel")};
                nArray = new int[]{3, 2, 3, 2};
                break;
            }
            case 1: {
                this.out.print(this.messages.getString("callback.yesNoCancel"));
                stringArray = new String[]{this.messages.getString("callback.yes"), this.messages.getString("callback.no"), this.messages.getString("callback.cancel"), this.messages.getString("callback.shortYes"), this.messages.getString("callback.shortNo"), this.messages.getString("callback.shortCancel")};
                nArray = new int[]{0, 1, 2, 0, 1, 2};
                break;
            }
            case 0: {
                this.out.print(this.messages.getString("callback.yesNo"));
                stringArray = new String[]{this.messages.getString("callback.yes"), this.messages.getString("callback.no"), this.messages.getString("callback.shortYes"), this.messages.getString("callback.shortNo")};
                nArray = new int[]{0, 1, 0, 1};
                int n2 = confirmationCallback.getDefaultOption();
                if (n2 <= -1 || n2 >= stringArray.length) break;
                this.out.print("[");
                this.out.print(stringArray[n2]);
                this.out.print("] ");
                break;
            }
            case -1: {
                stringArray = confirmationCallback.getOptions();
                nArray = new int[stringArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = n;
                }
                this.out.print('(');
                for (n = 0; n < stringArray.length; ++n) {
                    this.out.print(stringArray[n]);
                    if (n == stringArray.length - 1) continue;
                    this.out.print(", ");
                }
                this.out.print(") [");
                this.out.print(stringArray[confirmationCallback.getDefaultOption()]);
                this.out.print("] ");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string = bufferedReader.readLine();
        if (string == null) {
            confirmationCallback.setSelectedIndex(confirmationCallback.getDefaultOption());
            return;
        }
        string = string.trim();
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equalsIgnoreCase(stringArray[n])) continue;
            confirmationCallback.setSelectedIndex(nArray[n]);
            return;
        }
        confirmationCallback.setSelectedIndex(confirmationCallback.getDefaultOption());
    }

    protected void handleLanguage(LanguageCallback languageCallback) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(this.messages.getString("callback.language"));
        String string = null;
        string = bufferedReader.readLine();
        if (string == null) {
            languageCallback.setLocale(Locale.getDefault());
        } else {
            languageCallback.setLocale(new Locale(string.trim()));
        }
    }

    protected void handleName(NameCallback nameCallback) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(nameCallback.getPrompt());
        String string = bufferedReader.readLine();
        if (string != null) {
            nameCallback.setName(string.trim());
        }
    }

    protected void handlePassword(PasswordCallback passwordCallback) throws IOException {
        this.out.print(passwordCallback.getPrompt());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = bufferedReader.readLine();
        passwordCallback.setPassword(string.toCharArray());
    }

    protected void handleTextInput(TextInputCallback textInputCallback) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        this.out.print(textInputCallback.getPrompt());
        String string = bufferedReader.readLine();
        if (string != null) {
            textInputCallback.setText(string);
        }
    }

    protected void handleTextOutput(TextOutputCallback textOutputCallback) {
        this.out.print(textOutputCallback.getMessage());
    }
}

