/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.CharsetSyntax;
import gnu.javax.print.ipp.attribute.NaturalLanguageSyntax;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.job.AttributesCharset;
import gnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DateTimeSyntax;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.ResolutionSyntax;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class IppRequest {
    private static final int timeout = 1000;
    static final Logger logger = SystemLogger.SYSTEM;
    private static int requestIdCounter = 1;
    private static final short VERSION = 257;
    private boolean alreadySent = false;
    private short operation_id;
    private final int request_id = this.incrementRequestIdCounter();
    private AttributeSet operationAttributes;
    private AttributeSet printerAttributes;
    private AttributeSet jobAttributes;
    private Object data;
    private URI requestUri;
    private HttpURLConnection connection;

    public IppRequest(URI uRI, String string, String string2) {
        this.requestUri = uRI;
        try {
            URL uRL = new URL("http", string == null ? uRI.getHost() : string + ":" + string2 + "@" + uRI.getHost(), uRI.getPort(), uRI.getPath());
            this.connection = (HttpURLConnection)uRL.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-type", "application/ipp");
            this.connection.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "Unexpected IOException", iOException);
        }
        logger.log(Component.IPP, "[IppConnection] Host: " + uRI.getHost() + " Port: " + uRI.getPort() + " Path: " + uRI.getPath());
    }

    private synchronized int incrementRequestIdCounter() {
        return requestIdCounter++;
    }

    public int getRequestID() {
        return this.request_id;
    }

    public void setData(InputStream inputStream) {
        this.data = inputStream;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setOperationID(short s) {
        this.operation_id = s;
    }

    public void setOperationAttributeDefaults() {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(AttributesCharset.UTF8);
        this.operationAttributes.add(AttributesNaturalLanguage.EN);
    }

    public void addJobAttribute(Attribute attribute) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        this.jobAttributes.add(attribute);
    }

    public void addPrinterAttributes(Attribute attribute) {
        if (this.printerAttributes == null) {
            this.printerAttributes = new HashAttributeSet();
        }
        this.printerAttributes.add(attribute);
    }

    public void addOperationAttribute(Attribute attribute) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(attribute);
    }

    public void addAndFilterJobOperationAttributes(AttributeSet attributeSet) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].getCategory().equals(JobName.class) && !attributeArray[i].getCategory().equals(Fidelity.class) && !attributeArray[i].getCategory().equals(JobImpressions.class) && !attributeArray[i].getCategory().equals(JobKOctets.class) && !attributeArray[i].getCategory().equals(JobMediaSheets.class) && !attributeArray[i].getCategory().equals(Compression.class) && !attributeArray[i].getCategory().equals(DocumentName.class) && !attributeArray[i].getCategory().equals(RequestingUserName.class)) continue;
            this.operationAttributes.add(attributeArray[i]);
        }
    }

    public void addAndFilterJobTemplateAttributes(AttributeSet attributeSet) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        Attribute[] attributeArray = attributeSet.toArray();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (!attributeArray[i].getCategory().equals(JobPriority.class) && !attributeArray[i].getCategory().equals(JobHoldUntil.class) && !attributeArray[i].getCategory().equals(JobSheets.class) && !attributeArray[i].getCategory().equals(MultipleDocumentHandling.class) && !attributeArray[i].getCategory().equals(Copies.class) && !attributeArray[i].getCategory().equals(Finishings.class) && !attributeArray[i].getCategory().equals(PageRanges.class) && !attributeArray[i].getCategory().equals(NumberUp.class) && !attributeArray[i].getCategory().equals(OrientationRequested.class) && !attributeArray[i].getCategory().equals(Media.class) && !attributeArray[i].getCategory().equals(PrinterResolution.class) && !attributeArray[i].getCategory().equals(PrintQuality.class) && !attributeArray[i].getCategory().equals(SheetCollate.class) && !attributeArray[i].getCategory().equals(Sides.class)) continue;
            this.jobAttributes.add(attributeArray[i]);
        }
    }

    public IppResponse send() throws IppException, IOException {
        if (this.alreadySent) {
            throw new IllegalStateException("Request is already sent");
        }
        this.alreadySent = true;
        OutputStream outputStream = this.connection.getOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeShort(257);
        dataOutputStream.writeShort(this.operation_id);
        dataOutputStream.writeInt(this.request_id);
        logger.log(Component.IPP, "OperationID: " + Integer.toHexString(this.operation_id) + " RequestID: " + this.request_id);
        logger.log(Component.IPP, "Operation Attributes");
        RequestWriter requestWriter = new RequestWriter(dataOutputStream);
        requestWriter.writeOperationAttributes(this.operationAttributes);
        if (this.jobAttributes != null) {
            logger.log(Component.IPP, "Job Attributes");
            dataOutputStream.write(2);
            requestWriter.writeAttributes(this.jobAttributes);
        }
        if (this.printerAttributes != null) {
            logger.log(Component.IPP, "Printer Attributes");
            dataOutputStream.write(4);
            requestWriter.writeAttributes(this.printerAttributes);
        }
        dataOutputStream.write(3);
        if (this.data instanceof InputStream) {
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = ((InputStream)this.data).read(byArray)) > 0) {
                dataOutputStream.write(byArray, 0, n);
            }
        } else if (this.data != null) {
            dataOutputStream.write((byte[])this.data);
        }
        dataOutputStream.flush();
        outputStream.flush();
        this.connection.setConnectTimeout(1000);
        int n = this.connection.getResponseCode();
        if (n == 200) {
            IppResponse ippResponse = new IppResponse(this.requestUri, this.operation_id);
            ippResponse.setResponseData(this.connection.getInputStream());
            return ippResponse;
        }
        logger.log(Component.IPP, "HTTP-Statuscode: " + n);
        throw new IppException("Request failed got HTTP status code " + n);
    }

    class RequestWriter {
        private DataOutputStream out;

        RequestWriter(DataOutputStream dataOutputStream) {
            this.out = dataOutputStream;
        }

        private void write(IntegerSyntax integerSyntax) throws IOException {
            String string = ((Attribute)((Object)integerSyntax)).getName();
            this.out.writeByte(33);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(4);
            this.out.writeInt(integerSyntax.getValue());
        }

        private void write(EnumSyntax enumSyntax) throws IOException {
            String string = ((Attribute)((Object)enumSyntax)).getName();
            if (enumSyntax instanceof Finishings || enumSyntax instanceof OrientationRequested || enumSyntax instanceof PrintQuality) {
                this.out.writeByte(35);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(4);
                this.out.writeInt(enumSyntax.getValue());
            } else if (enumSyntax instanceof Fidelity) {
                this.out.writeByte(34);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(1);
                this.out.writeByte(enumSyntax.getValue() == 0 ? 0 : 1);
            } else {
                String string2 = enumSyntax.toString();
                this.out.writeByte(68);
                this.out.writeShort(string.length());
                this.out.write(string.getBytes());
                this.out.writeShort(string2.length());
                this.out.write(string2.getBytes());
            }
        }

        private void write(SetOfIntegerSyntax setOfIntegerSyntax) throws IOException {
            String string = ((Attribute)((Object)setOfIntegerSyntax)).getName();
            int[][] nArray = setOfIntegerSyntax.getMembers();
            for (int i = 0; i < nArray.length; ++i) {
                this.out.writeByte(51);
                if (i == 0) {
                    this.out.writeShort(string.length());
                    this.out.write(string.getBytes());
                } else {
                    this.out.writeShort(0);
                }
                this.out.writeShort(8);
                this.out.writeInt(nArray[i][0]);
                this.out.writeInt(nArray[i][1]);
            }
        }

        private void write(ResolutionSyntax resolutionSyntax) throws IOException {
            String string = ((Attribute)((Object)resolutionSyntax)).getName();
            this.out.writeByte(50);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(9);
            this.out.writeInt(resolutionSyntax.getCrossFeedResolution(100));
            this.out.writeInt(resolutionSyntax.getFeedResolution(100));
            this.out.writeByte(100);
        }

        private void write(DateTimeSyntax dateTimeSyntax) throws IOException {
            String string = ((Attribute)((Object)dateTimeSyntax)).getName();
            this.out.writeByte(49);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(11);
            Date date = dateTimeSyntax.getValue();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            this.out.writeShort(gregorianCalendar.get(1));
            this.out.writeByte(gregorianCalendar.get(2));
            this.out.writeByte(gregorianCalendar.get(5));
            this.out.writeByte(gregorianCalendar.get(11));
            this.out.writeByte(gregorianCalendar.get(12));
            int n = gregorianCalendar.get(13);
            this.out.writeByte(n == 0 ? 60 : n);
            this.out.writeByte(gregorianCalendar.get(14) / 100);
            int n2 = gregorianCalendar.get(15);
            int n3 = 43;
            if (n2 < 0) {
                n3 = 45;
                n2 *= -1;
            }
            this.out.writeByte(n3);
            this.out.writeByte(n2 / 3600000);
            this.out.writeByte(n2 % 3600000 / 60000);
        }

        private void write(TextSyntax textSyntax) throws IOException {
            String string = ((Attribute)((Object)textSyntax)).getName();
            if (textSyntax instanceof RequestingUserName || textSyntax instanceof JobName || textSyntax instanceof DocumentName || textSyntax instanceof JobOriginatingUserName) {
                this.out.writeByte(66);
            } else if (textSyntax instanceof DocumentFormat) {
                this.out.writeByte(73);
            } else {
                this.out.writeByte(65);
            }
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(textSyntax.getValue().length());
            this.out.write(textSyntax.getValue().getBytes());
        }

        private void write(URISyntax uRISyntax) throws IOException {
            String string = ((Attribute)((Object)uRISyntax)).getName();
            String string2 = uRISyntax.getURI().toASCIIString();
            this.out.writeByte(69);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(string2.length());
            this.out.write(string2.getBytes());
        }

        private void write(CharsetSyntax charsetSyntax) throws IOException {
            String string = ((Attribute)((Object)charsetSyntax)).getName();
            this.out.writeByte(71);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(charsetSyntax.getValue().length());
            this.out.write(charsetSyntax.getValue().getBytes());
        }

        private void write(NaturalLanguageSyntax naturalLanguageSyntax) throws IOException {
            String string = ((Attribute)((Object)naturalLanguageSyntax)).getName();
            this.out.writeByte(72);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(naturalLanguageSyntax.getValue().length());
            this.out.write(naturalLanguageSyntax.getValue().getBytes());
        }

        private void write(RequestedAttributes requestedAttributes) throws IOException {
            String[] stringArray = requestedAttributes.getValues();
            String string = requestedAttributes.getName();
            this.out.writeByte(68);
            this.out.writeShort(string.length());
            this.out.write(string.getBytes());
            this.out.writeShort(stringArray[0].length());
            this.out.write(stringArray[0].getBytes());
            for (int i = 1; i < stringArray.length; ++i) {
                this.out.writeByte(68);
                this.out.writeShort(0);
                this.out.writeShort(stringArray[i].length());
                this.out.write(stringArray[i].getBytes());
            }
        }

        public void writeOperationAttributes(AttributeSet attributeSet) throws IOException, IppException {
            this.out.write(1);
            Attribute attribute = attributeSet.get(AttributesCharset.class);
            this.write((CharsetSyntax)((Object)attribute));
            logger.log(Component.IPP, "Attribute: Name: <" + attribute.getCategory().getName() + "> Value: <" + attribute.toString() + ">");
            attributeSet.remove(AttributesCharset.class);
            attribute = attributeSet.get(AttributesNaturalLanguage.class);
            this.write((NaturalLanguageSyntax)((Object)attribute));
            attributeSet.remove(AttributesNaturalLanguage.class);
            logger.log(Component.IPP, "Attribute: Name: <" + attribute.getCategory().getName() + "> Value: <" + attribute.toString() + ">");
            PrinterURI printerURI = (PrinterURI)attributeSet.get(PrinterURI.class);
            JobUri jobUri = (JobUri)attributeSet.get(JobUri.class);
            JobId jobId = (JobId)attributeSet.get(JobId.class);
            RequestedAttributes requestedAttributes = (RequestedAttributes)attributeSet.get(RequestedAttributes.class);
            if (printerURI != null && jobId == null && jobUri == null) {
                this.write(printerURI);
                attributeSet.remove(PrinterURI.class);
                logger.log(Component.IPP, "Attribute: Name: <" + printerURI.getCategory().getName() + "> Value: <" + printerURI.toString() + ">");
            } else if (jobUri != null && jobId == null && printerURI == null) {
                this.write(jobUri);
                attributeSet.remove(JobUri.class);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + ">");
            } else if (printerURI != null && jobId != null && jobUri == null) {
                this.write(printerURI);
                this.write(jobId);
                attributeSet.remove(PrinterURI.class);
                attributeSet.remove(JobId.class);
                logger.log(Component.IPP, "Attribute: Name: <" + printerURI.getCategory().getName() + "> Value: <" + printerURI.toString() + ">");
                logger.log(Component.IPP, "Attribute: Name: <" + jobId.getCategory().getName() + "> Value: <" + jobId.toString() + ">");
            } else if (jobUri != null && jobId != null) {
                this.write(jobUri);
                attributeSet.remove(JobUri.class);
                attributeSet.remove(JobId.class);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + ">");
            } else if (requestedAttributes != null) {
                this.write(requestedAttributes);
                attributeSet.remove(RequestedAttributes.class);
                logger.log(Component.IPP, "RequestedAttributes: <" + requestedAttributes + ">");
            } else {
                throw new IppException("Unknown target operation attribute combination.");
            }
            this.writeAttributes(attributeSet);
        }

        public void writeAttributes(AttributeSet attributeSet) throws IOException, IppException {
            Attribute[] attributeArray = attributeSet.toArray();
            for (int i = 0; i < attributeArray.length; ++i) {
                logger.log(Component.IPP, "Attribute: Name: <" + attributeArray[i].getCategory().getName() + "> Value: <" + attributeArray[i].toString() + ">");
                if (attributeArray[i] instanceof IntegerSyntax) {
                    this.write((IntegerSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof TextSyntax) {
                    this.write((TextSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof DateTimeSyntax) {
                    this.write((DateTimeSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof ResolutionSyntax) {
                    this.write((ResolutionSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof SetOfIntegerSyntax) {
                    this.write((SetOfIntegerSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof EnumSyntax) {
                    this.write((EnumSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof URISyntax) {
                    this.write((URISyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof CharsetSyntax) {
                    this.write((CharsetSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof NaturalLanguageSyntax) {
                    this.write((NaturalLanguageSyntax)((Object)attributeArray[i]));
                    continue;
                }
                if (attributeArray[i] instanceof RequestedAttributes) {
                    this.write((RequestedAttributes)attributeArray[i]);
                    continue;
                }
                throw new IppException("Unknown syntax type");
            }
        }
    }
}

