/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.CupsPrintService;
import gnu.javax.print.ipp.DocPrintJobImpl;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.IppUtilities;
import gnu.javax.print.ipp.attribute.DefaultValueAttribute;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.defaults.CopiesDefault;
import gnu.javax.print.ipp.attribute.defaults.FinishingsDefault;
import gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault;
import gnu.javax.print.ipp.attribute.defaults.JobPriorityDefault;
import gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault;
import gnu.javax.print.ipp.attribute.defaults.MediaDefault;
import gnu.javax.print.ipp.attribute.defaults.MultipleDocumentHandlingDefault;
import gnu.javax.print.ipp.attribute.defaults.NumberUpDefault;
import gnu.javax.print.ipp.attribute.defaults.OrientationRequestedDefault;
import gnu.javax.print.ipp.attribute.defaults.PrintQualityDefault;
import gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault;
import gnu.javax.print.ipp.attribute.defaults.SidesDefault;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.supported.CompressionSupported;
import gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported;
import gnu.javax.print.ipp.attribute.supported.FinishingsSupported;
import gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported;
import gnu.javax.print.ipp.attribute.supported.PageRangesSupported;
import gnu.javax.print.ipp.attribute.supported.PrintQualitySupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import gnu.javax.print.ipp.attribute.supported.SidesSupported;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobImpressionsSupported;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobKOctetsSupported;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobMediaSheetsSupported;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobPrioritySupported;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IppPrintService
implements PrintService {
    private Map<Class<? extends Attribute>, Set<Attribute>> printerAttr;
    private HashSet<PrintServiceAttributeListener> printServiceAttributeListener;
    private transient String user;
    private transient String passwd;
    private String name;
    private List<DocFlavor> flavors;
    private PrinterURI printerUri;
    private ArrayList<PrinterURI> printerUris;
    static final Logger logger = SystemLogger.SYSTEM;
    public static final RequestingUserName REQUESTING_USER_NAME;
    public static final JobName JOB_NAME;

    public IppPrintService(URI uRI, String string, String string2) throws IppException {
        this.printerUri = new PrinterURI(uRI);
        this.user = string;
        this.passwd = string2;
        this.printServiceAttributeListener = new HashSet();
        this.printerAttr = this.getPrinterAttributes();
        this.processResponse();
    }

    private Map<Class<? extends Attribute>, Set<Attribute>> getPrinterAttributes() throws IppException {
        IppResponse ippResponse = null;
        try {
            IppRequest ippRequest = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            int n = OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue();
            ippRequest.setOperationID((short)n);
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(this.printerUri);
            ippResponse = ippRequest.send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException in IPP request/response.", iOException);
        }
        return ippResponse.getPrinterAttributes().get(0);
    }

    private <T extends Attribute> Set<T> getPrinterAttributeSet(Class<T> clazz) {
        Set<Attribute> set = this.printerAttr.get(clazz);
        HashSet hashSet = new HashSet();
        for (Attribute attribute : set) {
            hashSet.add(clazz.cast(attribute));
        }
        return hashSet;
    }

    private Attribute getPrinterDefaultAttribute(Class<? extends Attribute> clazz) {
        Set<Attribute> set = this.printerAttr.get(clazz);
        return ((DefaultValueAttribute)set.toArray()[0]).getAssociatedAttribute();
    }

    private void processResponse() {
        Object object;
        PrinterName[] printerNameArray = this.getPrinterAttributeSet(PrinterName.class).toArray(new PrinterName[1]);
        this.name = printerNameArray[0].getValue();
        this.flavors = new ArrayList<DocFlavor>();
        Set<DocumentFormatSupported> set = this.getPrinterAttributeSet(DocumentFormatSupported.class);
        if (set != null) {
            for (DocumentFormatSupported object22 : set) {
                object = object22.getValue();
                if (((String)object).equals("text/plain")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.READER.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.STRING.TEXT_PLAIN);
                    object = (String)object + "; charset=utf-8";
                } else if (((String)object).equals("text/html")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_HTML);
                    this.flavors.add(DocFlavor.READER.TEXT_HTML);
                    this.flavors.add(DocFlavor.STRING.TEXT_HTML);
                    object = (String)object + "; charset=utf-8";
                }
                boolean bl = false;
                try {
                    Class[] securityException = new Class[]{DocFlavor.BYTE_ARRAY.class, DocFlavor.INPUT_STREAM.class, DocFlavor.URL.class};
                    for (int i = 0; i < securityException.length; ++i) {
                        Field[] fieldArray = securityException[i].getDeclaredFields();
                        for (int j = 0; j < fieldArray.length; ++j) {
                            DocFlavor docFlavor;
                            if (!fieldArray[j].getType().equals(securityException[i]) || !(docFlavor = (DocFlavor)fieldArray[j].get(null)).getMimeType().equals(object)) continue;
                            bl = this.flavors.add(docFlavor);
                        }
                    }
                    if (bl) continue;
                    this.flavors.add(new DocFlavor((String)object, "[B"));
                    this.flavors.add(new DocFlavor((String)object, "java.io.InputStream"));
                    this.flavors.add(new DocFlavor((String)object, "java.net.URL"));
                }
                catch (SecurityException illegalArgumentException) {
                }
                catch (IllegalArgumentException illegalAccessException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            if (this.getClass().isAssignableFrom(CupsPrintService.class)) {
                this.flavors.add(DocFlavor.SERVICE_FORMATTED.PAGEABLE);
                this.flavors.add(DocFlavor.SERVICE_FORMATTED.PRINTABLE);
            }
        }
        Set<PrinterUriSupported> set2 = this.getPrinterAttributeSet(PrinterUriSupported.class);
        this.printerUris = new ArrayList(set2.size());
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = (PrinterUriSupported)iterator.next();
            this.printerUris.add(new PrinterURI(((URISyntax)object).getURI()));
        }
    }

    @Override
    public DocPrintJob createPrintJob() {
        return new DocPrintJobImpl(this, this.user, this.passwd);
    }

    @Override
    public <T extends PrintServiceAttribute> T getAttribute(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!PrintServiceAttribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type PrintServiceAttribute");
        }
        Set<T> set = this.getPrinterAttributeSet(clazz);
        if (set != null && set.size() > 0) {
            return (T)((PrintServiceAttribute)set.iterator().next());
        }
        return null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        for (Set<Attribute> set : this.printerAttr.values()) {
            for (Attribute attribute : set) {
                if (!(attribute instanceof PrintServiceAttribute)) continue;
                hashPrintServiceAttributeSet.add(attribute);
            }
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    @Override
    public Object getDefaultAttributeValue(Class<? extends Attribute> clazz) {
        if (clazz.equals(Fidelity.class)) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz.equals(JobName.class)) {
            return JOB_NAME;
        }
        if (clazz.equals(RequestingUserName.class)) {
            return REQUESTING_USER_NAME;
        }
        if (clazz.equals(JobPriority.class) && this.printerAttr.containsKey(JobPriorityDefault.class)) {
            return this.getPrinterDefaultAttribute(JobPriorityDefault.class);
        }
        if (clazz.equals(JobHoldUntil.class) && this.printerAttr.containsKey(JobHoldUntilDefault.class)) {
            return this.getPrinterDefaultAttribute(JobHoldUntilDefault.class);
        }
        if (clazz.equals(JobSheets.class) && this.printerAttr.containsKey(JobSheetsDefault.class)) {
            return this.getPrinterDefaultAttribute(JobSheetsDefault.class);
        }
        if (clazz.equals(MultipleDocumentHandling.class) && this.printerAttr.containsKey(MultipleDocumentHandlingDefault.class)) {
            return this.getPrinterDefaultAttribute(MultipleDocumentHandlingDefault.class);
        }
        if (clazz.equals(Copies.class) && this.printerAttr.containsKey(CopiesDefault.class)) {
            return this.getPrinterDefaultAttribute(CopiesDefault.class);
        }
        if (clazz.equals(Finishings.class) && this.printerAttr.containsKey(FinishingsDefault.class)) {
            return this.getPrinterDefaultAttribute(FinishingsDefault.class);
        }
        if (clazz.equals(Sides.class) && this.printerAttr.containsKey(SidesDefault.class)) {
            return this.getPrinterDefaultAttribute(SidesDefault.class);
        }
        if (clazz.equals(NumberUp.class) && this.printerAttr.containsKey(NumberUpDefault.class)) {
            return this.getPrinterDefaultAttribute(NumberUpDefault.class);
        }
        if (clazz.equals(OrientationRequested.class) && this.printerAttr.containsKey(OrientationRequestedDefault.class)) {
            return this.getPrinterDefaultAttribute(OrientationRequestedDefault.class);
        }
        if (clazz.equals(Media.class) && this.printerAttr.containsKey(MediaDefault.class)) {
            return this.getPrinterDefaultAttribute(MediaDefault.class);
        }
        if (clazz.equals(PrinterResolution.class) && this.printerAttr.containsKey(PrinterResolutionDefault.class)) {
            return this.getPrinterDefaultAttribute(PrinterResolutionDefault.class);
        }
        if (clazz.equals(PrintQuality.class) && this.printerAttr.containsKey(PrintQualityDefault.class)) {
            return this.getPrinterDefaultAttribute(PrintQualityDefault.class);
        }
        if (clazz.equals(Compression.class) && this.printerAttr.containsKey(CompressionSupported.class)) {
            return Compression.NONE;
        }
        if (clazz.equals(PageRanges.class)) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    @Override
    public Class<?>[] getSupportedAttributeCategories() {
        Set<FinishingsSupported> set;
        HashSet<Class> hashSet = new HashSet<Class>();
        if (this.printerAttr.containsKey(JobPrioritySupported.class)) {
            hashSet.add(JobPriority.class);
        }
        if (this.printerAttr.containsKey(JobHoldUntilSupported.class)) {
            hashSet.add(JobHoldUntil.class);
        }
        if (this.printerAttr.containsKey(JobSheetsSupported.class)) {
            hashSet.add(JobSheets.class);
        }
        if (this.printerAttr.containsKey(MultipleDocumentHandlingSupported.class)) {
            hashSet.add(MultipleDocumentHandling.class);
        }
        if (this.printerAttr.containsKey(CopiesSupported.class)) {
            hashSet.add(Copies.class);
        }
        if (this.printerAttr.containsKey(FinishingsSupported.class) && ((set = this.getPrinterAttributeSet(FinishingsSupported.class)).size() != 1 || !set.contains(FinishingsSupported.NONE))) {
            hashSet.add(Finishings.class);
        }
        if (this.printerAttr.containsKey(PageRangesSupported.class)) {
            hashSet.add(PageRanges.class);
        }
        if (this.printerAttr.containsKey(SidesSupported.class)) {
            hashSet.add(Sides.class);
        }
        if (this.printerAttr.containsKey(NumberUpSupported.class)) {
            hashSet.add(NumberUp.class);
        }
        if (this.printerAttr.containsKey(OrientationRequestedSupported.class)) {
            hashSet.add(OrientationRequested.class);
        }
        if (this.printerAttr.containsKey(MediaSupported.class)) {
            hashSet.add(Media.class);
        }
        if (this.printerAttr.containsKey(PrinterResolutionSupported.class)) {
            hashSet.add(PrinterResolution.class);
        }
        if (this.printerAttr.containsKey(PrintQualitySupported.class)) {
            hashSet.add(PrintQuality.class);
        }
        if (this.printerAttr.containsKey(CompressionSupported.class)) {
            hashSet.add(Compression.class);
        }
        if (this.printerAttr.containsKey(JobImpressionsSupported.class)) {
            hashSet.add(JobImpressions.class);
        }
        if (this.printerAttr.containsKey(JobKOctetsSupported.class)) {
            hashSet.add(JobKOctets.class);
        }
        if (this.printerAttr.containsKey(JobMediaSheetsSupported.class)) {
            hashSet.add(JobMediaSheets.class);
        }
        hashSet.add(Fidelity.class);
        hashSet.add(JobName.class);
        hashSet.add(RequestingUserName.class);
        return hashSet.toArray(new Class[hashSet.size()]);
    }

    @Override
    public Object getSupportedAttributeValues(Class<? extends Attribute> clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz.equals(Fidelity.class)) {
            return new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
        }
        if (clazz.equals(JobName.class)) {
            return JOB_NAME;
        }
        if (clazz.equals(RequestingUserName.class)) {
            return REQUESTING_USER_NAME;
        }
        String string = IppUtilities.getSupportedAttrName(clazz);
        IppResponse ippResponse = null;
        try {
            short s;
            IppRequest ippRequest = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            ippRequest.setOperationID((short)OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue());
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(new RequestedAttributes(string));
            ippRequest.addOperationAttribute(this.printerUri);
            if (docFlavor != null) {
                DocumentFormat documentFormat = DocumentFormat.createDocumentFormat(docFlavor);
                ippRequest.addOperationAttribute(documentFormat);
            }
            if ((s = (ippResponse = ippRequest.send()).getStatusCode()) != 0 && s != 1 && s != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + s);
            }
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "IOException", iOException);
        }
        catch (IppException ippException) {
            logger.log((Level)Component.IPP, "IPPException", ippException);
        }
        return this.handleSupportedAttributeValuesResponse(ippResponse, clazz);
    }

    protected Object handleSupportedAttributeValuesResponse(IppResponse ippResponse, Class<? extends Attribute> clazz) {
        List<Map<Class<? extends Attribute>, Set<Attribute>>> list2 = ippResponse.getPrinterAttributes();
        Map<Class<? extends Attribute>, Set<Attribute>> map = list2.get(0);
        Class<? extends Attribute> clazz2 = IppUtilities.getSupportedCategory(clazz);
        Set<Attribute> set = map.get(clazz2);
        if (clazz2.equals(JobPrioritySupported.class)) {
            return (JobPrioritySupported)set.iterator().next();
        }
        if (clazz2.equals(JobHoldUntilSupported.class)) {
            return new JobHoldUntil(new Date());
        }
        if (clazz2.equals(JobSheetsSupported.class)) {
            return JobSheetsSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(MultipleDocumentHandlingSupported.class)) {
            return MultipleDocumentHandlingSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(CopiesSupported.class)) {
            return (CopiesSupported)set.iterator().next();
        }
        if (clazz2.equals(FinishingsSupported.class)) {
            return FinishingsSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(PageRangesSupported.class)) {
            return new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
        }
        if (clazz2.equals(OrientationRequestedSupported.class)) {
            return OrientationRequestedSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(MediaSupported.class)) {
            return MediaSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(PrinterResolutionSupported.class)) {
            return PrinterResolutionSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(PrintQualitySupported.class)) {
            return PrintQualitySupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(CompressionSupported.class)) {
            return CompressionSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(NumberUpSupported.class)) {
            if (set.size() == 1) {
                return set.iterator().next();
            }
            int[][] nArray = new int[set.size()][2];
            Iterator<Attribute> iterator = set.iterator();
            for (int i = 0; i < set.size(); ++i) {
                int n = ((NumberUpSupported)iterator.next()).getMembers()[0][0];
                nArray[i] = new int[]{n, n};
            }
            NumberUpSupported numberUpSupported = new NumberUpSupported(nArray);
            return numberUpSupported;
        }
        return null;
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return this.flavors.toArray(new DocFlavor[this.flavors.size()]);
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        Object object;
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        IppResponse ippResponse = null;
        try {
            short s;
            object = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            short s2 = (short)OperationsSupported.VALIDATE_JOB.getValue();
            ((IppRequest)object).setOperationID(s2);
            ((IppRequest)object).setOperationAttributeDefaults();
            ((IppRequest)object).addOperationAttribute(this.printerUri);
            ((IppRequest)object).addOperationAttribute(Fidelity.FIDELITY_TRUE);
            if (attributeSet != null && attributeSet.size() > 0) {
                ((IppRequest)object).addAndFilterJobOperationAttributes(attributeSet);
                ((IppRequest)object).addAndFilterJobTemplateAttributes(attributeSet);
            }
            if (docFlavor != null) {
                DocumentFormat documentFormat = DocumentFormat.createDocumentFormat(docFlavor);
                ((IppRequest)object).addOperationAttribute(documentFormat);
            }
            if ((s = (ippResponse = ((IppRequest)object).send()).getStatusCode()) != 0 && s != 1 && s != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + s);
            }
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "IOException", iOException);
        }
        catch (IppException ippException) {
            logger.log((Level)Component.IPP, "IPPException", ippException);
        }
        object = ippResponse.getUnsupportedAttributes();
        if (object.size() == 0) {
            return null;
        }
        Map map = (Map)object.get(0);
        if (map.size() == 0) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        for (Set set : map.values()) {
            for (Attribute attribute : set) {
                hashAttributeSet.add(attribute);
            }
        }
        return hashAttributeSet;
    }

    @Override
    public boolean isAttributeCategorySupported(Class<? extends Attribute> clazz) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!Attribute.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        return Arrays.asList(this.getSupportedAttributeCategories()).contains(clazz);
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Object object = this.getSupportedAttributeValues(attribute.getCategory(), docFlavor, attributeSet);
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return Arrays.asList((Object[])object).contains(attribute);
        }
        if (object.getClass().equals(attribute.getCategory())) {
            return true;
        }
        if (object.getClass().equals(CopiesSupported.class)) {
            return ((CopiesSupported)object).contains((IntegerSyntax)((Object)attribute));
        }
        if (object.getClass().equals(NumberUpSupported.class)) {
            return ((NumberUpSupported)object).contains((IntegerSyntax)((Object)attribute));
        }
        if (object.getClass().equals(JobPrioritySupported.class)) {
            JobPriority jobPriority = (JobPriority)attribute;
            JobPrioritySupported jobPrioritySupported = (JobPrioritySupported)object;
            if (jobPriority.getValue() < jobPrioritySupported.getValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        if (docFlavor == null) {
            throw new NullPointerException("DocFlavor may not be null.");
        }
        return this.flavors.contains(docFlavor);
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.printServiceAttributeListener.add(printServiceAttributeListener);
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.printServiceAttributeListener.remove(printServiceAttributeListener);
    }

    public String toString() {
        return "IppPrinter: " + this.getName();
    }

    public PrinterURI getPrinterURI() {
        return this.printerUri;
    }

    static {
        JOB_NAME = new JobName("Java Printing", null);
        REQUESTING_USER_NAME = new RequestingUserName(SystemProperties.getProperty("user.name", ""), null);
    }
}

