/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.javax.print.PrintFlavorException;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppPrintService;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;

public class DocPrintJobImpl
implements CancelablePrintJob {
    private IppPrintService service;
    private HashSet printJobListener = new HashSet();
    private ArrayList attributesListener = new ArrayList();
    private ArrayList attributesListenerAttributes = new ArrayList();
    private String username;
    private String password;
    private JobUri jobUri = null;
    private JobId jobId = null;
    private RequestingUserName requestingUser;
    private PrintJobAttributeSet oldSet = new HashPrintJobAttributeSet();
    private PrintJobAttributeSet currentSet = new HashPrintJobAttributeSet();
    private boolean printing = false;

    public DocPrintJobImpl(IppPrintService ippPrintService, String string, String string2) {
        this.service = ippPrintService;
        this.username = string;
        this.password = string2;
    }

    public void addPrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener, PrintJobAttributeSet printJobAttributeSet) {
        if (printJobAttributeListener == null) {
            return;
        }
        this.attributesListener.add(printJobAttributeListener);
        this.attributesListenerAttributes.add(printJobAttributeSet);
    }

    public void addPrintJobListener(PrintJobListener printJobListener) {
        if (printJobListener == null) {
            return;
        }
        this.printJobListener.add(printJobListener);
    }

    public PrintJobAttributeSet getAttributes() {
        return AttributeSetUtilities.unmodifiableView(this.currentSet);
    }

    public PrintService getPrintService() {
        return this.service;
    }

    public void print(Doc doc, PrintRequestAttributeSet printRequestAttributeSet) throws PrintException {
        Object object;
        Object object2;
        if (this.printing) {
            throw new PrintException("already printing");
        }
        this.printing = true;
        DocAttributeSet docAttributeSet = doc.getAttributes();
        DocFlavor docFlavor = doc.getDocFlavor();
        if (docFlavor == null || !this.service.isDocFlavorSupported(docFlavor)) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintFlavorException("Invalid flavor", new DocFlavor[]{docFlavor});
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        if (printRequestAttributeSet != null) {
            hashAttributeSet.addAll(printRequestAttributeSet);
        }
        if (docAttributeSet != null) {
            hashAttributeSet.addAll(docAttributeSet);
        }
        if (!hashAttributeSet.containsKey(RequestingUserName.class)) {
            hashAttributeSet.add(IppPrintService.REQUESTING_USER_NAME);
            this.requestingUser = IppPrintService.REQUESTING_USER_NAME;
        } else {
            this.requestingUser = (RequestingUserName)hashAttributeSet.get(RequestingUserName.class);
        }
        if (!hashAttributeSet.containsKey(JobName.class)) {
            hashAttributeSet.add(IppPrintService.JOB_NAME);
        }
        IppResponse ippResponse = null;
        try {
            PrinterURI printerURI = this.service.getPrinterURI();
            object2 = "http" + printerURI.toString().substring(3);
            object = null;
            try {
                object = new URI((String)object2);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            IppRequest ippRequest = new IppRequest((URI)object, this.username, this.password);
            ippRequest.setOperationID((short)OperationsSupported.PRINT_JOB.getValue());
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(printerURI);
            if (hashAttributeSet != null) {
                ippRequest.addAndFilterJobOperationAttributes(hashAttributeSet);
                ippRequest.addAndFilterJobTemplateAttributes(hashAttributeSet);
            }
            DocumentFormat documentFormat = DocumentFormat.createDocumentFormat(docFlavor);
            ippRequest.addOperationAttribute(documentFormat);
            String string = docFlavor.getRepresentationClassName();
            if (string.equals("[B")) {
                ippRequest.setData((byte[])doc.getPrintData());
                ippResponse = ippRequest.send();
            } else if (string.equals("java.io.InputStream")) {
                InputStream inputStream = (InputStream)doc.getPrintData();
                ippRequest.setData(inputStream);
                ippResponse = ippRequest.send();
                inputStream.close();
            } else if (string.equals("[C")) {
                try {
                    String string2 = new String((char[])doc.getPrintData());
                    ippRequest.setData(string2.getBytes("utf-16"));
                    ippResponse = ippRequest.send();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                    throw new PrintFlavorException("Invalid charset of flavor", unsupportedEncodingException, new DocFlavor[]{docFlavor});
                }
            } else {
                if (string.equals("java.io.Reader")) {
                    try {
                        ippResponse = ippRequest.send();
                        throw new UnsupportedEncodingException("not supported yet");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                        throw new PrintFlavorException("Invalid charset of flavor", unsupportedEncodingException, new DocFlavor[]{docFlavor});
                    }
                }
                if (string.equals("java.lang.String")) {
                    try {
                        String string3 = (String)doc.getPrintData();
                        ippRequest.setData(string3.getBytes("utf-16"));
                        ippResponse = ippRequest.send();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                        throw new PrintFlavorException("Invalid charset of flavor", unsupportedEncodingException, new DocFlavor[]{docFlavor});
                    }
                } else if (string.equals("java.net.URL")) {
                    URL uRL = (URL)doc.getPrintData();
                    InputStream inputStream = uRL.openStream();
                    ippRequest.setData(inputStream);
                    ippResponse = ippRequest.send();
                    inputStream.close();
                } else {
                    if (string.equals("java.awt.image.renderable.RenderableImage") || string.equals("java.awt.print.Printable") || string.equals("java.awt.print.Pageable")) {
                        throw new PrintException("Not yet supported.");
                    }
                    this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
                    throw new PrintFlavorException("Invalid flavor", new DocFlavor[]{docFlavor});
                }
            }
            this.notifyPrintJobListeners(new PrintJobEvent(this, 106));
        }
        catch (IOException iOException) {
            throw new PrintException("IOException occured.", iOException);
        }
        short s = ippResponse.getStatusCode();
        if (s != 0 && s != 1 && s != 2) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintException("Printing failed - received statuscode " + Integer.toHexString(s));
        }
        this.notifyPrintJobListeners(new PrintJobEvent(this, 102));
        object2 = ippResponse.getJobAttributes();
        object = (Map)object2.get(0);
        this.jobUri = (JobUri)((HashSet)object.get(JobUri.class)).toArray()[0];
        this.jobId = (JobId)((HashSet)object.get(JobId.class)).toArray()[0];
    }

    public void removePrintJobAttributeListener(PrintJobAttributeListener printJobAttributeListener) {
        if (printJobAttributeListener == null) {
            return;
        }
        int n = this.attributesListener.indexOf(printJobAttributeListener);
        if (n != -1) {
            this.attributesListener.remove(n);
            this.attributesListenerAttributes.remove(n);
        }
    }

    public void removePrintJobListener(PrintJobListener printJobListener) {
        if (printJobListener == null) {
            return;
        }
        this.printJobListener.remove(printJobListener);
    }

    public void cancel() throws PrintException {
        if (this.jobUri == null) {
            throw new PrintException("print job is not yet send");
        }
        IppResponse ippResponse = null;
        try {
            IppRequest ippRequest = new IppRequest(this.jobUri.getURI(), this.username, this.password);
            ippRequest.setOperationID((short)OperationsSupported.CANCEL_JOB.getValue());
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(this.jobUri);
            ippRequest.addOperationAttribute(this.requestingUser);
            ippResponse = ippRequest.send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException occured during cancel request.", iOException);
        }
        short s = ippResponse.getStatusCode();
        if (s != 0 && s != 1 && s != 2) {
            this.notifyPrintJobListeners(new PrintJobEvent(this, 103));
            throw new PrintException("Canceling failed - received statuscode " + Integer.toHexString(s));
        }
        this.notifyPrintJobListeners(new PrintJobEvent(this, 101));
    }

    private void notifyPrintJobListeners(PrintJobEvent printJobEvent) {
        for (PrintJobListener printJobListener : this.printJobListener) {
            if (printJobEvent.getPrintEventType() == 106) {
                printJobListener.printDataTransferCompleted(printJobEvent);
                continue;
            }
            if (printJobEvent.getPrintEventType() == 101) {
                printJobListener.printJobCanceled(printJobEvent);
                continue;
            }
            if (printJobEvent.getPrintEventType() == 102) {
                printJobListener.printJobCompleted(printJobEvent);
                continue;
            }
            if (printJobEvent.getPrintEventType() == 103) {
                printJobListener.printJobFailed(printJobEvent);
                continue;
            }
            if (printJobEvent.getPrintEventType() == 105) {
                printJobListener.printJobNoMoreEvents(printJobEvent);
                continue;
            }
            printJobListener.printJobRequiresAttention(printJobEvent);
        }
    }
}

