/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.NullManagerParameters;
import gnu.javax.net.ssl.PrivateCredentials;
import gnu.javax.net.ssl.provider.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class X509KeyManagerFactory
extends KeyManagerFactorySpi {
    private Manager current;

    protected KeyManager[] engineGetKeyManagers() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return new KeyManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof NullManagerParameters) {
            this.current = new Manager(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        } else if (managerFactoryParameters instanceof PrivateCredentials) {
            List<X509Certificate[]> list2 = ((PrivateCredentials)managerFactoryParameters).getCertChains();
            List<PrivateKey> list3 = ((PrivateCredentials)managerFactoryParameters).getPrivateKeys();
            int n = 0;
            HashMap<String, X509Certificate[]> hashMap = new HashMap<String, X509Certificate[]>();
            HashMap<String, PrivateKey> hashMap2 = new HashMap<String, PrivateKey>();
            Iterator<X509Certificate[]> iterator = list2.iterator();
            Iterator<PrivateKey> iterator2 = list3.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                hashMap.put(String.valueOf(n), iterator.next());
                hashMap2.put(String.valueOf(n), iterator2.next());
                ++n;
            }
            this.current = new Manager(hashMap2, hashMap);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Object object;
        Object object2;
        if (keyStore == null) {
            object2 = Util.getProperty("javax.net.ssl.keyStoreType");
            if (object2 == null) {
                object2 = KeyStore.getDefaultType();
            }
            keyStore = KeyStore.getInstance((String)object2);
            object2 = Util.getProperty("javax.net.ssl.keyStore");
            if (object2 == null) {
                return;
            }
            object = Util.getProperty("javax.net.ssl.keyStorePassword");
            try {
                keyStore.load(new FileInputStream((String)object2), object != null ? ((String)object).toCharArray() : null);
            }
            catch (IOException iOException) {
                throw new KeyStoreException(iOException.toString());
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreException(certificateException.toString());
            }
        }
        object2 = new HashMap();
        object = new HashMap();
        Enumeration<String> enumeration = keyStore.aliases();
        UnrecoverableKeyException unrecoverableKeyException = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate[] x509CertificateArray = null;
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            if (certificateArray == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            x509CertificateArray = X509KeyManagerFactory.toX509Chain(certificateArray);
            PrivateKey privateKey = null;
            try {
                privateKey = (PrivateKey)keyStore.getKey(string, cArray);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException2) {
                unrecoverableKeyException = unrecoverableKeyException2;
                continue;
            }
            if (privateKey == null) continue;
            ((HashMap)object2).put(string, privateKey);
            ((HashMap)object).put(string, x509CertificateArray);
        }
        if (((HashMap)object2).isEmpty() && ((HashMap)object).isEmpty()) {
            if (unrecoverableKeyException != null) {
                throw unrecoverableKeyException;
            }
            throw new KeyStoreException("no private credentials found");
        }
        this.current = new Manager((Map<String, PrivateKey>)object2, (Map<String, X509Certificate[]>)object);
    }

    private static X509Certificate[] toX509Chain(Certificate[] certificateArray) {
        if (certificateArray instanceof X509Certificate[]) {
            return (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        return x509CertificateArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Manager
    extends X509ExtendedKeyManager {
        private final Map<String, PrivateKey> privateKeys;
        private final Map<String, X509Certificate[]> certChains;

        Manager(Map<String, PrivateKey> map, Map<String, X509Certificate[]> map2) {
            this.privateKeys = map;
            this.certChains = map2;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = this.getClientAliases(stringArray[i], principalArray);
                if (stringArray2.length <= 0) continue;
                return stringArray2[0];
            }
            return null;
        }

        @Override
        public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
            for (String string : stringArray) {
                String[] stringArray2 = this.getClientAliases(string, principalArray);
                if (stringArray2.length <= 0) continue;
                return stringArray2[0];
            }
            return null;
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this.getAliases(string, principalArray);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            String[] stringArray = this.getServerAliases(string, principalArray);
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
            String[] stringArray = this.getServerAliases(string, principalArray);
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this.getAliases(string, principalArray);
        }

        private String[] getAliases(String string, Principal[] principalArray) {
            LinkedList<String> linkedList = new LinkedList<String>();
            block0: for (String string2 : this.privateKeys.keySet()) {
                PrivateKey privateKey;
                X509Certificate[] x509CertificateArray = this.getCertificateChain(string2);
                if (x509CertificateArray.length == 0 || (privateKey = this.getPrivateKey(string2)) == null) continue;
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                if (string.equalsIgnoreCase("RSA") || string.equalsIgnoreCase("DHE_RSA") || string.equalsIgnoreCase("SRP_RSA") || string.equalsIgnoreCase("rsa_sign") || string.equalsIgnoreCase("RSA_PSK")) {
                    if (!(privateKey instanceof RSAPrivateKey) || !(publicKey instanceof RSAPublicKey)) {
                        continue;
                    }
                } else if (string.equalsIgnoreCase("DHE_DSS") || string.equalsIgnoreCase("dss_sign") || string.equalsIgnoreCase("SRP_DSS") || string.equalsIgnoreCase("DSA")) {
                    if (!(privateKey instanceof DSAPrivateKey) || !(publicKey instanceof DSAPublicKey)) {
                        continue;
                    }
                } else if (!string.equalsIgnoreCase("DH_RSA") && !string.equalsIgnoreCase("rsa_fixed_dh") ? !string.equalsIgnoreCase("DH_DSS") && !string.equalsIgnoreCase("dss_fixed_dh") || !(privateKey instanceof DHPrivateKey) || !(publicKey instanceof DHPublicKey) || !x509CertificateArray[0].getSigAlgName().equalsIgnoreCase("DSA") : !(privateKey instanceof DHPrivateKey) || !(publicKey instanceof DHPublicKey) || !x509CertificateArray[0].getSigAlgName().equalsIgnoreCase("RSA")) continue;
                if (principalArray == null || principalArray.length == 0) {
                    linkedList.add(string2);
                    continue;
                }
                for (Principal principal : principalArray) {
                    if (!x509CertificateArray[0].getIssuerDN().equals(principal)) continue;
                    linkedList.add(string2);
                    continue block0;
                }
            }
            return linkedList.toArray((S[])new String[linkedList.size()]);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            X509Certificate[] x509CertificateArray = this.certChains.get(string);
            return x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : null;
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.privateKeys.get(string);
        }
    }
}

