/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.prng.IRandom;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.net.ssl.provider.TLSHMac;
import gnu.javax.net.ssl.provider.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

class TLSRandom
implements IRandom {
    static final String SECRET = "jessie.tls.prng.secret";
    static final String SEED = "jessie.tls.prng.seed";
    private final IMac hmac_sha = new TLSHMac(HashFactory.getInstance("SHA1"));
    private final IMac hmac_md5 = new TLSHMac(HashFactory.getInstance("MD5"));
    private byte[] sha_a;
    private byte[] md5_a;
    private byte[] seed;
    private final byte[] buffer = new byte[80];
    private int idx = 0;
    private boolean init = false;

    TLSRandom() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public void init(Map map) {
        byte[] byArray;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        HashMap<String, byte[]> hashMap2 = new HashMap<String, byte[]>();
        byte[] byArray2 = (byte[])map.get(SECRET);
        if (byArray2 != null) {
            int n = (byArray2.length >>> 1) + (byArray2.length & 1);
            byte[] byArray3 = Util.trim(byArray2, 0, n);
            byte[] byArray4 = Util.trim(byArray2, byArray2.length - n, n);
            hashMap2.put("gnu.crypto.mac.key.material", byArray3);
            hashMap.put("gnu.crypto.mac.key.material", byArray4);
            try {
                this.hmac_md5.init(hashMap2);
                this.hmac_sha.init(hashMap);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new Error(invalidKeyException.toString());
            }
        } else if (!this.init) {
            throw new IllegalArgumentException("no secret supplied");
        }
        if ((byArray = (byte[])map.get(SEED)) != null) {
            this.seed = (byte[])byArray.clone();
        } else if (!this.init) {
            throw new IllegalArgumentException("no seed supplied");
        }
        this.hmac_md5.update(this.seed, 0, this.seed.length);
        this.md5_a = this.hmac_md5.digest();
        this.hmac_md5.reset();
        this.hmac_sha.update(this.seed, 0, this.seed.length);
        this.sha_a = this.hmac_sha.digest();
        this.hmac_sha.reset();
        this.fillBuffer();
        this.init = true;
    }

    public String name() {
        return "TLSRandom";
    }

    public byte nextByte() {
        if (!this.init) {
            throw new IllegalStateException();
        }
        if (this.idx >= this.buffer.length) {
            this.fillBuffer();
        }
        return this.buffer[this.idx++];
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        if (!this.init) {
            throw new IllegalStateException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        if (this.idx >= this.buffer.length) {
            this.fillBuffer();
        }
        while (n3 < n2) {
            int n4 = Math.min(this.buffer.length - this.idx, n2 - n3);
            System.arraycopy(this.buffer, this.idx, byArray, n + n3, n4);
            this.idx += n4;
            if ((n3 += n4) >= n2 || this.idx < this.buffer.length) continue;
            this.fillBuffer();
        }
    }

    public void addRandomByte(byte by) {
    }

    public void addRandomBytes(byte[] byArray) {
        this.addRandomBytes(byArray, 0, byArray.length);
    }

    public void addRandomBytes(byte[] byArray, int n, int n2) {
    }

    private synchronized void fillBuffer() {
        byte[] byArray;
        int n;
        int n2 = this.hmac_md5.macSize();
        for (n = 0; n < this.buffer.length; n += n2) {
            this.hmac_md5.update(this.md5_a, 0, this.md5_a.length);
            this.hmac_md5.update(this.seed, 0, this.seed.length);
            byArray = this.hmac_md5.digest();
            this.hmac_md5.reset();
            System.arraycopy(byArray, 0, this.buffer, n, n2);
            this.hmac_md5.update(this.md5_a, 0, this.md5_a.length);
            this.md5_a = this.hmac_md5.digest();
            this.hmac_md5.reset();
        }
        n2 = this.hmac_sha.macSize();
        for (n = 0; n < this.buffer.length; n += n2) {
            this.hmac_sha.update(this.sha_a, 0, this.sha_a.length);
            this.hmac_sha.update(this.seed, 0, this.seed.length);
            byArray = this.hmac_sha.digest();
            this.hmac_sha.reset();
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n;
                this.buffer[n3] = (byte)(this.buffer[n3] ^ byArray[i]);
            }
            this.hmac_sha.update(this.sha_a, 0, this.sha_a.length);
            this.sha_a = this.hmac_sha.digest();
            this.hmac_sha.reset();
        }
        this.idx = 0;
    }
}

