/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.SessionStoreException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SimpleSessionContext
extends AbstractSessionContext {
    public static final int DEFAULT_TIMEOUT = 300;
    private final HashMap<Session.ID, Session> store = new HashMap();
    private int storeLimit = 0;

    public SimpleSessionContext() {
        super(300);
    }

    protected Session implGet(byte[] byArray) {
        return this.store.get(new Session.ID(byArray));
    }

    public void load(char[] cArray) throws SessionStoreException {
    }

    public void put(Session session) {
        if (this.storeLimit > 0 && this.store.size() >= this.storeLimit) {
            Session session2 = null;
            for (Map.Entry<Session.ID, Session> entry : this.store.entrySet()) {
                Session session3 = entry.getValue();
                long l = session3.getLastAccessedTime();
                if (session2 != null && session2.getLastAccessedTime() <= l) continue;
                session2 = session3;
            }
            this.store.remove(session2.id());
        }
        this.store.put(session.id(), session);
    }

    public void remove(byte[] byArray) {
        this.store.remove(new Session.ID(byArray));
    }

    public void store(char[] cArray) throws SessionStoreException {
    }

    public Enumeration getIds() {
        return new Enumeration(){
            Iterator<Session.ID> it;
            {
                this.it = SimpleSessionContext.this.store.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            public Object nextElement() {
                return this.it.next().id();
            }
        };
    }

    public int getSessionCacheSize() {
        return this.storeLimit;
    }

    public void setSessionCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("cache size must be nonnegative");
        }
        this.storeLimit = n;
    }
}

