/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class Signature
implements Builder,
Constructed {
    private final ByteBuffer buffer;
    private final SignatureAlgorithm alg;

    public Signature(ByteBuffer byteBuffer, SignatureAlgorithm signatureAlgorithm) {
        this.buffer = byteBuffer;
        this.alg = signatureAlgorithm;
    }

    public Signature(byte[] byArray, SignatureAlgorithm signatureAlgorithm) {
        this.buffer = ByteBuffer.allocate(byArray.length + 2);
        this.buffer.putShort((short)byArray.length);
        this.buffer.put(byArray);
        this.buffer.position(0);
        this.alg = signatureAlgorithm;
    }

    public int length() {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return 0;
        }
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public byte[] signature() {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return new byte[0];
        }
        int n = this.buffer.getShort(0) & 0xFFFF;
        byte[] byArray = new byte[n];
        ((ByteBuffer)this.buffer.duplicate().position(2)).get(byArray);
        return byArray;
    }

    public void setSignature(byte[] byArray) {
        this.setSignature(byArray, 0, byArray.length);
    }

    public void setSignature(byte[] byArray, int n, int n2) {
        if (this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            return;
        }
        this.buffer.putShort(0, (short)n2);
        this.buffer.position(2);
        this.buffer.put(byArray, n, n2);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (!this.alg.equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            String string2 = "  ";
            if (string != null) {
                string2 = string + string2;
            }
            printWriter.print(Util.hexDump(this.signature(), string2));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} Signature;");
        return stringWriter.toString();
    }
}

