/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.key.GnuPBEKey;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.net.ssl.SSLException;

public class SessionImpl
extends Session {
    static final long serialVersionUID = 8932976607588442485L;
    CipherSuite suite;
    ProtocolVersion version;
    byte[] privateDataSalt;
    SealedObject sealedPrivateData;
    MaxFragmentLength maxLength;
    transient PrivateData privateData = new PrivateData();

    SecureRandom random() {
        return this.random;
    }

    public String getProtocol() {
        return this.version.toString();
    }

    public void prepare(char[] cArray) throws SSLException {
        try {
            this.privateDataSalt = new byte[32];
            this.random.nextBytes(this.privateDataSalt);
            GnuPBEKey gnuPBEKey = new GnuPBEKey(cArray, this.privateDataSalt, 1000);
            Cipher cipher = Cipher.getInstance("PBEWithHMacSHA256AndAES/OFB/PKCS7Padding");
            cipher.init(1, gnuPBEKey);
            this.sealedPrivateData = new SealedObject(this.privateData, cipher);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SSLException(illegalBlockSizeException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException);
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SSLException(noSuchPaddingException);
        }
    }

    public void repair(char[] cArray) throws SSLException {
        try {
            GnuPBEKey gnuPBEKey = new GnuPBEKey(cArray, this.privateDataSalt, 1000);
            this.privateData = (PrivateData)this.sealedPrivateData.getObject(gnuPBEKey);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SSLException(classNotFoundException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException);
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException);
        }
    }

    public SealedObject privateData() throws SSLException {
        if (this.privateData == null) {
            throw new SSLException("this session has not been prepared");
        }
        return this.sealedPrivateData;
    }

    public void setPrivateData(SealedObject sealedObject) throws SSLException {
        this.sealedPrivateData = sealedObject;
    }

    void setApplicationBufferSize(int n) {
        this.applicationBufferSize = n;
    }

    void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    void setTruncatedMac(boolean bl) {
        this.truncatedMac = bl;
    }

    void setId(Session.ID iD) {
        this.sessionId = iD;
    }

    void setLocalCertificates(Certificate[] certificateArray) {
        this.localCerts = certificateArray;
    }

    void setPeerCertificates(Certificate[] certificateArray) {
        this.peerCerts = certificateArray;
    }

    void setPeerVerified(boolean bl) {
        this.peerVerified = bl;
    }

    static class PrivateData
    implements Serializable {
        static final long serialVersionUID = -8040597659545984581L;
        byte[] masterSecret;

        PrivateData() {
        }
    }
}

