/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class ServerRSAParams
implements ServerKeyExchangeParams {
    private final ByteBuffer buffer;

    public ServerRSAParams(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.RSA;
    }

    public int length() {
        int n = this.buffer.getShort(0) & 0xFFFF;
        return (this.buffer.getShort(n + 2) & 0xFFFF) + n + 4;
    }

    public BigInteger modulus() {
        int n = this.buffer.getShort(0) & 0xFFFF;
        byte[] byArray = new byte[n];
        this.buffer.position(2);
        this.buffer.get(byArray);
        return new BigInteger(1, byArray);
    }

    public BigInteger exponent() {
        int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        byte[] byArray = new byte[n2];
        this.buffer.position(n + 2);
        this.buffer.get(byArray);
        return new BigInteger(1, byArray);
    }

    public void setModulus(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray[0] == 0 ? byArray.length - 1 : byArray.length;
        int n2 = byArray[0] == 0 ? 1 : 0;
        this.buffer.putShort(0, (short)n);
        this.buffer.position(2);
        this.buffer.put(byArray, n2, n);
    }

    public void setExponent(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray[0] == 0 ? byArray.length - 1 : byArray.length;
        int n2 = byArray[0] == 0 ? 1 : 0;
        int n3 = (this.buffer.getShort(0) & 0xFFFF) + 2;
        this.buffer.putShort(n3, (short)n);
        this.buffer.position(n3 + 2);
        this.buffer.put(byArray, n2, n);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  rsa_modulus:  ");
        printWriter.println(this.modulus().toString(16));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  rsa_exponent: ");
        printWriter.println(this.exponent());
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerRSAParams;");
        return stringWriter.toString();
    }
}

