/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import gnu.javax.net.ssl.provider.ServerPSKParameters;
import gnu.javax.net.ssl.provider.ServerRSAParams;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ServerKeyExchange
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CipherSuite suite;

    public ServerKeyExchange(ByteBuffer byteBuffer, CipherSuite cipherSuite) {
        cipherSuite.getClass();
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.suite = cipherSuite;
    }

    public int length() {
        if (this.suite.keyExchangeAlgorithm().equals((Object)KeyExchangeAlgorithm.NONE)) {
            return 0;
        }
        int n = 0;
        ServerKeyExchangeParams serverKeyExchangeParams = this.params();
        Signature signature = this.signature();
        if (serverKeyExchangeParams != null) {
            n += serverKeyExchangeParams.length();
        }
        if (signature != null) {
            n += signature.length();
        }
        return n;
    }

    public ServerKeyExchangeParams params() {
        KeyExchangeAlgorithm keyExchangeAlgorithm = this.suite.keyExchangeAlgorithm();
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA) {
            return new ServerRSAParams(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon) {
            return new ServerDHParams(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.NONE) {
            return null;
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
            return new ServerDHE_PSKParameters(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK) {
            return new ServerPSKParameters(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
            return new ServerPSKParameters(this.buffer.duplicate());
        }
        throw new IllegalArgumentException("unsupported key exchange: " + (Object)((Object)keyExchangeAlgorithm));
    }

    public Signature signature() {
        KeyExchangeAlgorithm keyExchangeAlgorithm = this.suite.keyExchangeAlgorithm();
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.NONE || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK || keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
            return null;
        }
        ServerKeyExchangeParams serverKeyExchangeParams = this.params();
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.position(serverKeyExchangeParams.length())).slice();
        return new Signature(byteBuffer, this.suite.signatureAlgorithm());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  algorithm: ");
        printWriter.print((Object)this.suite.keyExchangeAlgorithm());
        printWriter.println(";");
        if (!this.suite.keyExchangeAlgorithm().equals((Object)KeyExchangeAlgorithm.NONE)) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("  parameters:");
            printWriter.println(this.params().toString(string != null ? string + "  " : "  "));
        }
        if (!this.suite.signatureAlgorithm().equals((Object)SignatureAlgorithm.ANONYMOUS)) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("  signature:");
            printWriter.println(this.signature().toString(string != null ? string + "  " : "  "));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerKeyExchange;");
        return stringWriter.toString();
    }
}

