/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class ServerHello
implements Handshake.Body {
    protected static final int RANDOM_OFFSET = 2;
    protected static final int SESSID_OFFSET = 34;
    protected static final int SESSID_OFFSET2 = 35;
    protected ByteBuffer buffer;
    protected boolean disableExtensions;

    public ServerHello(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.disableExtensions = false;
    }

    public int length() {
        int n = this.buffer.get(34) & 0xFF;
        int n2 = 35 + n + 3;
        short s = 0;
        if (!this.disableExtensions && n2 + 1 < this.buffer.limit() && (s = this.buffer.getShort(n2)) != 0) {
            n2 += 2 + s;
        }
        return n2;
    }

    public ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(0));
    }

    public Random random() {
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(2).limit(34)).slice();
        return new Random(byteBuffer);
    }

    public byte[] sessionId() {
        int n = this.buffer.get(34) & 0xFF;
        byte[] byArray = new byte[n];
        this.buffer.position(35);
        this.buffer.get(byArray);
        return byArray;
    }

    public CipherSuite cipherSuite() {
        int n = 35 + (this.buffer.get(34) & 0xFF);
        return CipherSuite.forValue(this.buffer.getShort(n)).resolve();
    }

    public CompressionMethod compressionMethod() {
        int n = 35 + (this.buffer.get(34) & 0xFF) + 2;
        return CompressionMethod.getInstance(this.buffer.get(n) & 0xFF);
    }

    public int extensionsLength() {
        int n = 35 + (this.buffer.get(34) & 0xFF) + 3;
        if (n + 1 >= this.buffer.limit()) {
            return 0;
        }
        return this.buffer.getShort(n) & 0xFFFF;
    }

    public ExtensionList extensions() {
        int n = 35 + (this.buffer.get(34) & 0xFF) + 3;
        if (n + 1 >= this.buffer.limit()) {
            return null;
        }
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        if (n2 == 0) {
            n2 = this.buffer.limit() - n - 2;
        }
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(n).limit(n + n2 + 2)).slice();
        return new ExtensionList(byteBuffer);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        String string2 = "  ";
        if (string != null) {
            string2 = string2 + string;
        }
        printWriter.print(string2);
        printWriter.print("version: ");
        printWriter.print(this.version());
        printWriter.println(";");
        printWriter.print(string2);
        printWriter.println("random:");
        printWriter.println(this.random().toString(string2));
        printWriter.print(string2);
        printWriter.print("sessionId:         ");
        printWriter.print(Util.toHexString(this.sessionId(), ':'));
        printWriter.println(";");
        printWriter.print(string2);
        printWriter.print("cipherSuite:       ");
        printWriter.print(this.cipherSuite());
        printWriter.println(";");
        printWriter.print(string2);
        printWriter.print("compressionMethod: ");
        printWriter.print((Object)this.compressionMethod());
        printWriter.println(";");
        ExtensionList extensionList = this.extensions();
        printWriter.print(string2);
        printWriter.println("extensions:");
        printWriter.println(extensionList != null ? extensionList.toString(string2 + "  ") : string2 + "  (nil)");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerHello;");
        return stringWriter.toString();
    }
}

