/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateBuilder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateRequestBuilder;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CipherSuiteList;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.CompressionMethodList;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.DiffieHellman;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerHelloBuilder;
import gnu.javax.net.ssl.provider.ServerKeyExchangeBuilder;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.ServerPSKParameters;
import gnu.javax.net.ssl.provider.ServerRSA_PSKParameters;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Signature;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.Util;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

class ServerHandshake
extends AbstractHandshake {
    private State state;
    private ByteBuffer outBuffer;
    private boolean clientHadExtensions = false;
    private boolean continuedSession = false;
    private ServerNameList requestedNames = null;
    private String keyAlias = null;
    private X509Certificate clientCert = null;
    private X509Certificate localCert = null;
    private boolean helloV2 = false;
    private KeyPair dhPair;
    private PrivateKey serverKey;
    private GenDH genDH;
    private AbstractHandshake.CertVerifier certVerifier;
    private CertLoader certLoader;
    private DelegatedTask keyExchangeTask;

    ServerHandshake(boolean bl, SSLEngineImpl sSLEngineImpl) throws NoSuchAlgorithmException {
        super(sSLEngineImpl);
        this.state = bl ? State.WRITE_HELLO_REQUEST : State.READ_CLIENT_HELLO;
        this.handshakeOffset = 0;
    }

    private static ProtocolVersion chooseProtocol(ProtocolVersion protocolVersion, String[] stringArray) throws SSLException {
        ProtocolVersion protocolVersion2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ProtocolVersion protocolVersion3 = ProtocolVersion.forName(stringArray[i]);
            if (protocolVersion3.compareTo(protocolVersion) > 0 || protocolVersion2 != null && protocolVersion3.compareTo(protocolVersion2) <= 0) continue;
            protocolVersion2 = protocolVersion3;
        }
        if (protocolVersion2 == null) {
            throw new SSLException("no acceptable protocol version available");
        }
        return protocolVersion2;
    }

    private CipherSuite chooseSuite(CipherSuiteList cipherSuiteList, String[] stringArray, ProtocolVersion protocolVersion) throws SSLException {
        HashSet<KeyExchangeAlgorithm> hashSet = new HashSet<KeyExchangeAlgorithm>(8);
        hashSet.add(KeyExchangeAlgorithm.NONE);
        X509ExtendedKeyManager x509ExtendedKeyManager = this.engine.contextImpl.keyManager;
        if (x509ExtendedKeyManager != null) {
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.DH_DSS.name(), null).length > 0) {
                hashSet.add(KeyExchangeAlgorithm.DH_DSS);
            }
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.DH_RSA.name(), null).length > 0) {
                hashSet.add(KeyExchangeAlgorithm.DH_RSA);
            }
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.DHE_DSS.name(), null).length > 0) {
                hashSet.add(KeyExchangeAlgorithm.DHE_DSS);
            }
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.DHE_RSA.name(), null).length > 0) {
                hashSet.add(KeyExchangeAlgorithm.DHE_RSA);
            }
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.RSA.name(), null).length > 0) {
                hashSet.add(KeyExchangeAlgorithm.RSA);
            }
            if (x509ExtendedKeyManager.getServerAliases(KeyExchangeAlgorithm.RSA_PSK.name(), null).length > 0 && this.engine.contextImpl.pskManager != null) {
                hashSet.add(KeyExchangeAlgorithm.RSA_PSK);
            }
        }
        if (this.engine.contextImpl.pskManager != null) {
            hashSet.add(KeyExchangeAlgorithm.DHE_PSK);
            hashSet.add(KeyExchangeAlgorithm.PSK);
        }
        logger.logv(Component.SSL_HANDSHAKE, "we have certs for key exchange algorithms {0}", hashSet);
        HashSet<CipherSuite> hashSet2 = new HashSet<CipherSuite>();
        for (String string : stringArray) {
            CipherSuite cipherSuite = CipherSuite.forName(string);
            if (cipherSuite == null || !hashSet.contains((Object)cipherSuite.keyExchangeAlgorithm())) continue;
            hashSet2.add(cipherSuite);
        }
        for (CipherSuite cipherSuite : cipherSuiteList) {
            CipherSuite cipherSuite2 = cipherSuite.resolve();
            if (!cipherSuite2.isResolved() || !hashSet2.contains(cipherSuite2)) continue;
            return cipherSuite2;
        }
        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INSUFFICIENT_SECURITY));
    }

    private static CompressionMethod chooseCompression(CompressionMethodList compressionMethodList) throws SSLException {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.enable.compression");
        String string = AccessController.doPrivileged(getSecurityPropertyAction);
        if (Boolean.valueOf(string).booleanValue()) {
            for (CompressionMethod compressionMethod : compressionMethodList) {
                if (!compressionMethod.equals((Object)CompressionMethod.ZLIB)) continue;
                return CompressionMethod.ZLIB;
            }
        }
        for (CompressionMethod compressionMethod : compressionMethodList) {
            if (!compressionMethod.equals((Object)CompressionMethod.NULL)) continue;
            return CompressionMethod.NULL;
        }
        throw new SSLException("no supported compression method");
    }

    protected boolean doHash() {
        boolean bl = this.helloV2;
        this.helloV2 = false;
        return this.state != State.WRITE_HELLO_REQUEST && !bl;
    }

    /*
     * Unable to fully structure code
     */
    public SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException {
        if (this.state == State.DONE) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        var1_1 = this.handshakeBuffer.duplicate();
        var1_1.flip();
        var1_1.position(this.handshakeOffset);
        var2_2 = new Handshake(var1_1.slice(), this.engine.session().suite, this.engine.session().version);
        ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "processing in state {0}:\n{1}", new Object[]{this.state, var2_2});
        switch (1.$SwitchMap$gnu$javax$net$ssl$provider$ServerHandshake$State[this.state.ordinal()]) {
            case 1: {
                if (var2_2.type() != Handshake.Type.CLIENT_HELLO) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                var3_3 = (ClientHello)var2_2.body();
                this.engine.session().version = ServerHandshake.chooseProtocol(var3_3.version(), this.engine.getEnabledProtocols());
                this.engine.session().suite = this.chooseSuite(var3_3.cipherSuites(), this.engine.getEnabledCipherSuites(), this.engine.session().version);
                this.compression = ServerHandshake.chooseCompression(var3_3.compressionMethods());
                ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "chose version:{0} suite:{1} compression:{2}", new Object[]{this.engine.session().version, this.engine.session().suite, this.compression});
                this.clientRandom = var3_3.random().copy();
                var4_8 = var3_3.sessionId();
                if (var3_3.hasExtensions()) {
                    var5_15 = var3_3.extensions();
                    this.clientHadExtensions = var5_15.size() > 0;
                    block31: for (Object var7_31 : var3_3.extensions()) {
                        var8_36 = var7_31.type();
                        if (var8_36 == null) continue;
                        switch (1.$SwitchMap$gnu$javax$net$ssl$provider$Extension$Type[var8_36.ordinal()]) {
                            case 1: {
                                this.engine.session().setTruncatedMac(true);
                                continue block31;
                            }
                            case 2: {
                                this.engine.session().maxLength = var9_38 = (MaxFragmentLength)var7_31.value();
                                this.engine.session().setApplicationBufferSize(var9_38.maxLength());
                                continue block31;
                            }
                            case 3: {
                                this.requestedNames = (ServerNameList)var7_31.value();
                                var10_40 = new ArrayList<String>(this.requestedNames.size());
                                for (ServerNameList.ServerName var12_42 : this.requestedNames) {
                                    var10_40.add(var12_42.name());
                                }
                                this.engine.session().putValue("gnu.javax.net.ssl.RequestedServerNames", var10_40);
                                continue block31;
                            }
                        }
                        ServerHandshake.logger.log(Level.INFO, "skipping unsupported extension {0}", var7_31);
                    }
                }
                var5_15 = (AbstractSessionContext)this.engine.contextImpl.engineGetServerSessionContext();
                var6_24 = var5_15.getSession(var4_8);
                ServerHandshake.logger.logv(Component.SSL_HANDSHAKE, "looked up saved session {0}", new Object[]{var6_24});
                if (var6_24 != null && var6_24.isValid() && var6_24 instanceof SessionImpl) {
                    this.engine.setSession((SessionImpl)var6_24);
                    this.continuedSession = true;
                } else {
                    if (this.engine.session().id().equals(new Session.ID(var4_8))) {
                        var7_31 = new byte[32];
                        this.engine.session().random().nextBytes((byte[])var7_31);
                        this.engine.session().setId(new Session.ID((byte[])var7_31));
                    }
                    var5_15.put(this.engine.session());
                }
                this.state = State.WRITE_SERVER_HELLO;
                break;
            }
            case 2: {
                if (var2_2.type() != Handshake.Type.CERTIFICATE) {
                    if (this.engine.getNeedClientAuth()) {
                        throw new SSLException("client auth required");
                    }
                    this.state = State.READ_CLIENT_KEY_EXCHANGE;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                var3_4 = (Certificate)var2_2.body();
                try {
                    this.engine.session().setPeerVerified(false);
                    var4_9 = var3_4.certificates().toArray(new X509Certificate[0]);
                    if (var4_9.length == 0) {
                        throw new CertificateException("no certificates in chain");
                    }
                    this.certVerifier = new AbstractHandshake.CertVerifier(this, false, (X509Certificate[])var4_9);
                    this.tasks.add(this.certVerifier);
                    this.engine.session().setPeerCertificates(var4_9);
                    this.clientCert = var4_9[0];
                }
                catch (CertificateException var4_10) {
                    if (this.engine.getNeedClientAuth()) {
                        var5_16 = new SSLPeerUnverifiedException("client certificates could not be verified");
                        var5_16.initCause(var4_10);
                        throw var5_16;
                    }
                }
                catch (NoSuchAlgorithmException var4_11) {
                    throw new SSLException(var4_11);
                }
                this.state = State.READ_CLIENT_KEY_EXCHANGE;
                break;
            }
            case 3: {
                if (var2_2.type() != Handshake.Type.CLIENT_KEY_EXCHANGE) {
                    throw new SSLException("expecting client key exchange");
                }
                var3_5 = (ClientKeyExchange)var2_2.body();
                var4_12 = this.engine.session().suite.keyExchangeAlgorithm();
                switch (1.$SwitchMap$gnu$javax$net$ssl$provider$KeyExchangeAlgorithm[var4_12.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        var5_17 = (ClientDiffieHellmanPublic)var3_5.exchangeKeys();
                        var6_25 = (DHPublicKey)this.dhPair.getPublic();
                        var7_32 = new GnuDHPublicKey(null, var6_25.getParams().getP(), var6_25.getParams().getG(), var5_17.publicValue());
                        this.keyExchangeTask = new AbstractHandshake.DHPhase(this, var7_32);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 4: {
                        var5_18 = (EncryptedPreMasterSecret)var3_5.exchangeKeys();
                        this.keyExchangeTask = new RSAKeyExchange(var5_18.encryptedSecret());
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 5: {
                        var5_19 = (ClientPSKParameters)var3_5.exchangeKeys();
                        this.generatePSKSecret(var5_19.identity(), null, false);
                        break;
                    }
                    case 6: {
                        var5_20 = (ClientDHE_PSKParameters)var3_5.exchangeKeys();
                        var6_26 = (DHPublicKey)this.dhPair.getPublic();
                        var7_33 = new GnuDHPublicKey(null, var6_26.getParams().getP(), var6_26.getParams().getG(), var5_20.params().publicValue());
                        var8_37 = null;
                        try {
                            var8_37 = this.engine.contextImpl.pskManager.getKey(var5_20.identity());
                        }
                        catch (KeyManagementException var9_39) {
                            // empty catch block
                        }
                        this.keyExchangeTask = new AbstractHandshake.DHE_PSKGen(this, var7_33, var8_37, false);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 7: {
                        var5_21 = (ClientRSA_PSKParameters)var3_5.exchangeKeys();
                        var6_27 = null;
                        try {
                            var6_27 = this.engine.contextImpl.pskManager.getKey(var5_21.identity());
                        }
                        catch (KeyManagementException var7_34) {
                            // empty catch block
                        }
                        if (var6_27 == null) {
                            var7_35 = new byte[16];
                            this.engine.session().random().nextBytes(var7_35);
                            var6_27 = new SecretKeySpec(var7_35, "DHE_PSK");
                        }
                        this.keyExchangeTask = new RSA_PSKExchange(var5_21.secret().encryptedSecret(), var6_27);
                        this.tasks.add(this.keyExchangeTask);
                        break;
                    }
                    case 8: {
                        var5_22 = null;
                        var6_28 = null;
                        if (this.compression == CompressionMethod.ZLIB) {
                            var5_22 = new Inflater();
                            var6_28 = new Deflater();
                        }
                        this.inParams = new InputSecurityParameters(null, null, var5_22, this.engine.session(), this.engine.session().suite);
                        this.outParams = new OutputSecurityParameters(null, null, var6_28, this.engine.session(), this.engine.session().suite);
                        this.engine.session().privateData.masterSecret = new byte[0];
                    }
                }
                if (this.clientCert != null) {
                    this.state = State.READ_CERTIFICATE_VERIFY;
                    break;
                }
                this.state = State.READ_FINISHED;
                break;
            }
            case 4: {
                if (var2_2.type() != Handshake.Type.CERTIFICATE_VERIFY) {
                    throw new SSLException("expecting certificate verify message");
                }
                var3_6 = (CertificateVerify)var2_2.body();
                try {
                    this.verifyClient(var3_6.signature());
                    if (this.certVerifier != null && this.certVerifier.verified()) {
                        this.engine.session().setPeerVerified(true);
                    }
                }
                catch (SignatureException var4_13) {
                    if (!this.engine.getNeedClientAuth()) ** GOTO lbl171
                    throw new SSLException("client auth failed", var4_13);
                }
lbl171:
                // 2 sources

                if (this.continuedSession) {
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break;
                }
                this.state = State.READ_FINISHED;
                break;
            }
            case 5: {
                if (var2_2.type() != Handshake.Type.FINISHED) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                var3_7 = (Finished)var2_2.body();
                var4_14 = null;
                var5_23 = null;
                try {
                    var4_14 = (MessageDigest)this.md5.clone();
                    var5_23 = (MessageDigest)this.sha.clone();
                }
                catch (CloneNotSupportedException var6_29) {
                    throw new SSLException(var6_29);
                }
                var6_30 = new Finished(this.generateFinished(var4_14, var5_23, true, this.engine.session()), this.engine.session().version);
                ServerHandshake.logger.log((Level)Component.SSL_HANDSHAKE, "server finished: {0}", var6_30);
                if (this.engine.session().version == ProtocolVersion.SSL_3) {
                    if (!Arrays.equals(var3_7.md5Hash(), var6_30.md5Hash()) || !Arrays.equals(var3_7.shaHash(), var6_30.shaHash())) {
                        this.engine.session().invalidate();
                        throw new SSLException("session verify failed");
                    }
                } else if (!Arrays.equals(var3_7.verifyData(), var6_30.verifyData())) {
                    this.engine.session().invalidate();
                    throw new SSLException("session verify failed");
                }
                if (this.continuedSession) {
                    this.state = State.DONE;
                    break;
                }
                this.engine.changeCipherSpec();
                this.state = State.WRITE_FINISHED;
            }
        }
        this.handshakeOffset += var2_2.length() + 4;
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer byteBuffer) throws SSLException {
        logger.logv(Component.SSL_HANDSHAKE, "handle output state: {0}; output fragment: {1}", new Object[]{this.state, byteBuffer});
        if (this.outBuffer != null && this.outBuffer.hasRemaining()) {
            int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
            byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
            this.outBuffer.position(this.outBuffer.position() + n);
        }
        if (!byteBuffer.hasRemaining()) {
            if (!this.state.isWriteState() && !this.outBuffer.hasRemaining()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        block13: while (byteBuffer.remaining() >= 4 && this.state.isWriteState()) {
            switch (this.state) {
                case WRITE_HELLO_REQUEST: {
                    Handshake handshake = new Handshake(byteBuffer);
                    handshake.setType(Handshake.Type.HELLO_REQUEST);
                    handshake.setLength(0);
                    byteBuffer.position(byteBuffer.position() + 4);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", handshake);
                    this.state = State.READ_CLIENT_HELLO;
                    break block13;
                }
                case WRITE_SERVER_HELLO: {
                    ServerHelloBuilder serverHelloBuilder = new ServerHelloBuilder();
                    serverHelloBuilder.setVersion(this.engine.session().version);
                    Object object = serverHelloBuilder.random();
                    ((Random)object).setGmtUnixTime(Util.unixTime());
                    byte[] byArray = new byte[28];
                    this.engine.session().random().nextBytes(byArray);
                    ((Random)object).setRandomBytes(byArray);
                    this.serverRandom = ((Random)object).copy();
                    serverHelloBuilder.setSessionId(this.engine.session().getId());
                    serverHelloBuilder.setCipherSuite(this.engine.session().suite);
                    serverHelloBuilder.setCompressionMethod(this.compression);
                    if (!this.clientHadExtensions) {
                        serverHelloBuilder.setDisableExtensions(true);
                    }
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", serverHelloBuilder);
                    int n3 = Handshake.Type.SERVER_HELLO.getValue() << 24 | serverHelloBuilder.length() & 0xFFFFFF;
                    byteBuffer.putInt(n3);
                    this.outBuffer = serverHelloBuilder.buffer();
                    int n2 = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n2));
                    this.outBuffer.position(this.outBuffer.position() + n2);
                    Object object2 = this.engine.session().suite;
                    KeyExchangeAlgorithm keyExchangeAlgorithm = ((CipherSuite)object2).keyExchangeAlgorithm();
                    if (this.continuedSession) {
                        byte[][] byArray2 = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
                        this.setupSecurityParameters(byArray2, false, this.engine, this.compression);
                        this.engine.changeCipherSpec();
                        this.state = State.WRITE_FINISHED;
                        break;
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
                        this.certLoader = new CertLoader();
                        this.tasks.add(this.certLoader);
                        this.state = State.WRITE_CERTIFICATE;
                        if (keyExchangeAlgorithm != KeyExchangeAlgorithm.DHE_DSS && keyExchangeAlgorithm != KeyExchangeAlgorithm.DHE_RSA) break block13;
                        this.genDH = new GenDH();
                        this.tasks.add(this.genDH);
                        break block13;
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK) {
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break;
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon) {
                        this.genDH = new GenDH();
                        this.tasks.add(this.genDH);
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break block13;
                    }
                    if (this.engine.getWantClientAuth() || this.engine.getNeedClientAuth()) {
                        this.state = State.WRITE_CERTIFICATE_REQUEST;
                        break;
                    }
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    break;
                }
                case WRITE_CERTIFICATE: {
                    assert (this.certLoader != null);
                    assert (this.certLoader.hasRun());
                    if (this.certLoader.thrown() != null) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.certLoader.thrown());
                    }
                    java.security.cert.Certificate[] certificateArray = this.engine.session().getLocalCertificates();
                    Object object = new CertificateBuilder(CertificateType.X509);
                    try {
                        ((CertificateBuilder)object).setCertificates(Arrays.asList(certificateArray));
                    }
                    catch (CertificateException certificateException) {
                        throw new SSLException(certificateException);
                    }
                    logger.logv(Component.SSL_HANDSHAKE, "my cert:\n{0}", this.localCert);
                    logger.logv(Component.SSL_HANDSHAKE, "{0}", object);
                    int n = Handshake.Type.CERTIFICATE.getValue() << 24 | ((Certificate)object).length() & 0xFFFFFF;
                    byteBuffer.putInt(n);
                    this.outBuffer = ((CertificateBuilder)object).buffer();
                    int n3 = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n3));
                    this.outBuffer.position(this.outBuffer.position() + n3);
                    CipherSuite cipherSuite = this.engine.session().suite;
                    Object object2 = cipherSuite.keyExchangeAlgorithm();
                    if (object2 == KeyExchangeAlgorithm.DHE_DSS || object2 == KeyExchangeAlgorithm.DHE_RSA) {
                        this.genDH = new GenDH();
                        this.tasks.add(this.genDH);
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break block13;
                    }
                    if (object2 == KeyExchangeAlgorithm.RSA_PSK) {
                        this.state = State.WRITE_SERVER_KEY_EXCHANGE;
                        break block13;
                    }
                    if (this.engine.getWantClientAuth() || this.engine.getNeedClientAuth()) {
                        this.state = State.WRITE_CERTIFICATE_REQUEST;
                        break block13;
                    }
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    break block13;
                }
                case WRITE_SERVER_KEY_EXCHANGE: {
                    String string;
                    String string2;
                    KeyExchangeAlgorithm keyExchangeAlgorithm = this.engine.session().suite.keyExchangeAlgorithm();
                    Object object = null;
                    ByteBuffer byteBuffer2 = null;
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
                        assert (this.genDH != null);
                        assert (this.genDH.hasRun());
                        if (this.genDH.thrown() != null) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.genDH.thrown());
                        }
                        assert (this.dhPair != null);
                        this.initDiffieHellman((DHPrivateKey)this.dhPair.getPrivate(), this.engine.session().random());
                        object = this.genDH.paramsBuffer;
                        byteBuffer2 = this.genDH.sigBuffer;
                        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
                            String string3 = this.engine.contextImpl.pskManager.chooseIdentityHint();
                            ServerDHE_PSKParameters serverDHE_PSKParameters = new ServerDHE_PSKParameters(string3, (ByteBuffer)object);
                            object = serverDHE_PSKParameters.buffer();
                        }
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK && (string2 = this.engine.contextImpl.pskManager.chooseIdentityHint()) != null) {
                        ServerRSA_PSKParameters serverRSA_PSKParameters = new ServerRSA_PSKParameters(string2);
                        object = serverRSA_PSKParameters.buffer();
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK && (string = this.engine.contextImpl.pskManager.chooseIdentityHint()) != null) {
                        ServerPSKParameters serverPSKParameters = new ServerPSKParameters(string);
                        object = serverPSKParameters.buffer();
                    }
                    if (object != null) {
                        ServerKeyExchangeBuilder serverKeyExchangeBuilder = new ServerKeyExchangeBuilder(this.engine.session().suite);
                        serverKeyExchangeBuilder.setParams((ByteBuffer)object);
                        if (byteBuffer2 != null) {
                            serverKeyExchangeBuilder.setSignature(byteBuffer2);
                        }
                        logger.log((Level)Component.SSL_HANDSHAKE, "{0}", serverKeyExchangeBuilder);
                        this.outBuffer = serverKeyExchangeBuilder.buffer();
                        int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                        byteBuffer.putInt(Handshake.Type.SERVER_KEY_EXCHANGE.getValue() << 24 | serverKeyExchangeBuilder.length() & 0xFFFFFF);
                        byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                        this.outBuffer.position(this.outBuffer.position() + n);
                    }
                    if (this.engine.getWantClientAuth() || this.engine.getNeedClientAuth()) {
                        this.state = State.WRITE_CERTIFICATE_REQUEST;
                        break;
                    }
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    break;
                }
                case WRITE_CERTIFICATE_REQUEST: {
                    CertificateRequestBuilder certificateRequestBuilder = new CertificateRequestBuilder();
                    Object object = new ArrayList<CertificateRequest.ClientCertificateType>(4);
                    object.add(CertificateRequest.ClientCertificateType.RSA_SIGN);
                    object.add(CertificateRequest.ClientCertificateType.RSA_FIXED_DH);
                    object.add(CertificateRequest.ClientCertificateType.DSS_SIGN);
                    object.add(CertificateRequest.ClientCertificateType.DSS_FIXED_DH);
                    certificateRequestBuilder.setTypes((List<CertificateRequest.ClientCertificateType>)object);
                    X509Certificate[] x509CertificateArray = this.engine.contextImpl.trustManager.getAcceptedIssuers();
                    ArrayList<X500Principal> arrayList = new ArrayList<X500Principal>(x509CertificateArray.length);
                    for (X509Certificate x509Certificate : x509CertificateArray) {
                        arrayList.add(x509Certificate.getIssuerX500Principal());
                    }
                    certificateRequestBuilder.setAuthorities(arrayList);
                    logger.log((Level)Component.SSL_HANDSHAKE, "{0}", certificateRequestBuilder);
                    byteBuffer.putInt(Handshake.Type.CERTIFICATE_REQUEST.getValue() << 24 | certificateRequestBuilder.length() & 0xFFFFFF);
                    this.outBuffer = certificateRequestBuilder.buffer();
                    int n = Math.min(this.outBuffer.remaining(), byteBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    this.state = State.WRITE_SERVER_HELLO_DONE;
                    break;
                }
                case WRITE_SERVER_HELLO_DONE: {
                    byteBuffer.putInt(Handshake.Type.SERVER_HELLO_DONE.getValue() << 24);
                    logger.logv(Component.SSL_HANDSHAKE, "writing ServerHelloDone", new Object[0]);
                    this.state = State.READ_CERTIFICATE;
                    break block13;
                }
                case WRITE_FINISHED: {
                    MessageDigest messageDigest = null;
                    Object object = null;
                    try {
                        messageDigest = (MessageDigest)this.md5.clone();
                        object = (MessageDigest)this.sha.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new SSLException(cloneNotSupportedException);
                    }
                    this.outBuffer = this.generateFinished(messageDigest, (MessageDigest)object, false, this.engine.session());
                    byteBuffer.putInt(Handshake.Type.FINISHED.getValue() << 24 | this.outBuffer.remaining() & 0xFFFFFF);
                    int n = Math.min(this.outBuffer.remaining(), byteBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    this.state = this.continuedSession ? State.READ_FINISHED : State.DONE;
                }
            }
        }
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    SSLEngineResult.HandshakeStatus status() {
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    void checkKeyExchange() throws SSLException {
        if (this.continuedSession) {
            return;
        }
        KeyExchangeAlgorithm keyExchangeAlgorithm = this.engine.session().suite.keyExchangeAlgorithm();
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.NONE || keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
            return;
        }
        if (this.keyExchangeTask == null) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR));
        }
        if (!this.keyExchangeTask.hasRun()) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR));
        }
        if (this.keyExchangeTask.thrown() != null) {
            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.keyExchangeTask.thrown());
        }
    }

    void handleV2Hello(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort(0) & Short.MAX_VALUE;
        this.md5.update((ByteBuffer)byteBuffer.duplicate().position(2).limit(n + 2));
        this.sha.update((ByteBuffer)byteBuffer.duplicate().position(2).limit(n + 2));
        this.helloV2 = true;
    }

    private ByteBuffer signParams(ByteBuffer byteBuffer) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        SignatureAlgorithm signatureAlgorithm = this.engine.session().suite.signatureAlgorithm();
        java.security.Signature signature = java.security.Signature.getInstance(signatureAlgorithm.algorithm());
        PrivateKey privateKey = this.engine.contextImpl.keyManager.getPrivateKey(this.keyAlias);
        logger.logv(Component.SSL_HANDSHAKE, "server key: {0}", privateKey);
        signature.initSign(privateKey);
        signature.update(this.clientRandom.buffer());
        signature.update(this.serverRandom.buffer());
        signature.update(byteBuffer);
        byte[] byArray = signature.sign();
        Signature signature2 = new Signature(byArray, this.engine.session().suite.signatureAlgorithm());
        return signature2.buffer();
    }

    private void verifyClient(byte[] byArray) throws SSLException, SignatureException {
        MessageDigest messageDigest = null;
        MessageDigest messageDigest2 = null;
        try {
            messageDigest = (MessageDigest)this.md5.clone();
            messageDigest2 = (MessageDigest)this.sha.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SSLException(cloneNotSupportedException);
        }
        byte[] byArray2 = null;
        byArray2 = this.engine.session().version == ProtocolVersion.SSL_3 ? this.genV3CertificateVerify(messageDigest, messageDigest2, this.engine.session()) : (this.engine.session().suite.signatureAlgorithm() == SignatureAlgorithm.RSA ? Util.concat(messageDigest.digest(), messageDigest2.digest()) : messageDigest2.digest());
        try {
            java.security.Signature signature = java.security.Signature.getInstance(this.engine.session().suite.signatureAlgorithm().toString());
            signature.initVerify(this.clientCert);
            signature.update(byArray2);
            signature.verify(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SSLException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SSLException(noSuchAlgorithmException);
        }
    }

    class RSA_PSKExchange
    extends DelegatedTask {
        private final byte[] encryptedPreMasterSecret;
        private final SecretKey psKey;

        RSA_PSKExchange(byte[] byArray, SecretKey secretKey) {
            this.encryptedPreMasterSecret = byArray;
            this.psKey = secretKey;
        }

        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, ServerHandshake.this.serverKey);
            cipher.init(2, ServerHandshake.this.localCert);
            byte[] byArray = cipher.doFinal(this.encryptedPreMasterSecret);
            byte[] byArray2 = this.psKey.getEncoded();
            ServerHandshake.this.preMasterSecret = new byte[byArray.length + byArray2.length + 4];
            ServerHandshake.this.preMasterSecret[0] = (byte)(byArray.length >>> 8);
            ServerHandshake.this.preMasterSecret[1] = (byte)byArray.length;
            System.arraycopy(byArray, 0, ServerHandshake.this.preMasterSecret, 2, byArray.length);
            ServerHandshake.this.preMasterSecret[byArray.length + 2] = (byte)(byArray2.length >>> 8);
            ServerHandshake.this.preMasterSecret[byArray.length + 3] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, ServerHandshake.this.preMasterSecret, byArray.length + 4, byArray2.length);
            ServerHandshake.this.generateMasterSecret(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            byte[][] byArray3 = ServerHandshake.this.generateKeys(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            ServerHandshake.this.setupSecurityParameters(byArray3, false, ServerHandshake.this.engine, ServerHandshake.this.compression);
        }
    }

    class RSAKeyExchange
    extends DelegatedTask {
        private final byte[] encryptedPreMasterSecret;

        RSAKeyExchange(byte[] byArray) {
            this.encryptedPreMasterSecret = byArray;
        }

        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, ServerHandshake.this.serverKey);
            cipher.init(2, ServerHandshake.this.localCert);
            ServerHandshake.this.preMasterSecret = cipher.doFinal(this.encryptedPreMasterSecret);
            ServerHandshake.this.generateMasterSecret(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            byte[][] byArray = ServerHandshake.this.generateKeys(ServerHandshake.this.clientRandom, ServerHandshake.this.serverRandom, ServerHandshake.this.engine.session());
            ServerHandshake.this.setupSecurityParameters(byArray, false, ServerHandshake.this.engine, ServerHandshake.this.compression);
        }
    }

    private class GenDH
    extends DelegatedTask {
        ByteBuffer paramsBuffer;
        ByteBuffer sigBuffer;

        private GenDH() {
        }

        protected void implRun() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, SignatureException {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            DHParameterSpec dHParameterSpec = DiffieHellman.getParams().getParams();
            keyPairGenerator.initialize(dHParameterSpec, ServerHandshake.this.engine.session().random());
            ServerHandshake.this.dhPair = keyPairGenerator.generateKeyPair();
            DHPublicKey dHPublicKey = (DHPublicKey)ServerHandshake.this.dhPair.getPublic();
            ServerDHParams serverDHParams = new ServerDHParams(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG(), dHPublicKey.getY());
            this.paramsBuffer = serverDHParams.buffer();
            if (ServerHandshake.this.engine.session().suite.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                this.sigBuffer = ServerHandshake.this.signParams(this.paramsBuffer);
                this.paramsBuffer.rewind();
            }
            AbstractHandshake.logger.logv(Component.SSL_KEY_EXCHANGE, "Diffie-Hellman public:{0} private:{1}", ServerHandshake.this.dhPair.getPublic(), ServerHandshake.this.dhPair.getPrivate());
        }
    }

    class CertLoader
    extends DelegatedTask {
        CertLoader() {
        }

        public void implRun() throws SSLException {
            KeyExchangeAlgorithm keyExchangeAlgorithm = ServerHandshake.this.engine.session().suite.keyExchangeAlgorithm();
            X509ExtendedKeyManager x509ExtendedKeyManager = ServerHandshake.this.engine.contextImpl.keyManager;
            Principal[] principalArray = null;
            ServerHandshake.this.keyAlias = x509ExtendedKeyManager.chooseEngineServerAlias(keyExchangeAlgorithm.name(), principalArray, ServerHandshake.this.engine);
            if (ServerHandshake.this.keyAlias == null) {
                throw new SSLException("no certificates available");
            }
            java.security.cert.Certificate[] certificateArray = x509ExtendedKeyManager.getCertificateChain(ServerHandshake.this.keyAlias);
            ServerHandshake.this.engine.session().setLocalCertificates(certificateArray);
            ServerHandshake.this.localCert = (X509Certificate)certificateArray[0];
            ServerHandshake.this.serverKey = x509ExtendedKeyManager.getPrivateKey(ServerHandshake.this.keyAlias);
            if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_RSA) {
                ServerHandshake.this.dhPair = new KeyPair(ServerHandshake.this.localCert.getPublicKey(), x509ExtendedKeyManager.getPrivateKey(ServerHandshake.this.keyAlias));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WRITE_HELLO_REQUEST(true, false),
        WRITE_SERVER_HELLO(true, false),
        WRITE_CERTIFICATE(true, false),
        WRITE_SERVER_KEY_EXCHANGE(true, false),
        WRITE_CERTIFICATE_REQUEST(true, false),
        WRITE_SERVER_HELLO_DONE(true, false),
        WRITE_FINISHED(true, false),
        READ_CLIENT_HELLO(false, true),
        READ_CERTIFICATE(false, true),
        READ_CLIENT_KEY_EXCHANGE(false, true),
        READ_CERTIFICATE_VERIFY(false, true),
        READ_FINISHED(false, true),
        DONE(false, false);

        private final boolean isWriteState;
        private final boolean isReadState;

        private State(boolean bl, boolean bl2) {
            this.isWriteState = bl;
            this.isReadState = bl2;
        }

        boolean isReadState() {
            return this.isReadState;
        }

        boolean isWriteState() {
            return this.isWriteState;
        }
    }
}

