/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ServerDHParams
implements Builder,
ServerKeyExchangeParams {
    private final ByteBuffer buffer;

    public ServerDHParams(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerDHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = bigInteger2.toByteArray();
        byte[] byArray3 = bigInteger3.toByteArray();
        int n = byArray.length + byArray2.length + byArray3.length + 6;
        int n2 = 0;
        if (byArray[0] == 0) {
            n2 = 1;
            --n;
        }
        int n3 = 0;
        if (byArray2[0] == 0) {
            n3 = 1;
            --n;
        }
        int n4 = 0;
        if (byArray3[0] == 0) {
            n4 = 1;
            --n;
        }
        int n5 = byArray.length - n2;
        int n6 = byArray2.length - n3;
        int n7 = byArray3.length - n4;
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.putShort((short)n5);
        this.buffer.put(byArray, n2, n5);
        this.buffer.putShort((short)n6);
        this.buffer.put(byArray2, n3, n6);
        this.buffer.putShort((short)n7);
        this.buffer.put(byArray3, n4, n7);
    }

    @Deprecated
    public KeyExchangeAlgorithm algorithm() {
        return null;
    }

    public int length() {
        int n = this.buffer.getShort(0) & 0xFFFF;
        int n2 = this.buffer.getShort(n + 2) & 0xFFFF;
        return (this.buffer.getShort(n + n2 + 4) & 0xFFFF) + n + n2 + 6;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().position(0).limit(this.length());
    }

    public BigInteger p() {
        int n = this.buffer.getShort(0) & 0xFFFF;
        byte[] byArray = new byte[n];
        this.buffer.position(2);
        this.buffer.get(byArray);
        return new BigInteger(1, byArray);
    }

    public BigInteger g() {
        int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        byte[] byArray = new byte[n2];
        this.buffer.position(n + 2);
        this.buffer.get(byArray);
        return new BigInteger(1, byArray);
    }

    public BigInteger y() {
        int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int n2 = (this.buffer.getShort(n) & 0xFFFF) + n + 2;
        int n3 = this.buffer.getShort(n2) & 0xFFFF;
        byte[] byArray = new byte[n3];
        this.buffer.position(n2 + 2);
        this.buffer.get(byArray);
        return new BigInteger(1, byArray);
    }

    public void setP(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray[0] == 0 ? byArray.length - 1 : byArray.length;
        int n2 = byArray[0] == 0 ? 1 : 0;
        this.buffer.putShort(0, (short)n);
        this.buffer.position(2);
        this.buffer.put(byArray, n2, n);
    }

    public void setG(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = byArray[0] == 0 ? byArray.length - 1 : byArray.length;
        int n2 = byArray[0] == 0 ? 1 : 0;
        int n3 = (this.buffer.getShort(0) & 0xFFFF) + 2;
        this.buffer.putShort(n3, (short)n);
        this.buffer.position(n3 + 2);
        this.buffer.put(byArray, n2, n);
    }

    public void setY(BigInteger bigInteger) {
        int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int n2 = (this.buffer.getShort(n) & 0xFFFF) + n + 2;
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray[0] == 0 ? byArray.length - 1 : byArray.length;
        int n4 = byArray[0] == 0 ? 1 : 0;
        this.buffer.putShort(n2, (short)n3);
        this.buffer.position(n2 + 2);
        this.buffer.put(byArray, n4, n3);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  dh_p:  ");
        printWriter.println(this.p().toString(16));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  dh_g:  ");
        printWriter.println(this.g().toString(16));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  dh_Ys: ");
        printWriter.println(this.y().toString(16));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerDHParams;");
        return stringWriter.toString();
    }
}

