/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public class ServerDHE_PSKParameters
implements Constructed,
Builder,
ServerKeyExchangeParams {
    private ByteBuffer buffer;

    public ServerDHE_PSKParameters(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerDHE_PSKParameters(String string, ServerDHParams serverDHParams) {
        this(string, serverDHParams.buffer());
    }

    public ServerDHE_PSKParameters(String string, ByteBuffer byteBuffer) {
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer2 = charset.encode(string);
        this.buffer = ByteBuffer.allocate(2 + byteBuffer2.remaining() + byteBuffer.remaining());
        this.buffer.putShort((short)byteBuffer2.remaining());
        this.buffer.put(byteBuffer2);
        this.buffer.put(byteBuffer);
    }

    public KeyExchangeAlgorithm algorithm() {
        return KeyExchangeAlgorithm.DHE_PSK;
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2 + this.params().length();
    }

    private int hintLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identityHint() {
        Charset charset = Charset.forName("UTF-8");
        return charset.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.hintLength())).toString();
    }

    public ServerDHParams params() {
        return new ServerDHParams(((ByteBuffer)this.buffer.duplicate().position(this.hintLength()).limit(this.buffer.capacity())).slice());
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  identity_hint = ");
        printWriter.print(this.identityHint());
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  params =");
        printWriter.println(this.params().toString(string != null ? string + "    " : "    "));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ServerDHE_PSKParameters;");
        return stringWriter.toString();
    }
}

