/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.SSLHMac;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public class SSLv3HMacMD5Impl
extends MacSpi {
    private final SSLHMac adaptee = new SSLHMac("MD5");

    protected byte[] engineDoFinal() {
        return this.adaptee.digest();
    }

    protected int engineGetMacLength() {
        return this.adaptee.macSize();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(key instanceof SecretKey) || !key.getAlgorithm().equalsIgnoreCase("SSLv3HMac-MD5")) {
            throw new InvalidKeyException("expecting secret key with algorithm \"SSLv3HMac-MD5\"");
        }
        Map<String, byte[]> map = Collections.singletonMap("gnu.crypto.mac.key.material", key.getEncoded());
        this.adaptee.init(map);
    }

    protected void engineReset() {
        this.adaptee.reset();
    }

    protected void engineUpdate(byte by) {
        this.adaptee.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.adaptee.update(byArray, n, n2);
    }
}

