/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class SSLSocketImpl
extends SSLSocket {
    private static final SystemLogger logger = SystemLogger.getSystemLogger();
    private SSLEngineImpl engine;
    private Set<HandshakeCompletedListener> listeners;
    private Socket underlyingSocket;
    private boolean isHandshaking;
    private IOException handshakeException;
    private boolean initialHandshakeDone = false;
    private final boolean autoClose;

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n) {
        this(sSLContextImpl, string, n, new Socket(), true);
    }

    public SSLSocketImpl(SSLContextImpl sSLContextImpl, String string, int n, Socket socket, boolean bl) {
        this.engine = new SSLEngineImpl(sSLContextImpl, string, n);
        this.engine.setUseClientMode(true);
        this.listeners = new HashSet<HandshakeCompletedListener>();
        this.underlyingSocket = socket;
        this.autoClose = bl;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.listeners.add(handshakeCompletedListener);
    }

    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        return this.engine.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.engine.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.listeners.remove(handshakeCompletedListener);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.engine.setEnableSessionCreation(bl);
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.engine.setEnabledCipherSuites(stringArray);
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.engine.setEnabledProtocols(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.engine.setNeedClientAuth(bl);
    }

    public void setUseClientMode(boolean bl) {
        this.engine.setUseClientMode(bl);
    }

    public void setWantClientAuth(boolean bl) {
        this.engine.setWantClientAuth(bl);
    }

    public void startHandshake() throws IOException {
        if (this.isHandshaking) {
            return;
        }
        if (this.handshakeException != null) {
            throw this.handshakeException;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    SSLSocketImpl.this.doHandshake();
                }
                catch (IOException iOException) {
                    SSLSocketImpl.this.handshakeException = iOException;
                }
            }
        }, "HandshakeThread@" + System.identityHashCode(this));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void doHandshake() throws IOException {
        Object object;
        SSLEngineImpl sSLEngineImpl2 = this.engine;
        // MONITORENTER : sSLEngineImpl2
        if (this.isHandshaking) {
            try {
                this.engine.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.isHandshaking = true;
        // MONITOREXIT : sSLEngineImpl2
        if (this.initialHandshakeDone) {
            throw new SSLException("rehandshaking not yet implemented");
        }
        long l = -System.currentTimeMillis();
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        assert (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
        Object object2 = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
        ((Buffer)object2).position(((Buffer)object2).limit());
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(0);
        SSLEngineResult sSLEngineResult = null;
        DataInputStream dataInputStream = new DataInputStream(this.underlyingSocket.getInputStream());
        OutputStream outputStream = this.underlyingSocket.getOutputStream();
        try {
            try {}
            catch (SSLException n2) {
                this.handshakeException = n2;
                throw n2;
            }
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            SSLEngineImpl sSLEngineImpl = this.engine;
            // MONITORENTER : sSLEngineImpl
            this.isHandshaking = false;
            this.engine.notifyAll();
            // MONITOREXIT : sSLEngineImpl
            throw throwable;
        }
        while (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            logger.logv(Component.SSL_HANDSHAKE, "socket processing state {0}", new Object[]{handshakeStatus});
            if (((Buffer)object2).capacity() != this.getSession().getPacketBufferSize()) {
                object = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
                if (((Buffer)object2).hasRemaining()) {
                    ((ByteBuffer)object).put((ByteBuffer)object2).flip();
                }
                object2 = object;
            }
            if (byteBuffer.capacity() != this.getSession().getPacketBufferSize()) {
                byteBuffer = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
            }
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    int n;
                    ((Buffer)object2).clear();
                    int object22 = dataInputStream.read();
                    if (object22 == -1) {
                        throw new EOFException();
                    }
                    if ((object22 & 0x80) == 128) {
                        ((ByteBuffer)object2).put((byte)object22);
                        n = (object22 & 0x7F) << 8;
                        object22 = dataInputStream.read();
                        ((ByteBuffer)object2).put((byte)object22);
                        dataInputStream.readFully(((ByteBuffer)object2).array(), 2, n |= object22 & 0xFF);
                        ((Buffer)object2).position(0).limit(n + 2);
                    } else {
                        ((ByteBuffer)object2).put((byte)object22);
                        ((ByteBuffer)object2).putInt(dataInputStream.readInt());
                        n = ((ByteBuffer)object2).getShort(3) & 0xFFFF;
                        dataInputStream.readFully(((ByteBuffer)object2).array(), 5, n);
                        ((Buffer)object2).position(0).limit(n + 5);
                    }
                    sSLEngineResult = this.engine.unwrap((ByteBuffer)object2, byteBuffer2);
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) break;
                    throw new SSLException("unexpected SSL status " + (Object)((Object)sSLEngineResult.getStatus()));
                }
                case NEED_WRAP: {
                    byteBuffer.clear();
                    sSLEngineResult = this.engine.wrap(byteBuffer2, byteBuffer);
                    handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
                        throw new SSLException("unexpected SSL status " + (Object)((Object)sSLEngineResult.getStatus()));
                    }
                    byteBuffer.flip();
                    outputStream.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                    break;
                }
                case NEED_TASK: {
                    Runnable n;
                    while ((n = this.engine.getDelegatedTask()) != null) {
                        n.run();
                    }
                    handshakeStatus = this.engine.getHandshakeStatus();
                    break;
                }
            }
        }
        this.initialHandshakeDone = true;
        object = new HandshakeCompletedEvent(this, this.getSession());
        for (HandshakeCompletedListener handshakeCompletedListener : this.listeners) {
            try {
                handshakeCompletedListener.handshakeCompleted((HandshakeCompletedEvent)object);
            }
            catch (ThreadDeath throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                logger.log(Component.WARNING, "HandshakeCompletedListener threw exception", throwable);
            }
        }
        logger.logv(Component.SSL_HANDSHAKE, "handshake completed in {0}ms in thread {1}", l += System.currentTimeMillis(), Thread.currentThread().getName());
        Object var15_20 = null;
        SSLEngineImpl sSLEngineImpl = this.engine;
        // MONITORENTER : sSLEngineImpl
        this.isHandshaking = false;
        this.engine.notifyAll();
        // MONITOREXIT : sSLEngineImpl
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.underlyingSocket.bind(socketAddress);
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.underlyingSocket.connect(socketAddress);
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        this.underlyingSocket.connect(socketAddress, n);
    }

    public InetAddress getInetAddress() {
        return this.underlyingSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.underlyingSocket.getLocalAddress();
    }

    public int getPort() {
        return this.underlyingSocket.getPort();
    }

    public int getLocalPort() {
        return this.underlyingSocket.getLocalPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.underlyingSocket.getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.underlyingSocket.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        throw new UnsupportedOperationException("use javax.net.ssl.SSLEngine for NIO");
    }

    public InputStream getInputStream() throws IOException {
        return new SocketInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return new SocketOutputStream();
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.underlyingSocket.setTcpNoDelay(bl);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.underlyingSocket.getTcpNoDelay();
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.underlyingSocket.setSoLinger(bl, n);
    }

    public int getSoLinger() throws SocketException {
        return this.underlyingSocket.getSoLinger();
    }

    public void sendUrgentData(int n) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.underlyingSocket.setOOBInline(bl);
    }

    public boolean getOOBInline() throws SocketException {
        return this.underlyingSocket.getOOBInline();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.underlyingSocket.setSoTimeout(n);
    }

    public int getSoTimeout() throws SocketException {
        return this.underlyingSocket.getSoTimeout();
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.underlyingSocket.setSendBufferSize(n);
    }

    public int getSendBufferSize() throws SocketException {
        return this.underlyingSocket.getSendBufferSize();
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.underlyingSocket.setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.underlyingSocket.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.underlyingSocket.setKeepAlive(bl);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.underlyingSocket.getKeepAlive();
    }

    public void setTrafficClass(int n) throws SocketException {
        this.underlyingSocket.setTrafficClass(n);
    }

    public int getTrafficClass() throws SocketException {
        return this.underlyingSocket.getTrafficClass();
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.underlyingSocket.setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.underlyingSocket.getReuseAddress();
    }

    public void close() throws IOException {
        if (this.autoClose) {
            this.underlyingSocket.close();
        }
    }

    public void shutdownInput() throws IOException {
        this.underlyingSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.underlyingSocket.shutdownOutput();
    }

    public boolean isConnected() {
        return this.underlyingSocket.isConnected();
    }

    public boolean isBound() {
        return this.underlyingSocket.isBound();
    }

    public boolean isClosed() {
        return this.underlyingSocket.isClosed();
    }

    public boolean isInputShutdown() {
        return this.underlyingSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.underlyingSocket.isOutputShutdown();
    }

    private class SocketInputStream
    extends InputStream {
        private final ByteBuffer inBuffer;
        private final ByteBuffer appBuffer;
        private final DataInputStream in;

        SocketInputStream() throws IOException {
            this.inBuffer = ByteBuffer.wrap(new byte[SSLSocketImpl.this.getSession().getPacketBufferSize()]);
            this.inBuffer.limit(0);
            this.appBuffer = ByteBuffer.allocate(SSLSocketImpl.this.getSession().getApplicationBufferSize());
            this.appBuffer.flip();
            this.in = SSLSocketImpl.this.underlyingSocket != null ? new DataInputStream(SSLSocketImpl.this.underlyingSocket.getInputStream()) : new DataInputStream(SSLSocketImpl.super.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (!SSLSocketImpl.this.initialHandshakeDone || SSLSocketImpl.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SSLSocketImpl.this.doHandshake();
                if (SSLSocketImpl.this.handshakeException != null) {
                    throw SSLSocketImpl.this.handshakeException;
                }
            }
            if (!this.appBuffer.hasRemaining()) {
                n3 = this.in.read();
                if (n3 == -1) {
                    return -1;
                }
                this.inBuffer.clear();
                this.inBuffer.put((byte)n3);
                this.inBuffer.putInt(this.in.readInt());
                int n4 = this.inBuffer.getShort(3) & 0xFFFF;
                this.in.readFully(this.inBuffer.array(), 5, n4);
                this.inBuffer.position(0).limit(n4 + 5);
                SSLEngineImpl sSLEngineImpl = SSLSocketImpl.this.engine;
                synchronized (sSLEngineImpl) {
                    this.appBuffer.clear();
                    SSLEngineResult sSLEngineResult = SSLSocketImpl.this.engine.unwrap(this.inBuffer, this.appBuffer);
                    SSLEngineResult.Status status = sSLEngineResult.getStatus();
                    if (status == SSLEngineResult.Status.CLOSED && sSLEngineResult.bytesProduced() == 0) {
                        return -1;
                    }
                }
                this.inBuffer.compact();
                this.appBuffer.flip();
            }
            n3 = Math.min(n2, this.appBuffer.remaining());
            this.appBuffer.get(byArray, n, n3);
            return n3;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.read(byArray) == -1) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }
    }

    private class SocketOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;
        private final OutputStream out;

        SocketOutputStream() throws IOException {
            this.buffer = ByteBuffer.wrap(new byte[SSLSocketImpl.this.getSession().getPacketBufferSize()]);
            this.out = SSLSocketImpl.this.underlyingSocket != null ? SSLSocketImpl.this.underlyingSocket.getOutputStream() : SSLSocketImpl.super.getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            SSLEngineResult sSLEngineResult;
            if (!SSLSocketImpl.this.initialHandshakeDone || SSLSocketImpl.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SSLSocketImpl.this.doHandshake();
                if (SSLSocketImpl.this.handshakeException != null) {
                    throw SSLSocketImpl.this.handshakeException;
                }
            }
            for (int i = 0; i < n2; i += sSLEngineResult.bytesConsumed()) {
                SSLEngineImpl sSLEngineImpl = SSLSocketImpl.this.engine;
                synchronized (sSLEngineImpl) {
                    int n3 = Math.min(n2 - i, SSLSocketImpl.this.getSession().getApplicationBufferSize());
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n + i, n3);
                    sSLEngineResult = SSLSocketImpl.this.engine.wrap(byteBuffer, this.buffer);
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                        return;
                    }
                    if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK) {
                        throw new SSLException("unexpected SSL state " + (Object)((Object)sSLEngineResult.getStatus()));
                    }
                    this.buffer.flip();
                    this.out.write(this.buffer.array(), 0, this.buffer.limit());
                    this.buffer.clear();
                    continue;
                }
            }
        }

        public void write(int n) throws IOException {
            this.write(new byte[]{(byte)n});
        }

        public void close() throws IOException {
            SSLSocketImpl.this.close();
        }
    }
}

