/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Record {
    private final ByteBuffer buffer;

    public Record(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ContentType getContentType() {
        return this.contentType();
    }

    public ContentType contentType() {
        return ContentType.forInteger(this.buffer.get(0) & 0xFF);
    }

    public int fragment(ByteBuffer byteBuffer) {
        int n = this.length();
        byteBuffer.put(((ByteBuffer)this.buffer.limit(5 + n).position(5)).slice());
        return n;
    }

    public ByteBuffer fragment() {
        int n = this.length();
        return ((ByteBuffer)this.buffer.limit(5 + n).position(5)).slice();
    }

    public int length() {
        return this.buffer.getShort(3) & 0xFFFF;
    }

    public ProtocolVersion version() {
        int n = this.buffer.get(1) & 0xFF;
        int n2 = this.buffer.get(2) & 0xFF;
        return ProtocolVersion.getInstance(n, n2);
    }

    public void setContentType(ContentType contentType) {
        this.buffer.put(0, (byte)contentType.getValue());
    }

    public void setLength(int n) {
        if (n < 0 || n > 16384) {
            throw new IllegalArgumentException("length " + n + " out of range; must be between 0 and 16384");
        }
        this.buffer.putShort(3, (short)n);
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.buffer.put(1, (byte)protocolVersion.major()).put(2, (byte)protocolVersion.minor());
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.print("  type:    ");
        printWriter.print((Object)this.contentType());
        printWriter.println(";");
        printWriter.print("  version: ");
        printWriter.print(this.version());
        printWriter.println(";");
        printWriter.print("  length: ");
        printWriter.print(this.length());
        printWriter.println(";");
        printWriter.println("  fragment {");
        printWriter.print(Util.hexDump(this.fragment(), "    "));
        printWriter.println("  };");
        printWriter.print("} Record;");
        return stringWriter.toString();
    }
}

