/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolVersion
implements Comparable<ProtocolVersion>,
Constructed {
    public static final ProtocolVersion SSL_3 = new ProtocolVersion(3, 0);
    public static final ProtocolVersion TLS_1 = new ProtocolVersion(3, 1);
    public static final ProtocolVersion TLS_1_1 = new ProtocolVersion(3, 2);
    private final int major;
    private final int minor;

    private ProtocolVersion(int n, int n2) {
        this.major = n;
        this.minor = n2;
    }

    public static ProtocolVersion read(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = inputStream.read() & 0xFF;
        return ProtocolVersion.getInstance(n, n2);
    }

    public static ProtocolVersion forName(String string) {
        if (string.equalsIgnoreCase("SSLv3")) {
            return SSL_3;
        }
        if (string.equalsIgnoreCase("TLSv1")) {
            return TLS_1;
        }
        if (string.equalsIgnoreCase("TLSv1.1")) {
            return TLS_1_1;
        }
        throw new IllegalArgumentException("unknown protocol name: " + string);
    }

    public static ProtocolVersion getInstance(int n, int n2) {
        if (n == 3) {
            switch (n2) {
                case 0: {
                    return SSL_3;
                }
                case 1: {
                    return TLS_1;
                }
                case 2: {
                    return TLS_1_1;
                }
            }
        }
        return new ProtocolVersion(n, n2);
    }

    public static ProtocolVersion getInstance(short s) {
        int n = s >>> 8 & 0xFF;
        int n2 = s & 0xFF;
        return ProtocolVersion.getInstance(n, n2);
    }

    @Override
    public int length() {
        return 2;
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.major, (byte)this.minor};
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int rawValue() {
        return this.major << 8 | this.minor;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProtocolVersion)) {
            return false;
        }
        return ((ProtocolVersion)object).major == this.major && ((ProtocolVersion)object).minor == this.minor;
    }

    public int hashCode() {
        return this.major << 8 | this.minor;
    }

    @Override
    public int compareTo(ProtocolVersion protocolVersion) {
        if (this.major > protocolVersion.major) {
            return 1;
        }
        if (this.major < protocolVersion.major) {
            return -1;
        }
        if (this.minor > protocolVersion.minor) {
            return 1;
        }
        if (this.minor < protocolVersion.minor) {
            return -1;
        }
        return 0;
    }

    @Override
    public String toString(String string) {
        return this.toString();
    }

    public String toString() {
        if (this == SSL_3) {
            return "SSLv3";
        }
        if (this == TLS_1) {
            return "TLSv1";
        }
        if (this == TLS_1_1) {
            return "TLSv1.1";
        }
        return "Unsupported; major=" + this.major + " minor=" + this.minor;
    }
}

