/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ContentType;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Util;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;

public class OutputSecurityParameters {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private final Mac mac;
    private final Deflater deflater;
    private final SessionImpl session;
    private final CipherSuite suite;
    private long sequence;
    static final boolean enableCBCProtection;

    public OutputSecurityParameters(Cipher cipher, Mac mac, Deflater deflater, SessionImpl sessionImpl, CipherSuite cipherSuite) {
        this.cipher = cipher;
        this.mac = mac;
        this.deflater = deflater;
        this.session = sessionImpl;
        this.suite = cipherSuite;
        this.sequence = 0L;
    }

    public int[] encrypt(ByteBuffer[] byteBufferArray, int n, int n2, ContentType contentType, ByteBuffer byteBuffer) throws DataFormatException, IllegalBlockSizeException, ShortBufferException {
        int n3;
        ByteBuffer byteBuffer2;
        int n4;
        int n5;
        int n6;
        byte[] byArray;
        byte[] byArray2;
        int n7;
        if (n < 0 || n >= byteBufferArray.length || n2 <= 0 || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (n7 = n; n7 < n + n2; ++n7) {
            logger.logv(Component.SSL_RECORD_LAYER, "encrypting record [{0}]: {1}", n7 - n, byteBufferArray[n7]);
        }
        n7 = 0;
        if (this.mac != null) {
            n7 = this.session.isTruncatedMac() ? 10 : this.mac.getMacLength();
        }
        int n8 = 0;
        byte[] byArray3 = null;
        if (this.session.version.compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
            n8 = this.cipher.getBlockSize();
            byArray3 = new byte[n8];
            this.session.random().nextBytes(byArray3);
        }
        int n9 = 0;
        if (!this.suite.isStreamCipher() && this.session.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            n9 = this.session.random().nextInt(255 / this.cipher.getBlockSize()) * this.cipher.getBlockSize();
        }
        int n10 = 0;
        ByteBuffer[] byteBufferArray2 = null;
        if (this.deflater != null) {
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
            byArray2 = new byte[1024];
            byArray = new byte[1024];
            n6 = 0;
            n5 = byteBuffer.remaining() - (n7 + n8 + n9) - 1024;
            for (n4 = n; n4 < n2 && n6 < n5; ++n4) {
                byteBuffer2 = byteBufferArray[n4];
                while (byteBuffer2.hasRemaining() && n6 < n5) {
                    n3 = Math.min(byteBuffer2.remaining(), byArray2.length);
                    n3 = Math.min(n5 - n6, n3);
                    byteBuffer2.get(byArray2, 0, n3);
                    this.deflater.setInput(byArray2, 0, n3);
                    n3 = this.deflater.deflate(byArray);
                    byteBufferOutputStream.write(byArray, 0, n3);
                    n6 += n3;
                }
            }
            this.deflater.finish();
            while (!this.deflater.finished()) {
                n4 = this.deflater.deflate(byArray);
                byteBufferOutputStream.write(byArray, 0, n4);
                n6 += n4;
            }
            byteBufferArray2 = new ByteBuffer[]{byteBufferOutputStream.buffer()};
            n10 = (int)this.deflater.getBytesWritten() + n7 + n8;
            this.deflater.reset();
            n = 0;
            n2 = 1;
        } else {
            int n11;
            int n12 = byteBuffer.remaining() - (n7 + n8 + n9);
            byteBufferArray2 = byteBufferArray;
            for (int i = n; i < n2 && n10 < n12; n10 += n11, ++i) {
                n11 = Math.min(n12 - n10, byteBufferArray2[i].remaining());
            }
            n10 += n7 + n8;
        }
        int n13 = 0;
        byArray2 = null;
        if (!this.suite.isStreamCipher()) {
            int n14 = this.cipher.getBlockSize();
            n13 = n14 - n10 % n14;
            logger.logv(Component.SSL_RECORD_LAYER, "framentLen:{0} padlen:{1} blocksize:{2}", n10, n13, n14);
            if (this.session.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
                n13 += n9;
                while (n13 > 255) {
                    n13 -= n14;
                }
                byArray2 = new byte[n13];
                for (n6 = 0; n6 < n13; ++n6) {
                    byArray2[n6] = (byte)(n13 - 1);
                }
            } else {
                byArray2 = new byte[n13];
                this.session.random().nextBytes(byArray2);
                byArray2[n13 - 1] = (byte)(n13 - 1);
            }
            n10 += byArray2.length;
        }
        byArray = null;
        if (this.mac != null) {
            this.mac.update((byte)(this.sequence >>> 56));
            this.mac.update((byte)(this.sequence >>> 48));
            this.mac.update((byte)(this.sequence >>> 40));
            this.mac.update((byte)(this.sequence >>> 32));
            this.mac.update((byte)(this.sequence >>> 24));
            this.mac.update((byte)(this.sequence >>> 16));
            this.mac.update((byte)(this.sequence >>> 8));
            this.mac.update((byte)this.sequence);
            this.mac.update((byte)contentType.getValue());
            if (this.session.version != ProtocolVersion.SSL_3) {
                this.mac.update((byte)this.session.version.major());
                this.mac.update((byte)this.session.version.minor());
            }
            n6 = n10 - n7 - n8 - n13;
            this.mac.update((byte)(n6 >>> 8));
            this.mac.update((byte)n6);
            n5 = 0;
            for (n4 = n; n4 < n2 && n5 < n6; ++n4) {
                byteBuffer2 = byteBufferArray2[n4].duplicate();
                n3 = Math.min(byteBuffer2.remaining(), n6 - n5);
                byteBuffer2.limit(byteBuffer2.position() + n3);
                this.mac.update(byteBuffer2);
            }
            byArray = this.mac.doFinal();
        }
        Record record = new Record(byteBuffer);
        record.setContentType(contentType);
        record.setVersion(this.session.version);
        record.setLength(n10);
        n5 = 0;
        ByteBuffer byteBuffer3 = record.fragment();
        if (this.cipher != null) {
            int n15;
            if (byArray3 != null) {
                this.cipher.update(ByteBuffer.wrap(byArray3), byteBuffer3);
            }
            int n16 = n10 - n7 - n8 - n13;
            for (n3 = n; n3 < n + n2 && n5 < n16; n5 += n15, ++n3) {
                ByteBuffer byteBuffer4 = byteBufferArray2[n3].slice();
                n15 = Math.min(byteBuffer4.remaining(), n16 - n5);
                byteBuffer4.limit(byteBuffer4.position() + n15);
                this.cipher.update(byteBuffer4, byteBuffer3);
                byteBufferArray2[n3].position(byteBufferArray2[n3].position() + n15);
            }
            if (byArray != null) {
                this.cipher.update(ByteBuffer.wrap(byArray), byteBuffer3);
            }
            if (byArray2 != null) {
                this.cipher.update(ByteBuffer.wrap(byArray2), byteBuffer3);
            }
        } else {
            int n17;
            int n18 = n10 - n7;
            for (n3 = n; n3 < n + n2 && n5 < n18; n5 += n17, ++n3) {
                ByteBuffer byteBuffer5 = byteBufferArray2[n3];
                n17 = Math.min(byteBuffer5.remaining(), n18 - n5);
                byteBuffer5.limit(byteBuffer5.position() + n17);
                byteBuffer3.put(byteBuffer5);
            }
            if (byArray != null) {
                byteBuffer3.put(byArray);
            }
        }
        byteBuffer.position(byteBuffer.position() + record.length() + 5);
        ++this.sequence;
        return new int[]{n5, n10 + 5};
    }

    CipherSuite suite() {
        return this.suite;
    }

    boolean needToSplitPayload() {
        return this.session.version.compareTo(ProtocolVersion.TLS_1_1) < 0 && this.suite.isCBCMode() && enableCBCProtection;
    }

    static {
        String string = Util.getProperty("jsse.enableCBCProtection");
        enableCBCProtection = string == null ? true : Boolean.valueOf(string);
    }
}

