/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteArray;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Util;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLException;

public class InputSecurityParameters {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private final Mac mac;
    private final Inflater inflater;
    private SessionImpl session;
    private final CipherSuite suite;
    private long sequence;

    public InputSecurityParameters(Cipher cipher, Mac mac, Inflater inflater, SessionImpl sessionImpl, CipherSuite cipherSuite) {
        this.cipher = cipher;
        this.mac = mac;
        this.inflater = inflater;
        this.session = sessionImpl;
        this.suite = cipherSuite;
        this.sequence = 0L;
    }

    public int decrypt(Record record, ByteBuffer[] byteBufferArray, int n, int n2) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        return this.decrypt(record, byteBufferArray, n, n2, null);
    }

    public int decrypt(Record record, ByteBufferOutputStream byteBufferOutputStream) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        return this.decrypt(record, null, 0, 0, byteBufferOutputStream);
    }

    private int decrypt(Record record, ByteBuffer[] byteBufferArray, int n, int n2, ByteBufferOutputStream byteBufferOutputStream) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        int n3;
        ByteBuffer byteBuffer;
        boolean bl = false;
        if (this.cipher != null) {
            ByteBuffer byteBuffer2 = record.fragment();
            byteBuffer = ByteBuffer.allocate(byteBuffer2.remaining());
            this.cipher.update(byteBuffer2, byteBuffer);
        } else {
            byteBuffer = record.fragment();
        }
        int n4 = record.length();
        int n5 = 0;
        if (this.mac != null) {
            n5 = this.mac.getMacLength();
        }
        n4 -= n5;
        int n6 = 0;
        int n7 = 0;
        if (!this.suite.isStreamCipher()) {
            n6 = byteBuffer.get(record.length() - 1) & 0xFF;
            n7 = n6 + 1;
            logger.logv(Component.SSL_RECORD_LAYER, "padlen:{0}", n6);
            if (record.version() == ProtocolVersion.SSL_3) {
                if (n6 > this.cipher.getBlockSize()) {
                    bl = true;
                }
            } else if (record.version().compareTo(ProtocolVersion.TLS_1) >= 0) {
                byte[] byArray3 = new byte[n6];
                ((ByteBuffer)byteBuffer.duplicate().position(record.length() - n6 - 1)).get(byArray3);
                for (n3 = 0; n3 < byArray3.length; ++n3) {
                    if ((byArray3[n3] & 0xFF) == n6) continue;
                    bl = true;
                }
                logger.logv(Component.SSL_RECORD_LAYER, "TLSv1.x padding\n{0}", new ByteArray(byArray3));
            }
            logger.logv(Component.SSL_RECORD_LAYER, "padding bad? {0}", bl);
            if (!bl) {
                n4 -= n7;
            }
        }
        int n8 = 0;
        if (this.session.version.compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
            n8 = this.cipher.getBlockSize();
        }
        if (this.mac != null) {
            this.mac.update((byte)(this.sequence >>> 56));
            this.mac.update((byte)(this.sequence >>> 48));
            this.mac.update((byte)(this.sequence >>> 40));
            this.mac.update((byte)(this.sequence >>> 32));
            this.mac.update((byte)(this.sequence >>> 24));
            this.mac.update((byte)(this.sequence >>> 16));
            this.mac.update((byte)(this.sequence >>> 8));
            this.mac.update((byte)this.sequence);
            this.mac.update((byte)record.getContentType().getValue());
            ProtocolVersion protocolVersion = record.version();
            if (protocolVersion != ProtocolVersion.SSL_3) {
                this.mac.update((byte)protocolVersion.major());
                this.mac.update((byte)protocolVersion.minor());
            }
            this.mac.update((byte)(n4 - n8 >>> 8));
            this.mac.update((byte)(n4 - n8));
            object = (ByteBuffer)byteBuffer.duplicate().position(n8).limit(n4);
            this.mac.update((ByteBuffer)object);
            byArray2 = this.mac.doFinal();
            byArray = new byte[n5];
            this.mac.reset();
            ((ByteBuffer)byteBuffer.duplicate().position(n4)).get(byArray);
            logger.logv(Component.SSL_RECORD_LAYER, "mac1:{0} mac2:{1}", Util.toHexString(byArray2, ':'), Util.toHexString(byArray, ':'));
            if (!Arrays.equals(byArray2, byArray)) {
                bl = true;
            }
        }
        if (bl) {
            throw new MacException();
        }
        n3 = 0;
        if (this.inflater != null) {
            object = new ByteBufferOutputStream(n4);
            byArray2 = new byte[1024];
            byArray = new byte[1024];
            boolean bl2 = false;
            if (record.version().compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
                byteBuffer.position(this.cipher.getBlockSize());
            } else {
                byteBuffer.position(0);
            }
            byteBuffer.limit(n4);
            while (!bl2) {
                int n9;
                if (this.inflater.needsInput()) {
                    n9 = Math.min(byArray2.length, byteBuffer.remaining());
                    byteBuffer.get(byArray2, 0, n9);
                    this.inflater.setInput(byArray2);
                }
                n9 = this.inflater.inflate(byArray);
                ((ByteBufferOutputStream)object).write(byArray, 0, n9);
                bl2 = !byteBuffer.hasRemaining() && this.inflater.finished();
            }
            ByteBuffer byteBuffer3 = ((ByteBufferOutputStream)object).buffer();
            if (byteBufferOutputStream != null) {
                byte[] byArray4 = new byte[1024];
                while (byteBuffer3.hasRemaining()) {
                    int n10 = Math.min(byteBuffer3.remaining(), byArray4.length);
                    byteBuffer3.get(byArray4, 0, n10);
                    byteBufferOutputStream.write(byArray4, 0, n10);
                    n3 += n10;
                }
            } else {
                int n11 = n;
                while (byteBuffer3.hasRemaining() && n11 < n + n2) {
                    int n12 = Math.min(byteBufferArray[n11].remaining(), byteBuffer3.remaining());
                    ByteBuffer byteBuffer4 = (ByteBuffer)byteBuffer3.duplicate().limit(byteBuffer3.position() + n12);
                    byteBufferArray[n11++].put(byteBuffer4);
                    byteBuffer3.position(byteBuffer3.position() + n12);
                    n3 += n12;
                }
                if (byteBuffer3.hasRemaining()) {
                    throw new BufferOverflowException();
                }
            }
        } else {
            object = (ByteBuffer)byteBuffer.duplicate().position(0).limit(record.length() - n5 - n7);
            if (record.version().compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
                ((Buffer)object).position(this.cipher.getBlockSize());
            }
            if (byteBufferOutputStream != null) {
                byArray2 = new byte[1024];
                while (((Buffer)object).hasRemaining()) {
                    int n13 = Math.min(((Buffer)object).remaining(), byArray2.length);
                    ((ByteBuffer)object).get(byArray2, 0, n13);
                    byteBufferOutputStream.write(byArray2, 0, n13);
                    n3 += n13;
                }
            } else {
                int n14 = n;
                while (((Buffer)object).hasRemaining() && n14 < n + n2) {
                    int n15 = Math.min(byteBufferArray[n14].remaining(), ((Buffer)object).remaining());
                    ByteBuffer byteBuffer5 = (ByteBuffer)((ByteBuffer)object).duplicate().limit(((Buffer)object).position() + n15);
                    byteBufferArray[n14++].put(byteBuffer5);
                    ((Buffer)object).position(((Buffer)object).position() + n15);
                    n3 += n15;
                }
                if (((Buffer)object).hasRemaining()) {
                    throw new BufferOverflowException();
                }
            }
        }
        ++this.sequence;
        return n3;
    }

    CipherSuite cipherSuite() {
        return this.suite;
    }
}

