/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.HelloRequest;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerHelloDone;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public final class Handshake
implements Constructed {
    private final ByteBuffer buffer;
    private final CipherSuite suite;
    private final ProtocolVersion version;

    public Handshake(ByteBuffer byteBuffer) {
        this(byteBuffer, null, ProtocolVersion.TLS_1_1);
    }

    public Handshake(ByteBuffer byteBuffer, CipherSuite cipherSuite, ProtocolVersion protocolVersion) {
        this.buffer = byteBuffer;
        this.suite = cipherSuite;
        this.version = protocolVersion;
    }

    public Type type() {
        return Type.forInteger(this.buffer.get(0) & 0xFF);
    }

    public int length() {
        return this.buffer.getInt(0) & 0xFFFFFF;
    }

    public Body body() {
        Type type = this.type();
        ByteBuffer byteBuffer = this.bodyBuffer();
        switch (type) {
            case HELLO_REQUEST: {
                return new HelloRequest();
            }
            case CLIENT_HELLO: {
                return new ClientHello(byteBuffer);
            }
            case SERVER_HELLO: {
                return new ServerHello(byteBuffer);
            }
            case CERTIFICATE: {
                return new Certificate(byteBuffer, CertificateType.X509);
            }
            case SERVER_KEY_EXCHANGE: {
                return new ServerKeyExchange(byteBuffer, this.suite);
            }
            case CERTIFICATE_REQUEST: {
                return new CertificateRequest(byteBuffer);
            }
            case SERVER_HELLO_DONE: {
                return new ServerHelloDone();
            }
            case CERTIFICATE_VERIFY: {
                return new CertificateVerify(byteBuffer, this.suite.signatureAlgorithm());
            }
            case CLIENT_KEY_EXCHANGE: {
                return new ClientKeyExchange(byteBuffer, this.suite, this.version);
            }
            case FINISHED: {
                return new Finished(byteBuffer, this.version);
            }
            case CERTIFICATE_URL: 
            case CERTIFICATE_STATUS: {
                throw new UnsupportedOperationException("FIXME");
            }
        }
        throw new IllegalArgumentException("unknown handshake type " + (Object)((Object)type));
    }

    public ByteBuffer bodyBuffer() {
        int n = this.length();
        return ((ByteBuffer)this.buffer.position(4).limit(4 + n)).slice();
    }

    public void setType(Type type) {
        this.buffer.put(0, (byte)type.getValue());
    }

    public void setLength(int n) {
        if (n < 0 || n > 0xFFFFFF) {
            throw new IllegalArgumentException("length " + n + " out of range; must be between 0 and 16777215");
        }
        this.buffer.put(1, (byte)(n >>> 16));
        this.buffer.put(2, (byte)(n >>> 8));
        this.buffer.put(3, (byte)n);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  type: ");
        printWriter.print((Object)this.type());
        printWriter.println(";");
        Body body = this.body();
        printWriter.println(body.toString(string != null ? string + "  " : "  "));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} Handshake;");
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        HELLO_REQUEST(0),
        CLIENT_HELLO(1),
        SERVER_HELLO(2),
        CERTIFICATE(11),
        SERVER_KEY_EXCHANGE(12),
        CERTIFICATE_REQUEST(13),
        SERVER_HELLO_DONE(14),
        CERTIFICATE_VERIFY(15),
        CLIENT_KEY_EXCHANGE(16),
        FINISHED(20),
        CERTIFICATE_URL(21),
        CERTIFICATE_STATUS(22);

        private final int value;

        private Type(int n2) {
            this.value = n2;
        }

        public static Type forInteger(int n) {
            switch (n & 0xFF) {
                case 0: {
                    return HELLO_REQUEST;
                }
                case 1: {
                    return CLIENT_HELLO;
                }
                case 2: {
                    return SERVER_HELLO;
                }
                case 11: {
                    return CERTIFICATE;
                }
                case 12: {
                    return SERVER_KEY_EXCHANGE;
                }
                case 13: {
                    return CERTIFICATE_REQUEST;
                }
                case 14: {
                    return SERVER_HELLO_DONE;
                }
                case 15: {
                    return CERTIFICATE_VERIFY;
                }
                case 16: {
                    return CLIENT_KEY_EXCHANGE;
                }
                case 20: {
                    return FINISHED;
                }
                case 21: {
                    return CERTIFICATE_URL;
                }
                case 22: {
                    return CERTIFICATE_STATUS;
                }
            }
            throw new IllegalArgumentException("unsupported value type " + n);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static interface Body
    extends Constructed {
        public int length();

        public String toString(String var1);
    }
}

