/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

final class Finished
implements Handshake.Body {
    private final ByteBuffer buffer;
    private final ProtocolVersion version;

    Finished(ByteBuffer byteBuffer, ProtocolVersion protocolVersion) {
        byteBuffer.getClass();
        protocolVersion.getClass();
        this.buffer = byteBuffer;
        this.version = protocolVersion;
    }

    public int length() {
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            return 12;
        }
        if (this.version == ProtocolVersion.SSL_3) {
            return 36;
        }
        throw new IllegalArgumentException("length for this version unknown");
    }

    byte[] verifyData() {
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            byte[] byArray = new byte[12];
            this.buffer.position(0);
            this.buffer.get(byArray);
            return byArray;
        }
        throw new IllegalArgumentException("not TLSv1.0 or later");
    }

    byte[] md5Hash() {
        if (this.version == ProtocolVersion.SSL_3) {
            byte[] byArray = new byte[16];
            this.buffer.position(0);
            this.buffer.get(byArray);
            return byArray;
        }
        throw new IllegalArgumentException("not SSLv3");
    }

    byte[] shaHash() {
        if (this.version == ProtocolVersion.SSL_3) {
            byte[] byArray = new byte[20];
            this.buffer.position(16);
            this.buffer.get(byArray);
            return byArray;
        }
        throw new IllegalArgumentException("not SSLv3");
    }

    void setVerifyData(byte[] byArray, int n) {
        if (this.version == ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not TLSv1");
        }
        this.buffer.position(0);
        this.buffer.put(byArray, n, 12);
    }

    void setMD5Hash(byte[] byArray, int n) {
        if (this.version != ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not SSLv3");
        }
        this.buffer.position(0);
        this.buffer.put(byArray, n, 16);
    }

    void setShaHash(byte[] byArray, int n) {
        if (this.version != ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not SSLv3");
        }
        this.buffer.position(16);
        this.buffer.put(byArray, n, 20);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            printWriter.print("  verifyData = ");
            printWriter.print(Util.toHexString(this.verifyData(), ':'));
        } else if (this.version == ProtocolVersion.SSL_3) {
            printWriter.print("  md5 = ");
            printWriter.print(Util.toHexString(this.md5Hash(), ':'));
            printWriter.println(';');
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  sha = ");
            printWriter.print(Util.toHexString(this.shaHash(), ':'));
        }
        printWriter.println(';');
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} Finished;");
        return stringWriter.toString();
    }
}

