/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CertificateStatusRequest;
import gnu.javax.net.ssl.provider.CertificateURL;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.TruncatedHMAC;
import gnu.javax.net.ssl.provider.TrustedAuthorities;
import gnu.javax.net.ssl.provider.UnresolvedExtensionValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class Extension
implements Builder,
Constructed {
    private ByteBuffer buffer;

    public Extension(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public Extension(Type type, Value value) {
        ByteBuffer byteBuffer = value.buffer();
        int n = 4 + byteBuffer.remaining();
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.putShort((short)type.getValue());
        this.buffer.putShort((short)byteBuffer.remaining());
        this.buffer.put(byteBuffer);
        this.buffer.rewind();
    }

    public int length() {
        return (this.buffer.getShort(2) & 0xFFFF) + 4;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public Type type() {
        return Type.forValue(this.buffer.getShort(0) & 0xFFFF);
    }

    public byte[] valueBytes() {
        int n = this.buffer.getShort(2) & 0xFFFF;
        byte[] byArray = new byte[n];
        ((ByteBuffer)this.buffer.duplicate().position(4)).get(byArray);
        return byArray;
    }

    public ByteBuffer valueBuffer() {
        int n = this.buffer.getShort(2) & 0xFFFF;
        return ((ByteBuffer)this.buffer.duplicate().position(4).limit(n + 4)).slice();
    }

    public Value value() {
        switch (this.type()) {
            case SERVER_NAME: {
                return new ServerNameList(this.valueBuffer());
            }
            case MAX_FRAGMENT_LENGTH: {
                switch (this.valueBuffer().get() & 0xFF) {
                    case 1: {
                        return MaxFragmentLength.LEN_2_9;
                    }
                    case 2: {
                        return MaxFragmentLength.LEN_2_10;
                    }
                    case 3: {
                        return MaxFragmentLength.LEN_2_11;
                    }
                    case 4: {
                        return MaxFragmentLength.LEN_2_12;
                    }
                }
                throw new IllegalArgumentException("invalid max_fragment_len");
            }
            case TRUNCATED_HMAC: {
                return new TruncatedHMAC();
            }
            case CLIENT_CERTIFICATE_URL: {
                return new CertificateURL(this.valueBuffer());
            }
            case TRUSTED_CA_KEYS: {
                return new TrustedAuthorities(this.valueBuffer());
            }
            case STATUS_REQUEST: {
                return new CertificateStatusRequest(this.valueBuffer());
            }
        }
        return new UnresolvedExtensionValue(this.valueBuffer());
    }

    public void setLength(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("length is out of bounds");
        }
        this.buffer.putShort(2, (short)n);
    }

    public void setType(Type type) {
        this.buffer.putShort(0, (short)type.getValue());
    }

    public void setValue(byte[] byArray) {
        this.setValue(byArray, 0, byArray.length);
    }

    public void setValue(byte[] byArray, int n, int n2) {
        if (n2 != this.length()) {
            throw new IllegalArgumentException("length is different than claimed length");
        }
        ((ByteBuffer)this.buffer.duplicate().position(4)).put(byArray, n, n2);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  type = " + (Object)((Object)this.type()) + ";");
        if (string != null) {
            printWriter.print(string);
        }
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        printWriter.println("  value =");
        printWriter.println(this.value().toString(string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} Extension;");
        return stringWriter.toString();
    }

    public static abstract class Value
    implements Builder,
    Constructed {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SERVER_NAME(0),
        MAX_FRAGMENT_LENGTH(1),
        CLIENT_CERTIFICATE_URL(2),
        TRUSTED_CA_KEYS(3),
        TRUNCATED_HMAC(4),
        STATUS_REQUEST(5),
        SRP(6),
        CERT_TYPE(7);

        private final int value;

        private Type(int n2) {
            this.value = n2;
        }

        public static Type forValue(int n) {
            switch (n & 0xFFFF) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return SRP;
                }
                case 7: {
                    return CERT_TYPE;
                }
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

