/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ClientRSA_PSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientRSA_PSKParameters(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ClientRSA_PSKParameters(String string, ByteBuffer byteBuffer) {
        super(null);
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer2 = charset.encode(string);
        this.buffer = ByteBuffer.allocate(2 + byteBuffer2.remaining() + byteBuffer.remaining());
        this.buffer.putShort((short)byteBuffer2.remaining());
        this.buffer.put(byteBuffer2);
        this.buffer.put(byteBuffer);
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public String identity() {
        Charset charset = Charset.forName("UTF-8");
        return charset.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.identityLength())).toString();
    }

    private int identityLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public int length() {
        return this.identityLength() + this.secret().length();
    }

    public EncryptedPreMasterSecret secret() {
        return new EncryptedPreMasterSecret(((ByteBuffer)this.buffer.duplicate().position(this.identityLength()).limit(this.buffer.capacity())).slice(), ProtocolVersion.TLS_1);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  identity = ");
        printWriter.print(this.identity());
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  encrypted_pre_master_secret =");
        printWriter.println(this.secret().toString(string != null ? string + "    " : "    "));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ClientRSA_PSKParameters;");
        return stringWriter.toString();
    }
}

