/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class ClientPSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientPSKParameters(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ClientPSKParameters(String string) {
        super(null);
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(string));
        this.buffer = ByteBuffer.allocate(byteBuffer.remaining() + 2);
        this.buffer.putShort((short)byteBuffer.remaining());
        this.buffer.put(byteBuffer);
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public int length() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identity() {
        Charset charset = Charset.forName("UTF-8");
        return charset.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.length())).toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  identity = ");
        printWriter.print(this.identity());
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ClientPSKParameters;");
        return stringWriter.toString();
    }
}

