/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.nio.ByteBuffer;

public class ClientKeyExchangeBuilder
extends ClientKeyExchange
implements Builder {
    public ClientKeyExchangeBuilder(CipherSuite cipherSuite, ProtocolVersion protocolVersion) {
        super(ByteBuffer.allocate(512), cipherSuite, protocolVersion);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setExchangeKeys(ByteBuffer byteBuffer) {
        if (this.buffer.capacity() < byteBuffer.remaining() || this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.RSA && this.version == ProtocolVersion.SSL_3) {
            this.buffer = ByteBuffer.allocate(byteBuffer.remaining());
        }
        ((ByteBuffer)this.buffer.duplicate().position(0)).put(byteBuffer);
    }
}

