/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.EmptyExchangeKeys;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ClientKeyExchange
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CipherSuite suite;
    protected final ProtocolVersion version;

    public ClientKeyExchange(ByteBuffer byteBuffer, CipherSuite cipherSuite, ProtocolVersion protocolVersion) {
        cipherSuite.getClass();
        protocolVersion.getClass();
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.suite = cipherSuite;
        this.version = protocolVersion;
    }

    public ExchangeKeys exchangeKeys() {
        KeyExchangeAlgorithm keyExchangeAlgorithm = this.suite.keyExchangeAlgorithm();
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA) {
            return new EncryptedPreMasterSecret(this.buffer, this.version);
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA) {
            return new ClientDiffieHellmanPublic(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
            return new ClientDHE_PSKParameters(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK) {
            return new ClientPSKParameters(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
            return new ClientRSA_PSKParameters(this.buffer.duplicate());
        }
        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.NONE) {
            return new EmptyExchangeKeys();
        }
        throw new IllegalArgumentException("unsupported key exchange: " + (Object)((Object)keyExchangeAlgorithm));
    }

    public int length() {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            return 0;
        }
        return this.exchangeKeys().length();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        printWriter.println(this.exchangeKeys().toString(string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("} ClientKeyExchange;");
        return stringWriter.toString();
    }
}

