/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientHello;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHelloBuilder
extends ClientHello
implements Builder {
    public ClientHelloBuilder() {
        super(ByteBuffer.allocate(256));
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().position(0).limit(this.length());
    }

    public void setVersion(ProtocolVersion protocolVersion) {
        this.ensureCapacity(2);
        this.buffer.putShort(0, (short)protocolVersion.rawValue());
    }

    public void setSessionId(byte[] byArray) {
        this.setSessionId(byArray, 0, byArray.length);
    }

    public void setSessionId(byte[] byArray, int n, int n2) {
        this.ensureCapacity(35 + n2);
        int n3 = Math.min(32, n2);
        this.buffer.put(34, (byte)n3);
        this.buffer.position(35);
        this.buffer.put(byArray, n, n3);
    }

    public void setCipherSuites(List<CipherSuite> list2) {
        int n = this.getCipherSuitesOffset();
        this.ensureCapacity(n + 2 * list2.size() + 2);
        this.buffer.putShort(n, (short)(list2.size() * 2));
        int n2 = 2;
        for (CipherSuite cipherSuite : list2) {
            ((ByteBuffer)this.buffer.duplicate().position(n + n2)).put(cipherSuite.id());
            n2 += 2;
        }
    }

    public void setCompressionMethods(List<CompressionMethod> list2) {
        int n = this.getCompressionMethodsOffset();
        this.ensureCapacity(n + list2.size() + 1);
        this.buffer.put(n, (byte)list2.size());
        for (CompressionMethod compressionMethod : list2) {
            this.buffer.put(++n, (byte)compressionMethod.getValue());
        }
    }

    public void setExtensionsLength(int n) {
        if (n < 0 || n > 16384) {
            throw new IllegalArgumentException("length must be nonnegative and not exceed 16384");
        }
        int n2 = this.getExtensionsOffset() + 2 + n;
        if (this.buffer.capacity() < n2) {
            this.ensureCapacity(n2);
        }
        this.buffer.putShort(this.getExtensionsOffset(), (short)n);
    }

    public void setExtensions(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort(0) & 0xFFFF;
        this.setExtensionsLength(n);
        ((ByteBuffer)this.buffer.duplicate().position(this.getExtensionsOffset())).put(byteBuffer);
    }

    public void setDisableExtensions(boolean bl) {
        this.disableExtensions = bl;
    }

    public void ensureCapacity(int n) {
        if (this.buffer.capacity() >= n) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put((ByteBuffer)this.buffer.position(0));
        byteBuffer.position(0);
        this.buffer = byteBuffer;
    }
}

