/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuiteList;
import gnu.javax.net.ssl.provider.CompressionMethodList;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ClientHello
implements Handshake.Body {
    protected static final int RANDOM_OFFSET = 2;
    protected static final int SESSID_OFFSET = 34;
    protected static final int SESSID_OFFSET2 = 35;
    protected ByteBuffer buffer;
    protected boolean disableExtensions;

    public ClientHello(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.disableExtensions = false;
    }

    public int length() {
        int n = 35 + this.buffer.get(34);
        n += (this.buffer.getShort(n) & 0xFFFF) + 2;
        n += (this.buffer.get(n) & 0xFF) + 1;
        if (!this.disableExtensions && n + 1 < this.buffer.capacity()) {
            n += (this.buffer.getShort(n) & 0xFFFF) + 2;
        }
        return n;
    }

    public ProtocolVersion version() {
        return ProtocolVersion.getInstance(this.buffer.getShort(0));
    }

    public Random random() {
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(2).limit(34)).slice();
        return new Random(byteBuffer);
    }

    public byte[] sessionId() {
        int n = this.buffer.get(34) & 0xFF;
        byte[] byArray = new byte[n];
        this.buffer.position(35);
        this.buffer.get(byArray);
        return byArray;
    }

    public CipherSuiteList cipherSuites() {
        int n = this.getCipherSuitesOffset();
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(n).limit(this.buffer.capacity())).slice();
        return new CipherSuiteList(byteBuffer, this.version());
    }

    public CompressionMethodList compressionMethods() {
        int n = this.getCompressionMethodsOffset();
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(n).limit(this.buffer.capacity())).slice();
        return new CompressionMethodList(byteBuffer);
    }

    public boolean hasExtensions() {
        int n = this.getExtensionsOffset();
        return n + 1 < this.buffer.limit();
    }

    public ExtensionList extensions() {
        int n = this.getExtensionsOffset();
        if (n + 1 >= this.buffer.limit()) {
            return null;
        }
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        if (n2 == 0) {
            n2 = this.buffer.limit() - n - 2;
        }
        ByteBuffer byteBuffer = ((ByteBuffer)this.buffer.duplicate().position(n).limit(n + n2 + 2)).slice();
        return new ExtensionList(byteBuffer);
    }

    public int extensionsLength() {
        if (this.hasExtensions()) {
            return 0;
        }
        return this.buffer.getShort(this.getExtensionsOffset()) & 0xFFFF;
    }

    protected int getCipherSuitesOffset() {
        return 35 + (this.buffer.get(34) & 0xFF);
    }

    protected int getCompressionMethodsOffset() {
        int n = this.getCipherSuitesOffset();
        int n2 = this.buffer.getShort(n) & 0xFFFF;
        return n + n2 + 2;
    }

    protected int getExtensionsOffset() {
        int n = this.getCompressionMethodsOffset();
        return (this.buffer.get(n) & 0xFF) + n + 1;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = "  ";
        if (string != null) {
            string2 = string2 + string;
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  version: ");
        printWriter.print(this.version());
        printWriter.println(";");
        printWriter.print(string2);
        printWriter.println("random:");
        printWriter.print(this.random().toString(string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  sessionId: ");
        printWriter.print(Util.toHexString(this.sessionId(), ':'));
        printWriter.println(";");
        printWriter.print(string2);
        printWriter.println("cipher_suites:");
        printWriter.println(this.cipherSuites().toString(string2));
        printWriter.print(string2);
        printWriter.println("compression_methods:");
        printWriter.println(this.compressionMethods().toString(string2));
        printWriter.print(string2);
        printWriter.print("extensions: ");
        ExtensionList extensionList = this.extensions();
        printWriter.println(extensionList != null ? extensionList.toString(string2 + "  ") : "(nil)");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} ClientHello;");
        return stringWriter.toString();
    }
}

