/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.net.ssl.AbstractSessionContext;
import gnu.javax.net.ssl.Session;
import gnu.javax.net.ssl.provider.AbstractHandshake;
import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.Certificate;
import gnu.javax.net.ssl.provider.CertificateBuilder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.CertificateVerify;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientCertificateTypeList;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientHelloBuilder;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.ClientKeyExchangeBuilder;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.DelegatedTask;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.ExtensionList;
import gnu.javax.net.ssl.provider.Finished;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.InputSecurityParameters;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.MaxFragmentLength;
import gnu.javax.net.ssl.provider.OutputSecurityParameters;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.ServerDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ServerDHParams;
import gnu.javax.net.ssl.provider.ServerHello;
import gnu.javax.net.ssl.provider.ServerKeyExchange;
import gnu.javax.net.ssl.provider.ServerNameList;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.SignatureAlgorithm;
import gnu.javax.net.ssl.provider.TruncatedHMAC;
import gnu.javax.net.ssl.provider.Util;
import gnu.javax.net.ssl.provider.X500PrincipalList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHandshake
extends AbstractHandshake {
    private State state = State.WRITE_CLIENT_HELLO;
    private ByteBuffer outBuffer;
    private boolean continuedSession = false;
    private SessionImpl continued;
    private KeyPair dhPair;
    private String keyAlias;
    private PrivateKey privateKey;
    private MaxFragmentLength maxFragmentLengthSent;
    private boolean truncatedHMacSent;
    private ProtocolVersion sentVersion;
    private AbstractHandshake.CertVerifier certVerifier;
    private ParamsVerifier paramsVerifier;
    private DelegatedTask keyExchange;
    private CertLoader certLoader;
    private GenCertVerify genCertVerify;

    public ClientHandshake(SSLEngineImpl sSLEngineImpl) throws NoSuchAlgorithmException {
        super(sSLEngineImpl);
    }

    @Override
    protected SSLEngineResult.HandshakeStatus implHandleInput() throws SSLException {
        if (this.state == State.DONE) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        ByteBuffer byteBuffer = this.handshakeBuffer.duplicate();
        byteBuffer.flip();
        byteBuffer.position(this.handshakeOffset);
        Handshake handshake = new Handshake(byteBuffer.slice(), this.engine.session().suite, this.engine.session().version);
        logger.logv(Component.SSL_HANDSHAKE, "processing in state {0}:\n{1}", new Object[]{this.state, handshake});
        switch (this.state) {
            case READ_SERVER_HELLO: {
                if (handshake.type() != Handshake.Type.SERVER_HELLO) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                ServerHello serverHello = (ServerHello)handshake.body();
                this.serverRandom = serverHello.random().copy();
                this.engine.session().suite = serverHello.cipherSuite();
                this.engine.session().version = serverHello.version();
                this.compression = serverHello.compressionMethod();
                Session.ID iD = new Session.ID(serverHello.sessionId());
                if (this.continued != null && this.continued.id().equals(iD)) {
                    this.continuedSession = true;
                    this.engine.setSession(this.continued);
                } else if (this.engine.getEnableSessionCreation()) {
                    ((AbstractSessionContext)this.engine.contextImpl.engineGetClientSessionContext()).put(this.engine.session());
                }
                ExtensionList extensionList = serverHello.extensions();
                if (extensionList != null) {
                    for (Object object : extensionList) {
                        Extension.Type type = ((Extension)object).type();
                        if (type == null) continue;
                        switch (type) {
                            case MAX_FRAGMENT_LENGTH: {
                                MaxFragmentLength maxFragmentLength = (MaxFragmentLength)((Extension)object).value();
                                if (this.maxFragmentLengthSent != maxFragmentLength) break;
                                this.engine.session().setApplicationBufferSize(maxFragmentLength.maxLength());
                                break;
                            }
                            case TRUNCATED_HMAC: {
                                if (!this.truncatedHMacSent) break;
                                this.engine.session().setTruncatedMac(true);
                            }
                        }
                    }
                }
                KeyExchangeAlgorithm keyExchangeAlgorithm = this.engine.session().suite.keyExchangeAlgorithm();
                if (this.continuedSession) {
                    Object object;
                    object = this.generateKeys(this.clientRandom, this.serverRandom, this.engine.session());
                    this.setupSecurityParameters((byte[][])object, true, this.engine, this.compression);
                    this.state = State.READ_FINISHED;
                    break;
                }
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
                    this.state = State.READ_CERTIFICATE;
                    break;
                }
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon || keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                    break;
                }
                this.state = State.READ_CERTIFICATE_REQUEST;
                break;
            }
            case READ_CERTIFICATE: {
                if (handshake.type() != Handshake.Type.CERTIFICATE) {
                    if (this.engine.session().suite.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                    }
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                }
                Certificate certificate = (Certificate)handshake.body();
                java.security.cert.Certificate[] certificateArray = null;
                try {
                    certificateArray = certificate.certificates().toArray(new X509Certificate[0]);
                }
                catch (CertificateException certificateException) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.BAD_CERTIFICATE), (Throwable)certificateException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNSUPPORTED_CERTIFICATE), (Throwable)noSuchAlgorithmException);
                }
                this.engine.session().setPeerCertificates(certificateArray);
                this.certVerifier = new AbstractHandshake.CertVerifier(this, true, (X509Certificate[])certificateArray);
                this.tasks.add(this.certVerifier);
                KeyExchangeAlgorithm keyExchangeAlgorithm = this.engine.session().suite.keyExchangeAlgorithm();
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
                    this.keyExchange = new RSAGen(keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA);
                    this.tasks.add(this.keyExchange);
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA) {
                        this.state = State.READ_CERTIFICATE_REQUEST;
                        break;
                    }
                    this.state = State.READ_SERVER_KEY_EXCHANGE;
                    break;
                }
                this.state = State.READ_SERVER_KEY_EXCHANGE;
                break;
            }
            case READ_SERVER_KEY_EXCHANGE: {
                Object object;
                Object object2;
                Object object3;
                CipherSuite cipherSuite = this.engine.session().suite;
                KeyExchangeAlgorithm keyExchangeAlgorithm = cipherSuite.keyExchangeAlgorithm();
                if (keyExchangeAlgorithm != KeyExchangeAlgorithm.DHE_DSS && keyExchangeAlgorithm != KeyExchangeAlgorithm.DHE_RSA && keyExchangeAlgorithm != KeyExchangeAlgorithm.DH_anon && keyExchangeAlgorithm != KeyExchangeAlgorithm.DHE_PSK && keyExchangeAlgorithm != KeyExchangeAlgorithm.PSK && keyExchangeAlgorithm != KeyExchangeAlgorithm.RSA_PSK) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                if (handshake.type() != Handshake.Type.SERVER_KEY_EXCHANGE) {
                    if (keyExchangeAlgorithm != KeyExchangeAlgorithm.RSA_PSK && keyExchangeAlgorithm != KeyExchangeAlgorithm.PSK) {
                        throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                    }
                    this.state = State.READ_CERTIFICATE_REQUEST;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                ServerKeyExchange serverKeyExchange = (ServerKeyExchange)handshake.body();
                ByteBuffer byteBuffer2 = null;
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon) {
                    object3 = (ServerDHParams)serverKeyExchange.params();
                    object2 = ((ServerDHParams)object3).buffer();
                    byteBuffer2 = ByteBuffer.allocate(((Buffer)object2).remaining());
                    byteBuffer2.put((ByteBuffer)object2);
                }
                if (cipherSuite.signatureAlgorithm() != SignatureAlgorithm.ANONYMOUS) {
                    object3 = serverKeyExchange.signature().signature();
                    this.paramsVerifier = new ParamsVerifier(byteBuffer2, (byte[])object3);
                    this.tasks.add(this.paramsVerifier);
                }
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon) {
                    object3 = (ServerDHParams)serverKeyExchange.params();
                    object2 = new GnuDHPublicKey(null, ((ServerDHParams)object3).p(), ((ServerDHParams)object3).g(), ((ServerDHParams)object3).y());
                    object = new DHParameterSpec(((ServerDHParams)object3).p(), ((ServerDHParams)object3).g());
                    this.keyExchange = new ClientDHGen((DHPublicKey)object2, (DHParameterSpec)object, true);
                    this.tasks.add(this.keyExchange);
                }
                if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
                    object3 = (ServerDHE_PSKParameters)serverKeyExchange.params();
                    object2 = ((ServerDHE_PSKParameters)object3).params();
                    object = new GnuDHPublicKey(null, ((ServerDHParams)object2).p(), ((ServerDHParams)object2).g(), ((ServerDHParams)object2).y());
                    DHParameterSpec dHParameterSpec = new DHParameterSpec(((ServerDHParams)object2).p(), ((ServerDHParams)object2).g());
                    this.keyExchange = new ClientDHGen((DHPublicKey)object, dHParameterSpec, false);
                    this.tasks.add(this.keyExchange);
                }
                this.state = State.READ_CERTIFICATE_REQUEST;
                break;
            }
            case READ_CERTIFICATE_REQUEST: {
                Object object4;
                if (handshake.type() != Handshake.Type.CERTIFICATE_REQUEST) {
                    this.state = State.READ_SERVER_HELLO_DONE;
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                CertificateRequest certificateRequest = (CertificateRequest)handshake.body();
                ClientCertificateTypeList clientCertificateTypeList = certificateRequest.types();
                LinkedList<String> linkedList = new LinkedList<String>();
                for (Object object4 : clientCertificateTypeList) {
                    linkedList.add(((Enum)object4).name());
                }
                X500PrincipalList x500PrincipalList = certificateRequest.authorities();
                object4 = new LinkedList();
                Iterator<X500Principal> iterator = x500PrincipalList.iterator();
                while (iterator.hasNext()) {
                    X500Principal x500Principal = iterator.next();
                    ((LinkedList)object4).add(x500Principal);
                }
                this.certLoader = new CertLoader(linkedList, (List<X500Principal>)object4);
                this.tasks.add(this.certLoader);
                break;
            }
            case READ_SERVER_HELLO_DONE: {
                if (handshake.type() != Handshake.Type.SERVER_HELLO_DONE) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                this.state = State.WRITE_CERTIFICATE;
                break;
            }
            case READ_FINISHED: {
                if (handshake.type() != Handshake.Type.FINISHED) {
                    throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.UNEXPECTED_MESSAGE));
                }
                Finished finished = (Finished)handshake.body();
                MessageDigest messageDigest = null;
                MessageDigest messageDigest2 = null;
                try {
                    messageDigest = (MessageDigest)this.md5.clone();
                    messageDigest2 = (MessageDigest)this.sha.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new SSLException(cloneNotSupportedException);
                }
                Finished finished2 = new Finished(this.generateFinished(messageDigest, messageDigest2, false, this.engine.session()), this.engine.session().version);
                logger.logv(Component.SSL_HANDSHAKE, "clientFinished: {0}", finished2);
                if (this.engine.session().version == ProtocolVersion.SSL_3) {
                    if (!Arrays.equals(finished2.md5Hash(), finished.md5Hash()) || !Arrays.equals(finished2.shaHash(), finished.shaHash())) {
                        this.engine.session().invalidate();
                        throw new SSLException("session verify failed");
                    }
                } else if (!Arrays.equals(finished2.verifyData(), finished.verifyData())) {
                    this.engine.session().invalidate();
                    throw new SSLException("session verify failed");
                }
                if (this.continuedSession) {
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break;
                }
                this.state = State.DONE;
                break;
            }
            default: {
                throw new IllegalStateException("invalid state: " + (Object)((Object)this.state));
            }
        }
        this.handshakeOffset += handshake.length() + 4;
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    @Override
    protected SSLEngineResult.HandshakeStatus implHandleOutput(ByteBuffer byteBuffer) throws SSLException {
        logger.logv(Component.SSL_HANDSHAKE, "output to {0}; state:{1}; outBuffer:{2}", new Object[]{byteBuffer, this.state, this.outBuffer});
        if (this.outBuffer != null && this.outBuffer.hasRemaining()) {
            int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
            byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
            this.outBuffer.position(this.outBuffer.position() + n);
        }
        if (!byteBuffer.hasRemaining()) {
            if (this.state.isWriteState() || this.outBuffer.hasRemaining()) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        block11: while (byteBuffer.remaining() >= 4 && this.state.isWriteState()) {
            logger.logv(Component.SSL_HANDSHAKE, "loop state={0}", new Object[]{this.state});
            switch (this.state) {
                case WRITE_CLIENT_HELLO: {
                    ClientHelloBuilder clientHelloBuilder = new ClientHelloBuilder();
                    Object object = (AbstractSessionContext)this.engine.contextImpl.engineGetClientSessionContext();
                    this.continued = (SessionImpl)((AbstractSessionContext)object).getSession(this.engine.getPeerHost(), this.engine.getPeerPort());
                    this.engine.session().setId(new Session.ID(new byte[0]));
                    Session.ID iD = this.engine.session().id();
                    if (this.continued != null) {
                        iD = this.continued.id();
                    }
                    clientHelloBuilder.setSessionId(iD.id());
                    this.sentVersion = this.chooseVersion();
                    clientHelloBuilder.setVersion(this.sentVersion);
                    clientHelloBuilder.setCipherSuites(this.getSuites());
                    clientHelloBuilder.setCompressionMethods(this.getCompressionMethods());
                    Object object2 = clientHelloBuilder.random();
                    ((Random)object2).setGmtUnixTime(Util.unixTime());
                    Object object3 = new byte[28];
                    this.engine.session().random().nextBytes((byte[])object3);
                    ((Random)object2).setRandomBytes((byte[])object3);
                    this.clientRandom = ((Random)object2).copy();
                    if (this.enableExtensions()) {
                        Constructed constructed;
                        String string;
                        LinkedList<Extension> linkedList = new LinkedList<Extension>();
                        MaxFragmentLength maxFragmentLength = this.maxFragmentLength();
                        if (maxFragmentLength != null) {
                            linkedList.add(new Extension(Extension.Type.MAX_FRAGMENT_LENGTH, maxFragmentLength));
                            this.maxFragmentLengthSent = maxFragmentLength;
                        }
                        if ((string = this.engine.getPeerHost()) != null) {
                            constructed = new ServerNameList.ServerName(ServerNameList.NameType.HOST_NAME, string);
                            ServerNameList serverNameList = new ServerNameList(Collections.singletonList(constructed));
                            linkedList.add(new Extension(Extension.Type.SERVER_NAME, serverNameList));
                        }
                        if (this.truncatedHMac()) {
                            linkedList.add(new Extension(Extension.Type.TRUNCATED_HMAC, new TruncatedHMAC()));
                            this.truncatedHMacSent = true;
                        }
                        constructed = new ExtensionList(linkedList);
                        clientHelloBuilder.setExtensions(((ExtensionList)constructed).buffer());
                    } else {
                        clientHelloBuilder.setDisableExtensions(true);
                    }
                    logger.logv(Component.SSL_HANDSHAKE, "{0}", clientHelloBuilder);
                    byteBuffer.putInt(Handshake.Type.CLIENT_HELLO.getValue() << 24 | clientHelloBuilder.length() & 0xFFFFFF);
                    this.outBuffer = clientHelloBuilder.buffer();
                    int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    this.state = State.READ_SERVER_HELLO;
                    continue block11;
                }
                case WRITE_CERTIFICATE: {
                    Object object;
                    java.security.cert.Certificate[] certificateArray = this.engine.session().getLocalCertificates();
                    if (certificateArray != null) {
                        object = new CertificateBuilder(CertificateType.X509);
                        try {
                            ((CertificateBuilder)object).setCertificates(Arrays.asList(certificateArray));
                        }
                        catch (CertificateException certificateException) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.INTERNAL_ERROR), (Throwable)certificateException);
                        }
                        this.outBuffer = ((CertificateBuilder)object).buffer();
                        byteBuffer.putInt(Handshake.Type.CERTIFICATE.getValue() << 24 | ((Certificate)object).length() & 0xFFFFFF);
                        int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                        byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                        this.outBuffer.position(this.outBuffer.position() + n);
                    }
                    this.state = State.WRITE_CLIENT_KEY_EXCHANGE;
                    continue block11;
                }
                case WRITE_CLIENT_KEY_EXCHANGE: {
                    Object object3;
                    Object object2;
                    KeyExchangeAlgorithm keyExchangeAlgorithm = this.engine.session().suite.keyExchangeAlgorithm();
                    Object object = new ClientKeyExchangeBuilder(this.engine.session().suite, this.engine.session().version);
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_anon || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_DSS || keyExchangeAlgorithm == KeyExchangeAlgorithm.DH_RSA) {
                        assert (this.dhPair != null);
                        DHPublicKey dHPublicKey = (DHPublicKey)this.dhPair.getPublic();
                        object2 = new ClientDiffieHellmanPublic(dHPublicKey.getY());
                        ((ClientKeyExchangeBuilder)object).setExchangeKeys(((ClientDiffieHellmanPublic)object2).buffer());
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA || keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA_PSK) {
                        assert (this.keyExchange instanceof RSAGen);
                        assert (this.keyExchange.hasRun());
                        if (this.keyExchange.thrown() != null) {
                            throw new AlertException(new Alert(Alert.Level.FATAL, Alert.Description.HANDSHAKE_FAILURE), this.keyExchange.thrown());
                        }
                        EncryptedPreMasterSecret encryptedPreMasterSecret = new EncryptedPreMasterSecret(((RSAGen)this.keyExchange).encryptedSecret(), this.engine.session().version);
                        if (keyExchangeAlgorithm == KeyExchangeAlgorithm.RSA) {
                            ((ClientKeyExchangeBuilder)object).setExchangeKeys(encryptedPreMasterSecret.buffer());
                        } else {
                            object2 = this.getPSKIdentity();
                            if (object2 == null) {
                                throw new SSLException("no pre-shared-key identity; set the security property \"jessie.client.psk.identity\"");
                            }
                            object3 = new ClientRSA_PSKParameters((String)object2, encryptedPreMasterSecret.buffer());
                            ((ClientKeyExchangeBuilder)object).setExchangeKeys(((ClientRSA_PSKParameters)object3).buffer());
                            this.generatePSKSecret((String)object2, this.preMasterSecret, true);
                        }
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.DHE_PSK) {
                        assert (this.keyExchange instanceof ClientDHGen);
                        assert (this.dhPair != null);
                        String string = this.getPSKIdentity();
                        if (string == null) {
                            throw new SSLException("no pre-shared key identity; set the security property \"jessie.client.psk.identity\"");
                        }
                        object2 = (DHPublicKey)this.dhPair.getPublic();
                        object3 = new ClientDHE_PSKParameters(string, new ClientDiffieHellmanPublic(object2.getY()));
                        ((ClientKeyExchangeBuilder)object).setExchangeKeys(((ClientDHE_PSKParameters)object3).buffer());
                        this.generatePSKSecret(string, this.preMasterSecret, true);
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.PSK) {
                        String string = this.getPSKIdentity();
                        if (string == null) {
                            throw new SSLException("no pre-shared key identity; set the security property \"jessie.client.psk.identity\"");
                        }
                        this.generatePSKSecret(string, null, true);
                        object2 = new ClientPSKParameters(string);
                        ((ClientKeyExchangeBuilder)object).setExchangeKeys(((ClientPSKParameters)object2).buffer());
                    }
                    if (keyExchangeAlgorithm == KeyExchangeAlgorithm.NONE) {
                        Inflater inflater = null;
                        object2 = null;
                        if (this.compression == CompressionMethod.ZLIB) {
                            inflater = new Inflater();
                            object2 = new Deflater();
                        }
                        this.inParams = new InputSecurityParameters(null, null, inflater, this.engine.session(), this.engine.session().suite);
                        this.outParams = new OutputSecurityParameters(null, null, (Deflater)object2, this.engine.session(), this.engine.session().suite);
                        this.engine.session().privateData.masterSecret = new byte[0];
                    }
                    logger.logv(Component.SSL_HANDSHAKE, "{0}", object);
                    this.outBuffer = ((ClientKeyExchangeBuilder)object).buffer();
                    logger.logv(Component.SSL_HANDSHAKE, "client kex buffer {0}", this.outBuffer);
                    byteBuffer.putInt(Handshake.Type.CLIENT_KEY_EXCHANGE.getValue() << 24 | ((ClientKeyExchange)object).length() & 0xFFFFFF);
                    int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    if (this.privateKey != null) {
                        this.genCertVerify = new GenCertVerify(this.md5, this.sha);
                        this.tasks.add(this.genCertVerify);
                        this.state = State.WRITE_CERTIFICATE_VERIFY;
                        break block11;
                    }
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break block11;
                }
                case WRITE_CERTIFICATE_VERIFY: {
                    assert (this.genCertVerify != null);
                    assert (this.genCertVerify.hasRun());
                    CertificateVerify certificateVerify = new CertificateVerify(this.genCertVerify.signed(), this.engine.session().suite.signatureAlgorithm());
                    this.outBuffer = certificateVerify.buffer();
                    byteBuffer.putInt(Handshake.Type.CERTIFICATE_VERIFY.getValue() << 24 | certificateVerify.length() & 0xFFFFFF);
                    int n = Math.min(byteBuffer.remaining(), this.outBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    this.engine.changeCipherSpec();
                    this.state = State.WRITE_FINISHED;
                    break block11;
                }
                case WRITE_FINISHED: {
                    MessageDigest messageDigest = null;
                    Object object = null;
                    try {
                        messageDigest = (MessageDigest)this.md5.clone();
                        object = (MessageDigest)this.sha.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new SSLException(cloneNotSupportedException);
                    }
                    this.outBuffer = this.generateFinished(messageDigest, (MessageDigest)object, true, this.engine.session());
                    byteBuffer.putInt(Handshake.Type.FINISHED.getValue() << 24 | this.outBuffer.remaining() & 0xFFFFFF);
                    int n = Math.min(this.outBuffer.remaining(), byteBuffer.remaining());
                    byteBuffer.put((ByteBuffer)this.outBuffer.duplicate().limit(this.outBuffer.position() + n));
                    this.outBuffer.position(this.outBuffer.position() + n);
                    if (this.continuedSession) {
                        this.state = State.DONE;
                        continue block11;
                    }
                    this.state = State.READ_FINISHED;
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("invalid state: " + (Object)((Object)this.state));
                }
            }
        }
        if (!this.tasks.isEmpty()) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.state.isWriteState() || this.outBuffer != null && this.outBuffer.hasRemaining()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    @Override
    SSLEngineResult.HandshakeStatus status() {
        if (this.state.isReadState()) {
            return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        }
        if (this.state.isWriteState()) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    @Override
    void checkKeyExchange() throws SSLException {
    }

    @Override
    void handleV2Hello(ByteBuffer byteBuffer) throws SSLException {
        throw new SSLException("this should be impossible");
    }

    private ProtocolVersion chooseVersion() throws SSLException {
        ProtocolVersion protocolVersion = null;
        for (String string : this.engine.getEnabledProtocols()) {
            try {
                ProtocolVersion protocolVersion2 = ProtocolVersion.forName(string);
                if (protocolVersion != null && protocolVersion.compareTo(protocolVersion2) >= 0) continue;
                protocolVersion = protocolVersion2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (protocolVersion == null) {
            throw new SSLException("no suitable enabled versions");
        }
        return protocolVersion;
    }

    private List<CipherSuite> getSuites() throws SSLException {
        LinkedList<CipherSuite> linkedList = new LinkedList<CipherSuite>();
        for (String string : this.engine.getEnabledCipherSuites()) {
            CipherSuite cipherSuite = CipherSuite.forName(string);
            if (cipherSuite == null) continue;
            linkedList.add(cipherSuite);
        }
        if (linkedList.isEmpty()) {
            throw new SSLException("no cipher suites enabled");
        }
        return linkedList;
    }

    private List<CompressionMethod> getCompressionMethods() {
        LinkedList<CompressionMethod> linkedList = new LinkedList<CompressionMethod>();
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.enable.compression");
        if (Boolean.valueOf(AccessController.doPrivileged(getSecurityPropertyAction)).booleanValue()) {
            linkedList.add(CompressionMethod.ZLIB);
        }
        linkedList.add(CompressionMethod.NULL);
        return linkedList;
    }

    private boolean enableExtensions() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.client.enable.extensions");
        return Boolean.valueOf(AccessController.doPrivileged(getSecurityPropertyAction));
    }

    private MaxFragmentLength maxFragmentLength() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.client.maxFragmentLength");
        String string = AccessController.doPrivileged(getSecurityPropertyAction);
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                switch (n) {
                    case 9: 
                    case 512: {
                        return MaxFragmentLength.LEN_2_9;
                    }
                    case 10: 
                    case 1024: {
                        return MaxFragmentLength.LEN_2_10;
                    }
                    case 11: 
                    case 2048: {
                        return MaxFragmentLength.LEN_2_11;
                    }
                    case 12: 
                    case 4096: {
                        return MaxFragmentLength.LEN_2_12;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean truncatedHMac() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.client.truncatedHMac");
        return Boolean.valueOf(AccessController.doPrivileged(getSecurityPropertyAction));
    }

    private String getPSKIdentity() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("jessie.client.psk.identity");
        return AccessController.doPrivileged(getSecurityPropertyAction);
    }

    class GenCertVerify
    extends DelegatedTask {
        private final MessageDigest md5;
        private final MessageDigest sha;
        private byte[] signed;

        GenCertVerify(MessageDigest messageDigest, MessageDigest messageDigest2) {
            try {
                this.md5 = (MessageDigest)messageDigest.clone();
                this.sha = (MessageDigest)messageDigest2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error(cloneNotSupportedException);
            }
        }

        public void implRun() throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            byte[] byArray = ClientHandshake.this.engine.session().version == ProtocolVersion.SSL_3 ? ClientHandshake.this.genV3CertificateVerify(this.md5, this.sha, ClientHandshake.this.engine.session()) : (ClientHandshake.this.engine.session().suite.signatureAlgorithm() == SignatureAlgorithm.RSA ? Util.concat(this.md5.digest(), this.sha.digest()) : this.sha.digest());
            Signature signature = Signature.getInstance(ClientHandshake.this.engine.session().suite.signatureAlgorithm().name());
            signature.initSign(ClientHandshake.this.privateKey);
            signature.update(byArray);
            this.signed = signature.sign();
        }

        byte[] signed() {
            return this.signed;
        }
    }

    class RSAGen
    extends DelegatedTask {
        private byte[] encryptedPreMasterSecret;
        private final boolean full;

        RSAGen() {
            this(true);
        }

        RSAGen(boolean bl) {
            this.full = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, SSLException {
            Object object;
            Object object2;
            if (ClientHandshake.this.certVerifier != null) {
                object2 = ClientHandshake.this.certVerifier;
                synchronized (object2) {
                    try {
                        while (!ClientHandshake.this.certVerifier.hasRun()) {
                            ClientHandshake.this.certVerifier.wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ClientHandshake.this.preMasterSecret = new byte[48];
            ClientHandshake.this.engine.session().random().nextBytes(ClientHandshake.this.preMasterSecret);
            ClientHandshake.this.preMasterSecret[0] = (byte)ClientHandshake.this.sentVersion.major();
            ClientHandshake.this.preMasterSecret[1] = (byte)ClientHandshake.this.sentVersion.minor();
            object2 = Cipher.getInstance("RSA");
            java.security.cert.Certificate certificate = ClientHandshake.this.engine.session().getPeerCertificates()[0];
            if (certificate instanceof X509Certificate && (object = ((X509Certificate)certificate).getKeyUsage()) != null && !object[2]) {
                throw new InvalidKeyException("certificate's keyUsage does not permit keyEncipherment");
            }
            ((Cipher)object2).init(1, certificate.getPublicKey());
            this.encryptedPreMasterSecret = ((Cipher)object2).doFinal(ClientHandshake.this.preMasterSecret);
            if (this.full) {
                ClientHandshake.this.generateMasterSecret(ClientHandshake.this.clientRandom, ClientHandshake.this.serverRandom, ClientHandshake.this.engine.session());
                object = ClientHandshake.this.generateKeys(ClientHandshake.this.clientRandom, ClientHandshake.this.serverRandom, ClientHandshake.this.engine.session());
                ClientHandshake.this.setupSecurityParameters((byte[][])object, true, ClientHandshake.this.engine, ClientHandshake.this.compression);
            }
        }

        byte[] encryptedSecret() {
            return this.encryptedPreMasterSecret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CertLoader
    extends DelegatedTask {
        private final List<String> keyTypes;
        private final List<X500Principal> issuers;

        CertLoader(List<String> list2, List<X500Principal> list3) {
            this.keyTypes = list2;
            this.issuers = list3;
        }

        @Override
        public void implRun() {
            X509ExtendedKeyManager x509ExtendedKeyManager = ClientHandshake.this.engine.contextImpl.keyManager;
            if (x509ExtendedKeyManager == null) {
                return;
            }
            ClientHandshake.this.keyAlias = x509ExtendedKeyManager.chooseEngineClientAlias(this.keyTypes.toArray(new String[this.keyTypes.size()]), this.issuers.toArray(new X500Principal[this.issuers.size()]), ClientHandshake.this.engine);
            ClientHandshake.this.engine.session().setLocalCertificates(x509ExtendedKeyManager.getCertificateChain(ClientHandshake.this.keyAlias));
            ClientHandshake.this.privateKey = x509ExtendedKeyManager.getPrivateKey(ClientHandshake.this.keyAlias);
        }
    }

    class ClientDHGen
    extends DelegatedTask {
        private final DHPublicKey serverKey;
        private final DHParameterSpec params;
        private final boolean full;

        ClientDHGen(DHPublicKey dHPublicKey, DHParameterSpec dHParameterSpec, boolean bl) {
            this.serverKey = dHPublicKey;
            this.params = dHParameterSpec;
            this.full = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, SSLException {
            Object object;
            AbstractHandshake.logger.log(Component.SSL_DELEGATED_TASK, "running client DH phase");
            if (ClientHandshake.this.paramsVerifier != null) {
                object = ClientHandshake.this.paramsVerifier;
                synchronized (object) {
                    try {
                        while (!ClientHandshake.this.paramsVerifier.hasRun()) {
                            ClientHandshake.this.paramsVerifier.wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = KeyPairGenerator.getInstance("DH");
            ((KeyPairGenerator)object).initialize(this.params, ClientHandshake.this.engine.session().random());
            ClientHandshake.this.dhPair = ((KeyPairGenerator)object).generateKeyPair();
            AbstractHandshake.logger.logv(Component.SSL_KEY_EXCHANGE, "client keys public:{0} private:{1}", ClientHandshake.this.dhPair.getPublic(), ClientHandshake.this.dhPair.getPrivate());
            ClientHandshake.this.initDiffieHellman((DHPrivateKey)ClientHandshake.this.dhPair.getPrivate(), ClientHandshake.this.engine.session().random());
            AbstractHandshake.DHPhase dHPhase = new AbstractHandshake.DHPhase(ClientHandshake.this, this.serverKey, this.full);
            dHPhase.run();
            if (dHPhase.thrown() != null) {
                throw new SSLException(dHPhase.thrown());
            }
        }

        DHPublicKey serverKey() {
            return this.serverKey;
        }
    }

    class ParamsVerifier
    extends DelegatedTask {
        private final ByteBuffer paramsBuffer;
        private final byte[] signature;
        private boolean verified;

        ParamsVerifier(ByteBuffer byteBuffer, byte[] byArray) {
            this.paramsBuffer = byteBuffer;
            this.signature = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implRun() throws InvalidKeyException, NoSuchAlgorithmException, SSLPeerUnverifiedException, SignatureException {
            Signature signature = Signature.getInstance(ClientHandshake.this.engine.session().suite.signatureAlgorithm().algorithm());
            signature.initVerify(ClientHandshake.this.engine.session().getPeerCertificates()[0]);
            signature.update(this.paramsBuffer);
            this.verified = signature.verify(this.signature);
            ParamsVerifier paramsVerifier = this;
            synchronized (paramsVerifier) {
                this.notifyAll();
            }
        }

        boolean verified() {
            return this.verified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        WRITE_CLIENT_HELLO(false, true),
        READ_SERVER_HELLO(true, false),
        READ_CERTIFICATE(true, false),
        READ_SERVER_KEY_EXCHANGE(true, false),
        READ_CERTIFICATE_REQUEST(true, false),
        READ_SERVER_HELLO_DONE(true, false),
        WRITE_CERTIFICATE(false, true),
        WRITE_CLIENT_KEY_EXCHANGE(false, true),
        WRITE_CERTIFICATE_VERIFY(false, true),
        WRITE_FINISHED(false, true),
        READ_FINISHED(true, false),
        DONE(false, false);

        private final boolean isWriteState;
        private final boolean isReadState;

        private State(boolean bl, boolean bl2) {
            this.isReadState = bl;
            this.isWriteState = bl2;
        }

        boolean isReadState() {
            return this.isReadState;
        }

        boolean isWriteState() {
            return this.isWriteState;
        }
    }
}

