/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ClientDHE_PSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientDHE_PSKParameters(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public ClientDHE_PSKParameters(String string, ClientDiffieHellmanPublic clientDiffieHellmanPublic) {
        super(null);
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = charset.encode(string);
        this.buffer = ByteBuffer.allocate(2 + byteBuffer.remaining() + clientDiffieHellmanPublic.length());
        this.buffer.putShort((short)byteBuffer.remaining());
        this.buffer.put(byteBuffer);
        this.buffer.put(clientDiffieHellmanPublic.buffer());
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    private int identityLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identity() {
        Charset charset = Charset.forName("UTF-8");
        return charset.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.identityLength())).toString();
    }

    public int length() {
        int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
        n += (this.buffer.getShort(n) & 0xFFFF) + 2;
        return n;
    }

    public ClientDiffieHellmanPublic params() {
        return new ClientDiffieHellmanPublic(((ByteBuffer)this.buffer.duplicate().position(this.identityLength()).limit(this.length())).slice());
    }

    public String toString(String string) {
        return null;
    }
}

