/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CipherSuiteList
implements Iterable<CipherSuite> {
    private final ByteBuffer buffer;
    private final ProtocolVersion version;
    private int modCount;

    public CipherSuiteList(ByteBuffer byteBuffer) {
        this(byteBuffer, ProtocolVersion.SSL_3);
    }

    public CipherSuiteList(ByteBuffer byteBuffer, ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
        this.buffer = byteBuffer;
        this.modCount = 0;
    }

    public int size() {
        return (this.buffer.getShort(0) & 0xFFFF) >>> 1;
    }

    public CipherSuite get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        return CipherSuite.forValue(this.buffer.getShort(2 + (n << 1))).resolve();
    }

    public void put(int n, CipherSuite cipherSuite) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("limit: " + n2 + "; requested: " + n);
        }
        this.buffer.position(2 + (n << 1));
        this.buffer.put(cipherSuite.id());
        ++this.modCount;
    }

    public void setSize(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("size must be between 0 and 32767");
        }
        if ((n << 1) + 2 > this.buffer.capacity()) {
            throw new IllegalArgumentException("limit: " + this.buffer.capacity() + "; requested: " + n);
        }
        this.buffer.putShort(0, (short)(n << 1));
        ++this.modCount;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("[");
        printWriter.print(this.size());
        printWriter.println("] {");
        Iterator iterator = new Iterator();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = iterator.next();
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.print(cipherSuite);
            if (iterator.hasNext()) {
                printWriter.print(",");
            }
            printWriter.println();
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("};");
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CipherSuiteList)) {
            return false;
        }
        CipherSuiteList cipherSuiteList = (CipherSuiteList)object;
        if (this.size() != cipherSuiteList.size()) {
            return false;
        }
        Iterator iterator = new Iterator();
        Iterator iterator2 = cipherSuiteList.new Iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<CipherSuite> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<CipherSuite> {
        private final int modCount;
        private int index;

        Iterator() {
            this.modCount = CipherSuiteList.this.modCount;
            this.index = 0;
        }

        @Override
        public void add(CipherSuite cipherSuite) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < CipherSuiteList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CipherSuite next() throws NoSuchElementException {
            if (this.modCount != CipherSuiteList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CipherSuiteList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public CipherSuite previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != CipherSuiteList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CipherSuiteList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(CipherSuite cipherSuite) {
            CipherSuiteList.this.put(this.index, cipherSuite);
        }
    }
}

