/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateURL
extends Extension.Value
implements Iterable<URLAndOptionalHash> {
    private ByteBuffer buffer;

    public CertificateURL(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public CertificateURL(CertChainType certChainType, List<URLAndOptionalHash> list2) {
        int n = 3;
        for (URLAndOptionalHash uRLAndOptionalHash : list2) {
            n += uRLAndOptionalHash.length();
        }
        this.buffer = ByteBuffer.allocate(n);
        this.buffer.put((byte)certChainType.getValue());
        this.buffer.putShort((short)(n - 1));
        for (URLAndOptionalHash uRLAndOptionalHash : list2) {
            this.buffer.put(uRLAndOptionalHash.buffer());
        }
        this.buffer.rewind();
    }

    @Override
    public int length() {
        return 3 + (this.buffer.getShort(1) & 0xFFFF);
    }

    @Override
    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().limit(this.length());
    }

    public CertChainType type() {
        switch (this.buffer.get(0)) {
            case 0: {
                return CertChainType.INDIVIDUAL_CERTS;
            }
            case 1: {
                return CertChainType.PKIPATH;
            }
        }
        throw new IllegalArgumentException("unknown certificate URL type");
    }

    public int size() {
        int n = this.buffer.getShort(1) & 0xFFFF;
        int n2 = 0;
        int n3 = 3;
        while (n3 < n) {
            URLAndOptionalHash uRLAndOptionalHash = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(n3));
            int n4 = uRLAndOptionalHash.length();
            n3 += n4;
            ++n2;
        }
        return n2;
    }

    public URLAndOptionalHash get(int n) {
        int n2;
        int n3 = this.buffer.getShort(1) & 0xFFFF;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 3; n2 < n3 && n4 < n; n2 += n5, ++n4) {
            URLAndOptionalHash uRLAndOptionalHash = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(n2));
            n5 = uRLAndOptionalHash.length();
        }
        if (n4 < n) {
            throw new IndexOutOfBoundsException();
        }
        return new URLAndOptionalHash(((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n5)).slice());
    }

    public void set(int n, URLAndOptionalHash uRLAndOptionalHash) {
        int n2;
        int n3;
        int n4 = this.buffer.getShort(1) & 0xFFFF;
        int n5 = 0;
        for (n2 = 3; n2 < n4 && n5 < n - 1; n2 += n3, ++n5) {
            URLAndOptionalHash uRLAndOptionalHash2 = new URLAndOptionalHash((ByteBuffer)this.buffer.duplicate().position(n2));
            n3 = uRLAndOptionalHash2.length();
        }
        if (n5 < n - 1) {
            throw new IndexOutOfBoundsException();
        }
        int n6 = uRLAndOptionalHash.urlLength();
        this.buffer.putShort(n2, (short)n6);
        ((ByteBuffer)this.buffer.duplicate().position(n2 + 2)).put(uRLAndOptionalHash.urlBuffer());
        this.buffer.put(n2 + n6 + 2, (byte)(uRLAndOptionalHash.hashPresent() ? 1 : 0));
        if (uRLAndOptionalHash.hashPresent()) {
            ((ByteBuffer)this.buffer.duplicate().position(n2 + n6 + 3)).put(uRLAndOptionalHash.sha1Hash());
        }
    }

    public void setLength(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("length must be between 0 and 65535");
        }
        this.buffer.putShort(1, (short)n);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("  type = ");
        printWriter.print((Object)this.type());
        printWriter.println(";");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  url_and_hash_list = {");
        String string2 = "  ";
        if (string != null) {
            string2 = string + string2;
        }
        for (URLAndOptionalHash uRLAndOptionalHash : this) {
            printWriter.println(uRLAndOptionalHash.toString(string2));
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  };");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} CertificateURL;");
        return stringWriter.toString();
    }

    @Override
    public java.util.Iterator<URLAndOptionalHash> iterator() {
        return new Iterator();
    }

    public static class URLAndOptionalHash
    implements Builder,
    Constructed {
        private ByteBuffer buffer;

        public URLAndOptionalHash(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        }

        public URLAndOptionalHash(String string) {
            this(string, null);
        }

        public URLAndOptionalHash(String string, byte[] byArray) {
            if (byArray != null && byArray.length < 20) {
                throw new IllegalArgumentException();
            }
            int n = 3 + string.length();
            if (byArray != null) {
                n += 20;
            }
            this.buffer = ByteBuffer.allocate(n);
            this.buffer.putShort((short)string.length());
            Charset charset = Charset.forName("US-ASCII");
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.encode(CharBuffer.wrap(string), this.buffer, true);
            this.buffer.put((byte)(byArray != null ? 1 : 0));
            if (byArray != null) {
                this.buffer.put(byArray, 0, 20);
            }
            this.buffer.rewind();
        }

        public int length() {
            return (this.buffer.getShort(0) & 0xFFFF) + (this.hashPresent() ? 23 : 3);
        }

        public ByteBuffer buffer() {
            return (ByteBuffer)this.buffer.duplicate().limit(this.length());
        }

        public String url() {
            Charset charset = Charset.forName("ASCII");
            return charset.decode(this.urlBuffer()).toString();
        }

        public int urlLength() {
            return this.buffer.getShort(0) & 0xFFFF;
        }

        public ByteBuffer urlBuffer() {
            int n = this.urlLength();
            return ((ByteBuffer)this.buffer.duplicate().position(2).limit(2 + n)).slice();
        }

        public boolean hashPresent() {
            int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
            byte by = this.buffer.get(n);
            if (by == 0) {
                return false;
            }
            if (by == 1) {
                return true;
            }
            throw new IllegalArgumentException("expecting 0 or 1: " + (by & 0xFF));
        }

        public byte[] sha1Hash() {
            int n = (this.buffer.getShort(0) & 0xFFFF) + 2;
            byte by = this.buffer.get(n);
            if (by == 0) {
                return null;
            }
            byte[] byArray = new byte[20];
            ((ByteBuffer)this.buffer.duplicate().position(n + 1)).get(byArray);
            return byArray;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(String string) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("struct {");
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  url = ");
            printWriter.print(this.url());
            printWriter.println(";");
            boolean bl = this.hashPresent();
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  hash_present = ");
            printWriter.print(bl);
            printWriter.println(";");
            if (bl) {
                if (string != null) {
                    printWriter.print(string);
                }
                printWriter.print("  sha1Hash = ");
                printWriter.print(Util.toHexString(this.sha1Hash(), ':'));
                printWriter.println(";");
            }
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("} URLAndOptionalHash;");
            return stringWriter.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CertChainType {
        INDIVIDUAL_CERTS(0),
        PKIPATH(1);

        private final int value;

        private CertChainType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements java.util.Iterator<URLAndOptionalHash> {
        private int index = 0;

        @Override
        public URLAndOptionalHash next() throws NoSuchElementException {
            try {
                return CertificateURL.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < CertificateURL.this.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

