/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.ClientCertificateTypeList;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.X500PrincipalList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CertificateRequest
implements Handshake.Body {
    protected ByteBuffer buffer;

    public CertificateRequest(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public int length() {
        int n = (this.buffer.get(0) & 0xFF) + 1;
        return n + (this.buffer.getShort(n) & 0xFFFF) + 2;
    }

    public ClientCertificateTypeList types() {
        return new ClientCertificateTypeList(this.buffer.duplicate());
    }

    public X500PrincipalList authorities() {
        int n = (this.buffer.get(0) & 0xFF) + 1;
        return new X500PrincipalList(((ByteBuffer)this.buffer.position(n)).slice());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = "  ";
        if (string != null) {
            string2 = string + "  ";
        }
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  types =");
        printWriter.println(this.types().toString(string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("  authorities =");
        printWriter.println(this.authorities().toString(string2));
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.print("} CertificateRequest;");
        return stringWriter.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientCertificateType {
        RSA_SIGN(1),
        DSS_SIGN(2),
        RSA_FIXED_DH(3),
        DSS_FIXED_DH(4);

        private final int value;

        private ClientCertificateType(int n2) {
            this.value = n2;
        }

        static ClientCertificateType forValue(int n) {
            switch (n) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
            }
            throw new IllegalArgumentException("unknown client certificate type: " + n);
        }

        public int getValue() {
            return this.value;
        }
    }
}

