/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.Handshake;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Certificate
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CertificateType type;

    public Certificate(ByteBuffer byteBuffer, CertificateType certificateType) {
        byteBuffer.getClass();
        ((Object)((Object)certificateType)).getClass();
        this.buffer = byteBuffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.type = certificateType;
    }

    @Override
    public int length() {
        return ((this.buffer.get(0) & 0xFF) << 24 | this.buffer.getShort(1)) + 3;
    }

    public List<java.security.cert.Certificate> certificates() throws CertificateException, NoSuchAlgorithmException {
        LinkedList<java.security.cert.Certificate> linkedList = new LinkedList<java.security.cert.Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type.toString());
        int n = (this.buffer.get(0) & 0xFF) << 16 | this.buffer.getShort(1) & 0xFFFF;
        ByteBuffer byteBuffer = (ByteBuffer)this.buffer.duplicate().position(3);
        int n2 = 3;
        while (n2 < n) {
            int n3 = (byteBuffer.get() & 0xFF) << 16 | byteBuffer.getShort() & 0xFFFF;
            byte[] byArray = new byte[n3];
            byteBuffer.position(n2 + 3);
            byteBuffer.get(byArray);
            linkedList.add(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
            byteBuffer.position(n2 += n3 + 3);
        }
        return linkedList;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (string != null) {
            printWriter.print(string);
        }
        printWriter.println("struct {");
        try {
            List<java.security.cert.Certificate> list2 = this.certificates();
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  certificateList: [");
            printWriter.print(list2.size());
            printWriter.println("] {");
            for (java.security.cert.Certificate certificate : list2) {
                if (string != null) {
                    printWriter.print(string);
                }
                printWriter.print("    ");
                if (certificate instanceof X509Certificate) {
                    printWriter.print(((X509Certificate)certificate).getSubjectDN());
                } else {
                    printWriter.print(certificate);
                }
                printWriter.println(";");
            }
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.println("  };");
        }
        catch (CertificateException certificateException) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.print(certificateException);
            printWriter.println(";");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (string != null) {
                printWriter.print(string);
            }
            printWriter.print("  ");
            printWriter.print(noSuchAlgorithmException);
            printWriter.println(";");
        }
        printWriter.print("} Certificate;");
        return stringWriter.toString();
    }
}

