/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.lang.CPStringBuilder;
import java.io.Serializable;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.crypto.SealedObject;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

public abstract class Session
implements SSLSession,
Serializable {
    protected final long creationTime = System.currentTimeMillis();
    protected long lastAccessedTime;
    protected int applicationBufferSize = 16384;
    protected ID sessionId;
    protected Certificate[] localCerts;
    protected Certificate[] peerCerts;
    protected X509Certificate[] peerCertChain;
    protected String peerHost;
    protected int peerPort;
    protected boolean peerVerified;
    protected HashMap<String, Object> values = new HashMap();
    protected boolean valid;
    protected boolean truncatedMac = false;
    protected transient SecureRandom random;
    protected transient SSLSessionContext context;

    protected Session() {
    }

    public void access() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public int getApplicationBufferSize() {
        return this.applicationBufferSize;
    }

    public String getCipherSuite() {
        return null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.sessionId.id();
    }

    public ID id() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public Certificate[] getLocalCertificates() {
        if (this.localCerts == null) {
            return null;
        }
        return (Certificate[])this.localCerts.clone();
    }

    public Principal getLocalPrincipal() {
        if (this.localCerts != null && this.localCerts[0] instanceof java.security.cert.X509Certificate) {
            return ((java.security.cert.X509Certificate)this.localCerts[0]).getSubjectDN();
        }
        return null;
    }

    public int getPacketBufferSize() {
        return this.applicationBufferSize + 2048;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCerts == null) {
            return null;
        }
        return (Certificate[])this.peerCerts.clone();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCertChain == null) {
            return null;
        }
        return (X509Certificate[])this.peerCertChain.clone();
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (!this.peerVerified) {
            throw new SSLPeerUnverifiedException("peer not verified");
        }
        if (this.peerCertChain == null) {
            return null;
        }
        return this.peerCertChain[0].getSubjectDN();
    }

    public SSLSessionContext getSessionContext() {
        return this.context;
    }

    public String[] getValueNames() {
        Set<String> set = this.values.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void putValue(String string, Object object) {
        this.values.put(string, object);
        try {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeValue(String string) {
        Object object = this.values.remove(string);
        try {
            if (object instanceof SSLSessionBindingListener) {
                ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isTruncatedMac() {
        return this.truncatedMac;
    }

    public abstract void prepare(char[] var1) throws SSLException;

    public abstract void repair(char[] var1) throws SSLException;

    public abstract SealedObject privateData() throws SSLException;

    public abstract void setPrivateData(SealedObject var1) throws SSLException;

    public static final class ID
    implements Comparable,
    Serializable {
        static final long serialVersionUID = 7887036954666565936L;
        private final byte[] id;

        public ID(byte[] byArray) {
            if (byArray.length > 32) {
                throw new IllegalArgumentException("session ID's are limited to 32 bytes");
            }
            this.id = (byte[])byArray.clone();
        }

        public byte[] id() {
            return (byte[])this.id.clone();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ID)) {
                return false;
            }
            return Arrays.equals(this.id, ((ID)object).id);
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.id.length; ++i) {
                n |= (this.id[i] & 0xFF) << ((i & 3) << 3);
            }
            return n;
        }

        public int compareTo(Object object) {
            byte[] byArray = ((ID)object).id;
            if (this.id.length != byArray.length) {
                return this.id.length < byArray.length ? -1 : 1;
            }
            for (int i = 0; i < this.id.length; ++i) {
                if ((this.id[i] & 0xFF) < (byArray[i] & 0xFF)) {
                    return -1;
                }
                if ((this.id[i] & 0xFF) <= (byArray[i] & 0xFF)) continue;
                return 1;
            }
            return 0;
        }

        public String toString() {
            CPStringBuilder cPStringBuilder = new CPStringBuilder(3 * this.id.length + 1);
            for (int i = 0; i < this.id.length; ++i) {
                int n = this.id[i] & 0xFF;
                cPStringBuilder.append(Character.forDigit(n >>> 4 & 0xF, 16));
                cPStringBuilder.append(Character.forDigit(n & 0xF, 16));
                if (i == this.id.length - 1) continue;
                cPStringBuilder.append(':');
            }
            return cPStringBuilder.toString();
        }
    }
}

