/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.security.Engine;
import gnu.javax.net.ssl.SSLProtocolVersion;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public abstract class SSLCipherSuite {
    private static final String SERVICE = "SSLCipherSuite";
    private final String algorithm;
    private final byte[] id;
    private final SSLProtocolVersion version;
    private Provider provider;

    protected SSLCipherSuite(String string, byte[] byArray, SSLProtocolVersion sSLProtocolVersion) {
        this.algorithm = string;
        if (byArray.length != 2) {
            throw new IllegalArgumentException("cipher suite ID must be two bytes");
        }
        this.id = (byte[])byArray.clone();
        this.version = sSLProtocolVersion;
    }

    public static final SSLCipherSuite getInstance(SSLProtocolVersion sSLProtocolVersion, byte[] byArray) throws NoSuchAlgorithmException {
        return SSLCipherSuite.getInstance((Object)((Object)sSLProtocolVersion) + "-" + (byArray[0] & 0xFF) + "/" + (byArray[1] & 0xFF));
    }

    public static final SSLCipherSuite getInstance(SSLProtocolVersion sSLProtocolVersion, byte[] byArray, Provider provider) throws NoSuchAlgorithmException {
        return SSLCipherSuite.getInstance((Object)((Object)sSLProtocolVersion) + "-" + (byArray[0] & 0xFF) + "/" + (byArray[1] & 0xFF), provider);
    }

    public static final SSLCipherSuite getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SSLCipherSuite.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("SSLCipherSuite: " + string);
    }

    public static final SSLCipherSuite getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        SSLCipherSuite sSLCipherSuite = null;
        try {
            sSLCipherSuite = (SSLCipherSuite)Engine.getInstance(SERVICE, string, provider);
            sSLCipherSuite.provider = provider;
        }
        catch (InvocationTargetException invocationTargetException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string);
            noSuchAlgorithmException.initCause(invocationTargetException);
            throw noSuchAlgorithmException;
        }
        return sSLCipherSuite;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] getId() {
        return (byte[])this.id.clone();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SSLProtocolVersion getProtocolVersion() {
        return this.version;
    }

    public abstract void encipher(ByteBuffer var1, ByteBuffer var2);
}

