/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.jndi.url.rmi;

import gnu.javax.naming.jndi.url.rmi.ContextContinuation;
import gnu.javax.naming.jndi.url.rmi.ListBindingsEnumeration;
import gnu.javax.naming.jndi.url.rmi.ListEnumeration;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class rmiURLContext
implements Context {
    public static final String DEFAULT_REGISTRY_LOCATION = "rmi://localhost:1099";
    static WeakHashMap registryCache = new WeakHashMap();
    Properties properties = new Properties();
    boolean lookupCalled;

    public Object addToEnvironment(String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        return this.properties.put(string, object);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.properties.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registry getRegistry(String string) throws NamingException {
        Registry registry;
        WeakHashMap weakHashMap = registryCache;
        synchronized (weakHashMap) {
            registry = (Registry)registryCache.get(string);
        }
        if (registry == null) {
            int n;
            int n2 = string.lastIndexOf(58);
            try {
                if (n2 >= 0) {
                    n = Integer.parseInt(string.substring(n2 + 1));
                    string = string.substring(0, n2);
                } else {
                    n = 1099;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidNameException(string);
            }
            try {
                registry = LocateRegistry.getRegistry(string, n);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException.toString());
            }
            WeakHashMap weakHashMap2 = registryCache;
            synchronized (weakHashMap2) {
                registryCache.put(string, registry);
            }
        }
        return registry;
    }

    public rmiURLContext(Map map) {
        if (map != null) {
            this.properties.putAll(map);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void bind(String string, Object object) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            this.getRegistry(stringArray[0]).bind(stringArray[1], (Remote)object);
        }
        catch (AccessException accessException) {
            throw new NamingException("access:" + accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new NameAlreadyBoundException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + object.getClass().getName());
        }
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String string) throws NamingException {
        if (string.length() == 0) {
            return new rmiURLContext(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        return this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            if (stringArray[1].length() > 0) {
                throw new InvalidNameException(string + ", the name part must be empty");
            }
            return new ListEnumeration(this.getRegistry(stringArray[0]).list());
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            if (stringArray[1].length() > 0) {
                throw new InvalidNameException(string + ", the name part must be empty");
            }
            Registry registry = this.getRegistry(stringArray[0]);
            return new ListBindingsEnumeration(registry.list(), registry);
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return new ContextContinuation(this.properties, this.getRegistry(string));
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            this.getRegistry(stringArray[0]).rebind(stringArray[1], (Remote)object);
        }
        catch (AccessException accessException) {
            throw new NamingException("access:" + accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + object.getClass().getName());
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public synchronized void rename(String string, String string2) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            Registry registry = this.getRegistry(stringArray[0]);
            Remote remote = registry.lookup(stringArray[1]);
            registry.unbind(string);
            try {
                String[] stringArray2 = this.split(string2);
                Registry registry2 = this.getRegistry(stringArray2[0]);
                registry2.bind(stringArray2[1], remote);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                try {
                    registry.bind(string, remote);
                }
                catch (AlreadyBoundException alreadyBoundException2) {
                    throw new InternalError();
                }
                throw new NameAlreadyBoundException(string2);
            }
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new CommunicationException(notBoundException.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String string) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            this.getRegistry(stringArray[0]).unbind(stringArray[1]);
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new CommunicationException(notBoundException.toString());
        }
    }

    public void close() throws NamingException {
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        try {
            String[] stringArray = this.split(string);
            return this.getRegistry(stringArray[0]).lookup(stringArray[1]);
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new NameNotFoundException(string);
        }
    }

    public String[] split(String string) throws NamingException {
        String string2;
        String string3;
        if (!string.startsWith("rmi://")) {
            throw new InvalidNameException(string + " should be like 'rmi://localhost:1099/name'");
        }
        String string4 = string.substring("rmi://".length());
        int n = string4.indexOf(47);
        while (n > 0 && string4.charAt(n - 1) == '\\') {
            n = string4.indexOf(47, n + 1);
        }
        if (n >= 0) {
            string3 = string4.substring(0, n);
            string2 = string4.substring(n + 1);
        } else {
            string3 = string4;
            string2 = "";
        }
        return new String[]{string3, string2};
    }
}

