/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.jndi.url.rmi;

import gnu.javax.naming.jndi.url.rmi.ListBindingsEnumeration;
import gnu.javax.naming.jndi.url.rmi.ListEnumeration;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class RmiContinuation
implements Context {
    public static final String DEFAULT_REGISTRY_LOCATION = "rmi://localhost:1099";
    Registry registry;
    Properties properties = new Properties();
    boolean lookupCalled;

    public Object addToEnvironment(String string, Object object) {
        this.removeRegistry();
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        return this.properties.put(string, object);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        this.removeRegistry();
        return this.properties.remove(string);
    }

    public void removeRegistry() {
        this.registry = null;
    }

    public Registry getRegistry() throws NamingException {
        if (this.registry == null) {
            int n;
            String string = this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
            if (!string.startsWith("rmi://")) {
                throw new InvalidNameException(string);
            }
            String string2 = string.substring("rmi://".length());
            int n2 = string2.lastIndexOf(58);
            try {
                if (n2 >= 0) {
                    n = Integer.parseInt(string2.substring(n2 + 1));
                    string2 = string2.substring(0, n2);
                } else {
                    n = 1099;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidNameException(string);
            }
            try {
                this.registry = LocateRegistry.getRegistry(string2, n);
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(remoteException.toString());
            }
        }
        return this.registry;
    }

    public RmiContinuation(Map map) {
        if (map != null) {
            this.properties.putAll(map);
        }
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public void bind(String string, Object object) throws NamingException {
        try {
            this.getRegistry().bind(string, (Remote)object);
        }
        catch (AccessException accessException) {
            throw new NamingException("access:" + accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (AlreadyBoundException alreadyBoundException) {
            throw new NameAlreadyBoundException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + object.getClass().getName());
        }
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            return new RmiContinuation(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String string) throws NamingException {
        if (string.length() == 0) {
            return new RmiContinuation(this.properties);
        }
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        return this.properties.getProperty("java.naming.provider.url", DEFAULT_REGISTRY_LOCATION);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.size() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        return this.list("");
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.length() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        try {
            return new ListEnumeration(this.getRegistry().list());
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.size() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        return this.listBindings("");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.length() > 0) {
            throw new OperationNotSupportedException("Only empty name is accepted");
        }
        try {
            Registry registry = this.getRegistry();
            return new ListBindingsEnumeration(registry.list(), registry);
        }
        catch (Exception exception) {
            throw new NamingException(exception.toString());
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        try {
            this.getRegistry().rebind(string, (Remote)object);
        }
        catch (AccessException accessException) {
            throw new NamingException("access:" + accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new NamingException("Only Remote can be bound:" + object.getClass().getName());
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    public synchronized void rename(String string, String string2) throws NamingException {
        try {
            Registry registry = this.getRegistry();
            Remote remote = registry.lookup(string);
            registry.unbind(string);
            try {
                registry.bind(string2, remote);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                try {
                    registry.bind(string, remote);
                }
                catch (AlreadyBoundException alreadyBoundException2) {
                    throw new InternalError();
                }
                throw new NameAlreadyBoundException(string2);
            }
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new CommunicationException(notBoundException.toString());
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String string) throws NamingException {
        try {
            this.getRegistry().unbind(string);
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new CommunicationException(notBoundException.toString());
        }
    }

    public void close() throws NamingException {
        this.removeRegistry();
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        try {
            return this.getRegistry().lookup(string);
        }
        catch (AccessException accessException) {
            throw new NamingException(accessException.toString());
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(remoteException.toString());
        }
        catch (NotBoundException notBoundException) {
            throw new NameNotFoundException(string);
        }
    }
}

